/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.constraints;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.DataAgeTime;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Constraints-DataAgeTime", checks={"Maximum time must not be smaller than minimum time"})
public class TAConstraintsDataAgeTime
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getDataAgeTime();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof DataAgeTime) {
            DataAgeTime dat = (DataAgeTime)eObject;
            INamed namedContainer = (INamed)AmaltheaServices.getContainerOfType((EObject)dat, INamed.class);
            Time minimum = dat.getMinimumTime();
            Time maximum = dat.getMaximumTime();
            if (maximum != null && minimum != null && minimum.compareTo(maximum) > 0) {
                this.addIssue(results, (EObject)dat, (EStructuralFeature)ePackage.getDataAgeTime_MinimumTime(), "The minimum time is greater than the maximum time (" + minimum + " > " + maximum + ", in " + this.objectInfo((EObject)namedContainer) + ")");
            }
        }
    }
}

