/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.ta.basic;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeGaussDistribution;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="TA-Basic-TimeGaussDistribution-mean", checks={"Mean must not be less than the lower bound", "Mean must not be greater than the upper bound"})
public class TABasicTimeGaussDistribution
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getTimeGaussDistribution();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof TimeGaussDistribution) {
            TimeGaussDistribution tgd = (TimeGaussDistribution)eObject;
            INamed namedContainer = (INamed)AmaltheaServices.getContainerOfType((EObject)tgd, INamed.class);
            Time mean = tgd.getMean();
            if (mean != null) {
                Time upper;
                Time lower = tgd.getLowerBound();
                if (lower != null && lower.compareTo(mean) > 0) {
                    this.addIssue(results, (EObject)tgd, (EStructuralFeature)ePackage.getTimeGaussDistribution_Mean(), String.valueOf(this.getEClassifier().getName()) + ": mean is less than the lower bound: (" + mean + " < " + lower + ", in " + this.objectInfo((EObject)namedContainer) + ")");
                }
                if ((upper = tgd.getUpperBound()) != null && upper.compareTo(mean) < 0) {
                    this.addIssue(results, (EObject)tgd, (EStructuralFeature)ePackage.getTimeGaussDistribution_Mean(), String.valueOf(this.getEClassifier().getName()) + ": mean is greater than the upper bound: (" + mean + " > " + upper + ", in " + this.objectInfo((EObject)namedContainer) + ")");
                }
            }
        }
    }
}

