/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard.util;

import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ArrowPainter {
    private Paint arrowColor;
    private double[] lineDashes;

    public ArrowPainter() {
        this((Paint)Color.ORANGE, new double[]{6.0, 3.0});
    }

    public ArrowPainter(Paint arrowColor, double[] lineDashes) {
        this.arrowColor = arrowColor;
        this.lineDashes = lineDashes;
    }

    public void paint(GraphicsContext gc, double startX, double startY, double endX, double endY) {
        Paint previousStroke = gc.getStroke();
        double[] previousDashes = gc.getLineDashes();
        gc.setStroke(this.arrowColor);
        gc.setLineDashes(this.lineDashes);
        gc.strokeLine(startX, startY, endX, endY);
        double factor = 10.0 / Math.hypot(startX - endX, startY - endY);
        double factorO = 7.0 / Math.hypot(startX - endX, startY - endY);
        double dx = (startX - endX) * factor;
        double dy = (startY - endY) * factor;
        double ox = (startX - endX) * factorO;
        double oy = (startY - endY) * factorO;
        gc.setLineDashes(new double[]{0.0});
        gc.strokeLine(endX + dx - oy, endY + dy + ox, endX, endY);
        gc.strokeLine(endX + dx + oy, endY + dy - ox, endX, endY);
        gc.setStroke(previousStroke);
        gc.setLineDashes(previousDashes);
    }
}

