/*********************************************************************************
 * Copyright (c) 2021 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */ 

package org.eclipse.app4mc.amalthea.model.editor.contribution.service.creation;

import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.editor.contribution.service.CreationService;
import org.eclipse.app4mc.amalthea.model.predefined.AmaltheaTemplates;
import org.eclipse.app4mc.amalthea.model.predefined.StandardSchedulers.Algorithm;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

abstract class AbstractSchedulerDefinitionCreationService implements CreationService {

	@Override
	public EStructuralFeature modelFeature() {
		return AmaltheaPackage.eINSTANCE.getOSModel_SchedulerDefinitions();
	}
	
	public void doCreate(OSModel osModel, Algorithm algorithm, String label) {
		if (osModel == null)
			return;

		final EObject rootContainer = EcoreUtil.getRootContainer(osModel);

		// Use ChangeCommand and CommandStack to execute changes

		EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(rootContainer);
		ChangeCommand command = new ChangeCommand(new ChangeRecorder(), rootContainer) {
			@Override
			protected void doExecute() {
				// *** execute specific service actions here ***
				AmaltheaTemplates.addStandardSchedulerDefinition(osModel, algorithm);
			}
		};
		command.setLabel(label);

		editingDomain.getCommandStack().execute(command);
	}

}
