/**
 ********************************************************************************
 * Copyright (c) 2015-2018 Robert Bosch GmbH and others.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * *******************************************************************************
 */

package org.eclipse.app4mc.amalthea.model.edit.common.extended;

import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.edit.ExtendedCommonElementsIP;
import org.eclipse.app4mc.amalthea.model.provider.MemoryClassifierItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class ExtendedMemoryClassifierIP extends MemoryClassifierItemProvider {

	public ExtendedMemoryClassifierIP(final AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getParent(java.lang.Object)
	 */
	@Override
	public Object getParent(final Object object) {
		final Object commonElements = super.getParent(object);
		final ExtendedCommonElementsIP commonElementsItemProvider = (ExtendedCommonElementsIP) this.adapterFactory
				.adapt(commonElements, ITreeItemContentProvider.class);
		return commonElementsItemProvider != null ? commonElementsItemProvider.getMemoryClassifiersContainerIP((CommonElements) commonElements) : null;
	}

}
