/**
 ********************************************************************************
 * Copyright (c) 2020 Eclipse APP4MC contributors.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 ********************************************************************************
 */

package org.eclipse.app4mc.atdb._import.btf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.eclipse.app4mc.amalthea.model.ProcessEventType;
import org.eclipse.app4mc.amalthea.model.RunnableEventType;
import org.eclipse.app4mc.atdb.EntityType;

public enum BTFEntityType implements EntityType<Enum<?>> {

	PROCESS(ProcessEventType.class, "T", "I"),
	RUNNABLE(RunnableEventType.class, "R");

	private static final Map<String, BTFEntityType> name2Literal = Stream.of(values()).collect(Collectors.toMap(et -> et.entityTypeName, et -> et));
	public static final List<BTFEntityType> literals = Collections.unmodifiableList(Arrays.asList(BTFEntityType.values()));

	private final List<String> traceAliases;
	private final String entityTypeName;

	private BTFEntityType(final Class<? extends Enum<?>> eventTypeEnum, final String... traceAlias) {
		this.traceAliases = Collections.unmodifiableList(Arrays.asList(traceAlias));
		String entityTypeName = eventTypeEnum.getSimpleName();
		entityTypeName = entityTypeName.substring(0, entityTypeName.indexOf("EventType")).toLowerCase();
		this.entityTypeName = entityTypeName;
		
	}

	@Override
	public String getName() {
		return this.entityTypeName;
	}
	
	public boolean isTraceAlias(final String traceAlias) {
		return this.traceAliases.stream().anyMatch(traceAlias::equals);
	}
	
	@Override
	public List<String> getTraceAliases() {
		return this.traceAliases;
	}
	
	public static BTFEntityType getForName(final String name) {
		return name2Literal.get(name);
	}
	
	@Override
	public Set<Enum<?>> getPossibleEvents() {
		return BTFEntityState.getPossibleEventsFor(this);
	}

	@Override
	public List<String> getValidityConstraints() {
		return BTFEntityState.getValidityConstraints(this);
	}

}
