/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.ui.dialog.ModelMigrationDialog;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelMigrationJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;

public class AmaltheaModelMigrationHandler {
    private static final String MODEL_MIGRATION = "AMALTHEA Model Migration";
    private static final String SIMPLE_MIGRATION = "simplemigration";

    @Execute
    public void execute(Shell shell, @Service MigrationProcessor migrationProcessor, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") ISelection selection, @Optional @Named(value="executioncontext") @Named(value="executioncontext") String executionContext, @Optional @Named(value="APP4MC_MODEL_VERSION") @Named(value="APP4MC_MODEL_VERSION") String modelEditorVersion) {
        if (selection instanceof TreeSelection) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (MigrationSettings migrationSettings = new MigrationSettings();){
                ArrayList<File> inputModels = new ArrayList<File>();
                IProject iProject = this.getProjectFromSelection((TreeSelection)selection, shell);
                if (iProject == null) {
                    return;
                }
                String path = iProject.getLocation().toOSString();
                File file = new File(path);
                migrationSettings.setProject(file);
                IContainer selectedContainer = this.collectInput((TreeSelection)selection, inputModels, shell);
                if (modelEditorVersion != null) {
                    migrationSettings.setMigrationModelVersion(modelEditorVersion);
                }
                try {
                    List modelFiles = MigrationHelper.populateModels(inputModels, (MigrationSettings)migrationSettings);
                    migrationSettings.getMigModelFiles().addAll(modelFiles);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)shell, (String)MODEL_MIGRATION, (String)("Failed to load model files: " + e.getLocalizedMessage()));
                    if (migrationSettings != null) {
                        migrationSettings.close();
                    }
                    return;
                }
                if (this.isSimpleMigration(executionContext) && migrationSettings.getMigModelFiles().size() == 1) {
                    MigrationInputFile migrationInputFile = (MigrationInputFile)migrationSettings.getMigModelFiles().get(0);
                    migrationSettings.setOutputDirectoryLocation(migrationInputFile.getOriginalFile().getParent());
                    migrationSettings.setCreateBackupFile(true);
                    ModelMigrationJob migrationJob = new ModelMigrationJob(MODEL_MIGRATION, migrationProcessor, migrationSettings, iProject);
                    migrationJob.setUser(true);
                    migrationJob.schedule();
                } else {
                    ModelMigrationDialog dialog = new ModelMigrationDialog(shell, migrationProcessor, migrationSettings, iProject);
                    dialog.setSelectedContainer(selectedContainer);
                    dialog.open();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private IProject getProjectFromSelection(TreeSelection selection, Shell shell) {
        TreePath[] paths = selection.getPaths();
        String projectSegment = null;
        IProject iProject = null;
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object firstSegment = treePath.getFirstSegment();
            if (projectSegment == null) {
                projectSegment = firstSegment.toString();
                iProject = (IProject)((IAdaptable)firstSegment).getAdapter(IProject.class);
                if (iProject == null) {
                    firstSegment = treePath.getSegment(1);
                    projectSegment = firstSegment.toString();
                    iProject = (IProject)((IAdaptable)firstSegment).getAdapter(IProject.class);
                }
            } else if (!projectSegment.equals(firstSegment.toString())) {
                MessageDialog.openError((Shell)shell, (String)MODEL_MIGRATION, (String)"Migration across multiple projects is not supported.");
            }
            ++n2;
        }
        return iProject;
    }

    private IContainer collectInput(TreeSelection selection, List<File> inputModels, Shell shell) {
        HashSet<IContainer> iContainerSet = new HashSet<IContainer>();
        this.populateContainerSet(selection, iContainerSet);
        for (IContainer iContainer : iContainerSet) {
            try {
                IResource[] iResourceArray = iContainer.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (this.isLocalFileWithModelExtension(member)) {
                        this.addFileToList(member, inputModels, shell);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)shell, (String)MODEL_MIGRATION, (String)("Failed to collect model files in container: " + e.getLocalizedMessage()));
            }
        }
        return iContainerSet.isEmpty() ? null : iContainerSet.iterator().next();
    }

    private void populateContainerSet(TreeSelection selection, HashSet<IContainer> iContainerSet) {
        TreePath[] treePathArray = selection.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof IAdaptable) {
                IFile iFile = (IFile)((IAdaptable)lastSegment).getAdapter(IFile.class);
                if (iFile != null) {
                    if (this.isLocalFileWithModelExtension((IResource)iFile)) {
                        iContainerSet.add(iFile.getParent());
                    }
                } else {
                    IContainer iContainer = (IContainer)((IAdaptable)lastSegment).getAdapter(IContainer.class);
                    if (iContainer != null) {
                        iContainerSet.add(iContainer);
                    }
                }
            }
            ++n2;
        }
    }

    private void addFileToList(IResource member, List<File> inputModels, Shell shell) {
        File file = new File(member.getLocation().toString());
        try {
            inputModels.add(file.getCanonicalFile());
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)MODEL_MIGRATION, (String)("Error fetching the file '" + file + "': " + e.getLocalizedMessage()));
        }
    }

    private boolean isLocalFileWithModelExtension(IResource resource) {
        return resource instanceof IFile && resource.exists() && resource.getLocation() != null && MigrationHelper.isModelFileExtension((String)resource.getFileExtension());
    }

    private boolean isSimpleMigration(String context) {
        return context != null && SIMPLE_MIGRATION.equals(context);
    }
}

