/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.javafx.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.visualizations.javafx.util.RunnablePainter;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;

public final class RunnableHelper {
    public static final double CANVAS_MAX = 6000.0;
    private static final String SCALE_FACTOR_KEY = "ScaleFactor";

    private RunnableHelper() {
    }

    public static double[] calculateGrid(int count) {
        double rows;
        if (count == 3) {
            return new double[]{3.0, 1.0};
        }
        double sqrt = Math.sqrt(count);
        double columns = Math.ceil(sqrt);
        double cells = columns * (rows = Math.max(1.0, Math.floor(sqrt)));
        if (cells < (double)count) {
            rows += 1.0;
        }
        return new double[]{columns, rows};
    }

    public static double[] calculateMinimumCellDimensions(double[] grid, List<RunnablePainter> painter) {
        double minWidth = 0.0;
        double minHeight = 0.0;
        int count = 0;
        RunnablePainter p = null;
        int row = 0;
        while ((double)row < grid[1]) {
            int column = 0;
            while ((double)column < grid[0]) {
                if (count >= painter.size()) break;
                p = painter.get(count);
                minWidth = Math.max(minWidth, p.getPreferredMinimumWidth());
                minHeight = Math.max(minHeight, p.getPreferredMinimumHeight());
                ++count;
                ++column;
            }
            ++row;
        }
        return new double[]{minWidth, minHeight};
    }

    public static List<Runnable> getRunnableDependencies(SWModel swModel, Runnable runnable, boolean collectTransitive) {
        List<Label> readItems = SoftwareUtil.getReadLabelAccessList((Runnable)runnable, null).stream().map(LabelAccess::getData).toList();
        List<Label> writeItems = SoftwareUtil.getWriteLabelAccessList((Runnable)runnable, null).stream().map(LabelAccess::getData).toList();
        ArrayList<Runnable> dependencies = new ArrayList<Runnable>();
        RunnableHelper.collectReadDependencies(swModel, readItems, dependencies, collectTransitive);
        Collections.reverse(dependencies);
        dependencies.remove(runnable);
        dependencies.add(runnable);
        RunnableHelper.collectWriteDependencies(swModel, writeItems, dependencies, collectTransitive);
        return dependencies;
    }

    public static void collectReadDependencies(SWModel swModel, List<Label> readItems, List<Runnable> collected, boolean collectTransitive) {
        List<Runnable> directReadDependency = swModel.getRunnables().stream().filter(r -> {
            List<Label> wItems = SoftwareUtil.getWriteLabelAccessList((Runnable)r, null).stream().map(LabelAccess::getData).toList();
            for (Label l : readItems) {
                if (!wItems.contains(l)) continue;
                return true;
            }
            return false;
        }).filter(item -> !collected.contains(item)).toList();
        collected.addAll(directReadDependency);
        if (collectTransitive) {
            directReadDependency.forEach(dependency -> {
                List<Label> read = SoftwareUtil.getReadLabelAccessList((Runnable)dependency, null).stream().map(LabelAccess::getData).toList();
                RunnableHelper.collectReadDependencies(swModel, read, collected, collectTransitive);
            });
        }
    }

    public static void collectWriteDependencies(SWModel swModel, List<Label> writeItems, List<Runnable> collected, boolean collectTransitive) {
        List<Runnable> directWriteDependency = swModel.getRunnables().stream().filter(r -> {
            List<Label> rItems = SoftwareUtil.getReadLabelAccessList((Runnable)r, null).stream().map(LabelAccess::getData).toList();
            for (Label l : writeItems) {
                if (!rItems.contains(l)) continue;
                return true;
            }
            return false;
        }).filter(item -> !collected.contains(item)).toList();
        collected.addAll(directWriteDependency);
        if (collectTransitive) {
            directWriteDependency.forEach(dependency -> {
                List<Label> write = SoftwareUtil.getWriteLabelAccessList((Runnable)dependency, null).stream().map(LabelAccess::getData).toList();
                RunnableHelper.collectWriteDependencies(swModel, write, collected, collectTransitive);
            });
        }
    }

    public static void setMaxScaleFactor(List<RunnablePainter> painters) {
        RunnableHelper.setMaxScaleFactor(painters, RunnableHelper.calculateGrid(painters.size()));
    }

    public static void setMaxScaleFactor(List<RunnablePainter> painters, double[] grid) {
        double[] minDim = RunnableHelper.calculateMinimumCellDimensions(grid, painters);
        double max = Math.max(grid[0] * minDim[0], grid[1] * minDim[1]);
        double factor = 6000.0 / max;
        painters.forEach(p -> p.setMaxScaleFactor(factor));
    }

    public static double getScaleFactor(VisualizationParameters parameters) {
        return Double.parseDouble(parameters.getOrDefault((Object)SCALE_FACTOR_KEY, "1.0"));
    }

    public static void setInitialScaleFactor(List<RunnablePainter> painters, VisualizationParameters parameters) {
        double initialFactor = RunnableHelper.getScaleFactor(parameters);
        painters.forEach(p -> p.setScaleFactor(initialFactor));
    }

    public static void persistScaleFactor(double scaleFactor, VisualizationParameters parameters) {
        parameters.put(SCALE_FACTOR_KEY, String.valueOf(scaleFactor));
    }
}

