/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.ui.registry;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.app4mc.visualization.ui.registry.ModelVisualization;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ModelVisualizationRegistry.class})
public class ModelVisualizationRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelVisualizationRegistry.class);
    private ConcurrentHashMap<String, List<ModelVisualization>> visualizationRegistry = new ConcurrentHashMap();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void bindModelVisualization(Visualization visualization, Map<String, Object> properties) {
        String modelClassName = this.getModelClassName(visualization, properties);
        if (modelClassName != null) {
            List visualizations = this.visualizationRegistry.computeIfAbsent(modelClassName, key -> new CopyOnWriteArrayList());
            String id = (String)properties.getOrDefault("id", visualization.getClass().getName());
            if (visualizations.stream().noneMatch(v -> v.getId().equals(id))) {
                visualizations.add(new ModelVisualization(id, visualization, (String)properties.getOrDefault("name", visualization.getClass().getSimpleName()), properties.getOrDefault("description", null), modelClassName));
            } else {
                LOGGER.error("A visualization with the ID {} already exists!", (Object)id);
            }
        } else {
            LOGGER.error("Unable to extract model class name for Visualization {}", (Object)visualization.getClass().getName());
        }
    }

    void unbindModelVisualization(Visualization visualization, Map<String, Object> properties) {
        String modelClassName = this.getModelClassName(visualization, properties);
        if (modelClassName != null) {
            this.visualizationRegistry.remove(modelClassName);
        }
    }

    public List<ModelVisualization> getVisualizations(List<Class<?>> classes) {
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            classNames.add(clazz.getName());
            List allInterfaces = ClassUtils.getAllInterfaces(clazz);
            classNames.addAll(allInterfaces.stream().map(Class::getName).toList());
        }
        return classNames.stream().filter(Objects::nonNull).flatMap(name -> this.visualizationRegistry.getOrDefault(name, Collections.emptyList()).stream()).toList();
    }

    public Set<ModelVisualization> getAllVisualizations() {
        return this.visualizationRegistry.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    private String getModelClassName(Visualization visualization, Map<String, Object> properties) {
        String modelClassName = properties.getOrDefault("modelClass", null);
        if (modelClassName == null) {
            Method[] methods;
            Class<?> visuClass = visualization.getClass();
            Method[] methodArray = methods = visuClass.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?>[] parameterTypes;
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(PostConstruct.class) && (parameterTypes = method.getParameterTypes()).length > 0) {
                    if (Collection.class.isAssignableFrom(parameterTypes[0])) {
                        void firstType;
                        Type[] genericParameterTypes = method.getGenericParameterTypes();
                        Type type = genericParameterTypes[0];
                        if (!(type instanceof ParameterizedType)) break;
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        ParameterizedType cfr_ignored_0 = (ParameterizedType)type;
                        Type[] typeArguments = firstType.getActualTypeArguments();
                        modelClassName = typeArguments.length > 0 ? typeArguments[0].getTypeName() : null;
                        break;
                    }
                    modelClassName = parameterTypes[0].getName();
                    break;
                }
                ++n2;
            }
        }
        return modelClassName;
    }
}

