/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.parser.XpandParseFacade;
import org.eclipse.internal.xpand2.pr.ProtectedRegionResolverImpl;
import org.eclipse.internal.xtend.util.ProfileCollector;
import org.eclipse.internal.xtend.xtend.parser.ParseException;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends AbstractExpressionsUsingWorkflowComponent {
    private static final String COMPONENT_NAME = "Xpand Generator";
    private String genPath = null;
    private String srcPath = null;
    private String prSrcPaths = null;
    private String prExcludes = null;
    private boolean prDefaultExcludes = true;
    private String expand = null;
    private String fileEncoding = System.getProperty("file.encoding");
    private List<?> beautifier = new ArrayList();
    private final List<String> advices = new ArrayList<String>();
    private final List<String> extensionAdvices = new ArrayList<String>();
    private boolean automaticHyphens = false;
    private String collectProfileSummary = null;
    private String verboseProfileFilename = null;
    private Output output = null;
    private final List<Outlet> outlets = new ArrayList<Outlet>(2);
    private List<Outlet> initializedOutlets = null;

    public void setCollectProfileSummary(String summary) {
        this.collectProfileSummary = summary;
    }

    public void setVerboseProfileFilename(String fileName) {
        this.verboseProfileFilename = fileName;
    }

    public void setAutomaticHyphens(boolean automaticHyphens) {
        this.automaticHyphens = automaticHyphens;
    }

    public String getLogMessage() {
        HashSet<String> outletDescriptions = new HashSet<String>();
        for (Outlet outlet : this.outlets) {
            outletDescriptions.add(outlet.toString());
        }
        String outletDesc = outletDescriptions.size() == 1 ? (String)outletDescriptions.iterator().next() : ((Object)outletDescriptions).toString();
        return "generating '" + this.expand + "' => " + outletDesc;
    }

    public void addAdvice(String advice) {
        if (!this.advices.contains(advice)) {
            this.advices.add(advice);
        }
    }

    public void addExtensionAdvice(String extensionAdvice) {
        if (!this.extensionAdvices.contains(extensionAdvice)) {
            this.extensionAdvices.add(extensionAdvice);
        }
    }

    public List<?> getBeautifier() {
        return this.beautifier;
    }

    public void setBeautifier(List<?> beautifiers) {
        this.beautifier = beautifiers;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Deprecated
    public void setGenPath(String genPath) {
        this.genPath = this.fixPath(genPath);
    }

    public void setExpand(String invoke) {
        this.expand = invoke;
    }

    public void setPrDefaultExcludes(boolean prDefaultExcludes) {
        this.prDefaultExcludes = prDefaultExcludes;
    }

    public void setPrExcludes(String prExcludes) {
        this.prExcludes = prExcludes;
    }

    public void setPrSrcPaths(String prSrcPathes) {
        this.prSrcPaths = prSrcPathes;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Deprecated
    public void setSrcPath(String srcPath) {
        this.srcPath = this.fixPath(srcPath);
    }

    private String fixPath(String p) {
        if (p.endsWith("\\")) {
            return p.replace('\\', '/');
        }
        if (p.endsWith("/")) {
            return p;
        }
        return String.valueOf(p) + "/";
    }

    protected void invokeInternal2(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        String string;
        int n;
        int n2;
        String[] stringArray;
        String[] names;
        BufferedOutputStream verboseProfileOutputStream = null;
        if (this.verboseProfileFilename != null) {
            try {
                verboseProfileOutputStream = new BufferedOutputStream(new FileOutputStream(this.verboseProfileFilename));
                ProfileCollector.getInstance().setDetailedLoggingWriter((OutputStream)verboseProfileOutputStream);
            }
            catch (IOException exc) {
                this.log.warn((Object)"Could not open profiling log file", (Throwable)exc);
            }
        }
        Output out = this.getOutput();
        List<Outlet> outlets = this.getInitializedOutlets();
        for (Outlet outlet : outlets) {
            out.addOutlet(outlet);
        }
        ProtectedRegionResolverImpl prs = null;
        if (this.prSrcPaths != null) {
            prs = new ProtectedRegionResolverImpl();
            prs.setDefaultExcludes(this.prDefaultExcludes);
            prs.setIgnoreList(this.prExcludes);
            prs.setSrcPathes(this.prSrcPaths);
            prs.setFileEncoding(this.fileEncoding);
        }
        ResourceManager resourceManager = this.getResourceManager();
        XpandExecutionContextImpl executionContext = new XpandExecutionContextImpl(resourceManager, out, prs, this.getGlobalVars(ctx), monitor, this.exceptionHandler, this.getNullEvaluationHandler(), this.callback);
        for (MetaModel mm : this.metaModels) {
            executionContext.registerMetaModel(mm);
        }
        ExpandStatement es = this.getStatement();
        if (es == null) {
            throw new ConfigurationException("property 'expand' has wrong syntax!");
        }
        String[] stringArray2 = names = ctx.getSlotNames();
        int n3 = names.length;
        int n4 = 0;
        while (n4 < n3) {
            String name = stringArray2[n4];
            executionContext = (XpandExecutionContextImpl)executionContext.cloneWithVariable(new Variable(name, ctx.get(name)));
            ++n4;
        }
        for (String advice : this.advices) {
            String[] allAdvices;
            stringArray = allAdvices = advice.split(",");
            n2 = allAdvices.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                executionContext.registerAdvices(string.trim());
                ++n;
            }
        }
        for (String advice : this.extensionAdvices) {
            String[] allAdvices;
            stringArray = allAdvices = advice.split(",");
            n2 = allAdvices.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                executionContext.registerExtensionAdvices(string.trim());
                ++n;
            }
        }
        es.evaluate(executionContext);
        for (Outlet element : outlets) {
            String name = String.valueOf(element.getName() == null ? "[default]" : element.getName()) + "(" + element.getPath() + ")";
            if (element.getFilesWrittenAndClosed() > 0) {
                this.log.info((Object)("Written " + element.getFilesWrittenAndClosed() + " files to outlet " + name));
            }
            if (element.getFilesCreated() <= element.getFilesWrittenAndClosed()) continue;
            this.log.info((Object)("Skipped writing of " + (element.getFilesCreated() - element.getFilesWrittenAndClosed()) + " files to outlet " + name));
        }
        ProfileCollector.getInstance().finish();
        if ("true".equalsIgnoreCase(this.collectProfileSummary)) {
            this.log.info((Object)("profiling info: \n" + ProfileCollector.getInstance().toString()));
        }
        if (verboseProfileOutputStream != null) {
            try {
                ((OutputStream)verboseProfileOutputStream).close();
            }
            catch (IOException exc) {
                this.log.warn((Object)"problem closing profile log file", (Throwable)exc);
            }
        }
    }

    public void addOutlet(Outlet outlet) {
        this.outlets.add(outlet);
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    private Output getOutput() {
        if (this.output == null) {
            OutputImpl out = new OutputImpl();
            out.setAutomaticHyphens(this.automaticHyphens);
            this.output = out;
        }
        return this.output;
    }

    private List<Outlet> getInitializedOutlets() {
        if (this.initializedOutlets == null) {
            ArrayList<Outlet> result = new ArrayList<Outlet>(this.outlets);
            if (result.isEmpty()) {
                Outlet o;
                if (this.genPath != null) {
                    o = new Outlet();
                    o.setAppend(false);
                    o.setFileEncoding(this.fileEncoding);
                    o.setOverwrite(true);
                    o.setPath(this.genPath);
                    result.add(o);
                    o = new Outlet();
                    o.setAppend(true);
                    o.setFileEncoding(this.fileEncoding);
                    o.setName("APPEND");
                    o.setOverwrite(true);
                    o.setPath(this.genPath);
                    result.add(o);
                }
                if (this.srcPath != null) {
                    o = new Outlet();
                    o.setAppend(false);
                    o.setFileEncoding(this.fileEncoding);
                    o.setName("ONCE");
                    o.setOverwrite(false);
                    o.setPath(this.srcPath);
                    result.add(o);
                }
            }
            for (Outlet o : result) {
                if (o.postprocessors.isEmpty()) {
                    for (Object name : this.beautifier) {
                        PostProcessor element = (PostProcessor)name;
                        o.addPostprocessor(element);
                    }
                }
                if (o.getFileEncoding() != null) continue;
                o.setFileEncoding(this.fileEncoding);
            }
            this.initializedOutlets = result;
        }
        return this.initializedOutlets;
    }

    public final List<Outlet> getOutlets() {
        return Collections.unmodifiableList(this.getInitializedOutlets());
    }

    private ExpandStatement getStatement() {
        Template tpl = XpandParseFacade.file(new StringReader("\u00abDEFINE test FOR test\u00bb\u00abEXPAND " + this.expand + "\u00bb" + "\u00ab" + "ENDDEFINE" + "\u00bb"), null);
        ExpandStatement es = null;
        try {
            es = (ExpandStatement)((Definition)tpl.getDefinitions()[0]).getBody()[1];
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return es;
    }

    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.genPath == null && this.getInitializedOutlets().isEmpty()) {
            issues.addError((WorkflowComponent)this, "You need to configure at least one outlet!");
        }
        if (!(this.genPath == null && this.srcPath == null || this.outlets.isEmpty())) {
            issues.addWarning((WorkflowComponent)this, "'genPath' and 'srcPath' properties are ignored since you have specified outlets!");
        }
        int defaultOutlets = 0;
        for (Outlet o : this.getInitializedOutlets()) {
            if (o.getName() != null) continue;
            ++defaultOutlets;
        }
        if (defaultOutlets > 1) {
            issues.addError((WorkflowComponent)this, "Only one outlet can be the default outlet. Please specifiy a name for the other outlets!");
        } else if (defaultOutlets == 0) {
            issues.addWarning((WorkflowComponent)this, "No default outlet configured!");
        }
        if (this.expand == null) {
            issues.addError((WorkflowComponent)this, "property 'expand' not configured!");
        } else {
            try {
                ExpandStatement es = this.getStatement();
                if (es == null) {
                    issues.addError((WorkflowComponent)this, "property 'expand' has wrong syntax!");
                }
            }
            catch (ParseException e) {
                issues.addError((WorkflowComponent)this, "property 'expand' has wrong syntax : " + e.getMessage());
            }
        }
    }
}

