/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.emf.mwe.internal.core.debug.communication.PackageReceiver;
import org.eclipse.emf.mwe.internal.core.debug.communication.PackageSender;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.AbstractPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.HandshakePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection {
    private ServerSocket ssocket;
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private PackageSender sender;
    private PackageReceiver receiver;

    public AbstractPackage listenForPackage(Class<? extends AbstractPackage> type) throws InterruptedIOException {
        return this.receiver.getPackage(type, -1L);
    }

    public AbstractPackage listenForPackage(Class<? extends AbstractPackage> type, int refId) throws InterruptedIOException {
        return this.receiver.getPackage(type, refId, -1L);
    }

    public int sendPackage(AbstractPackage packet) throws IOException {
        if (this.sender == null) {
            return -1;
        }
        return this.sender.sendPackage(packet);
    }

    public void startListeningSocket(int port) throws IOException {
        this.ssocket = new ServerSocket(port);
    }

    public void accept(int timeout) throws IOException {
        this.ssocket.setSoTimeout(timeout);
        this.socket = this.ssocket.accept();
        this.establishReaderAndWriter();
        if (!this.writeHandshake()) {
            throw new IOException("handshake failed");
        }
    }

    public void connect(int port) throws IOException {
        this.socket = new Socket("localhost", port);
        this.establishReaderAndWriter();
        this.replyHandshake();
    }

    public boolean isConnected() {
        return this.socket != null && !this.socket.isClosed();
    }

    public void close() {
        try {
            if (this.sender != null) {
                this.sender.close();
            }
            if (this.socket != null) {
                this.out.close();
                this.in.close();
                this.socket.close();
                this.out = null;
                this.in = null;
            }
            this.sender = null;
            this.socket = null;
            this.ssocket.close();
            this.ssocket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected AbstractPackage readPackage() throws IOException {
        String className = this.in.readUTF();
        AbstractPackage packet = this.instantiatePackage(className);
        packet.readContent(this.in);
        return packet;
    }

    private AbstractPackage instantiatePackage(String className) throws IOException {
        Class<?> packetClass = null;
        AbstractPackage packet = null;
        String msg = null;
        try {
            packetClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            msg = "Couldn't find " + className + " in the classpath.";
        }
        if (msg == null && packetClass != null) {
            Constructor<?> c = packetClass.getConstructors()[0];
            Class<?>[] parmTypes = c.getParameterTypes();
            Object[] initargs = new Object[parmTypes.length];
            int i = 0;
            while (i < parmTypes.length) {
                if (parmTypes[i] == Integer.TYPE) {
                    initargs[i] = 0;
                }
                ++i;
            }
            try {
                packet = (AbstractPackage)c.newInstance(initargs);
            }
            catch (IllegalArgumentException e) {
                msg = "Couldn't instantiate " + c + " : " + e;
            }
            catch (InstantiationException e) {
                msg = "Couldn't instantiate " + c + " : " + e;
            }
            catch (IllegalAccessException e) {
                msg = "Couldn't instantiate " + c + " : " + e;
            }
            catch (InvocationTargetException e) {
                msg = "Problem during instantiation of " + c + " : " + e.getTargetException();
            }
        }
        if (msg != null) {
            System.err.println(msg);
            throw new IOException(msg);
        }
        return packet;
    }

    protected void writePackage(AbstractPackage packet) throws IOException {
        this.out.writeUTF(packet.getClass().getName());
        packet.writeContent(this.out);
    }

    private void establishReaderAndWriter() throws IOException {
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.in = new DataInputStream(this.socket.getInputStream());
        this.receiver = PackageReceiver.newPackageReceiver(this);
        this.sender = PackageSender.newPackageSender(this);
    }

    private boolean writeHandshake() throws IOException {
        HandshakePackage packet = new HandshakePackage();
        this.sendPackage(packet);
        return this.listenForPackage(HandshakePackage.class).getClass().equals(HandshakePackage.class);
    }

    private void replyHandshake() throws IOException {
        if (!this.listenForPackage(HandshakePackage.class).getClass().equals(HandshakePackage.class)) {
            throw new IOException("handshake failed");
        }
        this.sendPackage(new HandshakePackage());
    }
}

