/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.model.elements.ElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.ui.IMemento;

public class BreakpointMementoProvider
extends ElementMementoProvider {
    private static final String MARKER_ID = "MARKER_ID";
    private static final String RESOURCE_PATH = "RESOURCE_PATH";

    protected boolean supportsContextId(String id) {
        return "org.eclipse.debug.ui.BreakpointView".equals(id);
    }

    protected boolean encodeElement(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        IMarker marker;
        if (element instanceof IBreakpoint && (marker = ((IBreakpoint)element).getMarker()) != null) {
            long markerId = marker.getId();
            memento.putString(MARKER_ID, Long.toString(markerId));
            IPath fullPath = marker.getResource().getFullPath();
            String path = fullPath.toString();
            memento.putString(RESOURCE_PATH, path);
            return true;
        }
        return false;
    }

    protected boolean isEqual(Object element, IMemento memento, IPresentationContext context) throws CoreException {
        if (element instanceof IBreakpoint) {
            String mementoPath;
            IBreakpoint breakpoint = (IBreakpoint)element;
            IMarker marker = breakpoint.getMarker();
            long markerId = marker.getId();
            String mementoMarkerId = memento.getString(MARKER_ID);
            if (!Long.toString(markerId).equals(mementoMarkerId)) {
                return false;
            }
            IPath fullPath = marker.getResource().getFullPath();
            String path = fullPath.toString();
            return path.equals(mementoPath = memento.getString(RESOURCE_PATH));
        }
        return false;
    }
}

