/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.ui.frameworks.taskwizard.CompoundTask;
import org.eclipse.birt.core.ui.frameworks.taskwizard.composites.NavTree;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ISubtaskSheet;
import org.eclipse.birt.core.ui.frameworks.taskwizard.internal.SubtaskHistory;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;

public class TreeCompoundTask
extends CompoundTask {
    protected Composite cmpSubtaskContainer;
    protected NavTree navTree;
    private SubtaskHistory history;
    private boolean needHistory = true;
    protected static final String INDEX_SEPARATOR = " - ";
    private Map<String, String> lastSubtaskRegistry = new HashMap<String, String>();
    private Map<String, String> lastPopupRegistry = new HashMap<String, String>();

    public TreeCompoundTask(String sLabel, boolean needHistory) {
        super(sLabel);
        this.needHistory = needHistory;
        if (needHistory) {
            this.history = new SubtaskHistory(this);
        }
    }

    public void createControl(Composite parent) {
        if (this.topControl == null || this.topControl.isDisposed()) {
            this.topControl = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            this.topControl.setLayout((Layout)layout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this.topControl.setLayoutData((Object)gridData);
            this.navTree = new NavTree(this.topControl, 2048);
            GridData gridData2 = new GridData(1296);
            gridData2.widthHint = 127;
            this.navTree.setLayoutData(gridData2);
            this.navTree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TreeCompoundTask.this.switchToTreeItem((TreeItem)event.item);
                }
            });
            this.cmpSubtaskContainer = this.createContainer(this.topControl);
        }
        this.updateTree();
        this.switchToDefaultItem();
    }

    protected void switchToDefaultItem() {
        TreeItem defaultSelection = this.getDefaultSelection();
        if (defaultSelection != null) {
            this.switchToTreeItem(defaultSelection);
        }
    }

    protected TreeItem getDefaultSelection() {
        TreeItem lastselection = this.navTree.findTreeItem(this.getSubtaskSelection());
        if (this.navTree.getSelection().length == 0) {
            if (lastselection != null) {
                return lastselection;
            }
            if (this.navTree.getItems().length > 0) {
                return this.navTree.getItems()[0];
            }
            return null;
        }
        return this.navTree.getSelection()[0];
    }

    protected Composite createContainer(Composite parent) {
        Composite cmpTask = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        cmpTask.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        cmpTask.setLayoutData((Object)gridData);
        this.createTitleArea(cmpTask);
        return cmpTask;
    }

    protected Composite createTitleArea(Composite parent) {
        Composite cmpTitle = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmpTitle.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        cmpTitle.setLayoutData((Object)gridData);
        Label label = new Label(cmpTitle, 0);
        label.setFont(JFaceResources.getBannerFont());
        label.setText(this.getTitleAreaString());
        if (this.needHistory) {
            ToolBar historyBar = new ToolBar(cmpTitle, 0x800100);
            GridData gd = new GridData();
            gd.horizontalAlignment = 0x1000008;
            historyBar.setLayoutData((Object)gd);
            ToolBarManager historyManager = new ToolBarManager(historyBar);
            this.history.createHistoryControls(historyBar, historyManager);
            historyManager.update(false);
        } else {
            new Label(cmpTitle, 0);
        }
        return cmpTitle;
    }

    protected String getTitleAreaString() {
        return "";
    }

    protected void populateSubtasks() {
    }

    protected void updateTreeItem() {
    }

    public void updateTree() {
        this.populateSubtasks();
        this.updateTreeItem();
        TreeItem defaultSelection = this.getDefaultSelection();
        if (defaultSelection != null) {
            this.navTree.setSelection(new TreeItem[]{defaultSelection});
        }
    }

    protected ISubtaskSheet getSubtask(String sSubtaskPath) {
        int separatorIndex = sSubtaskPath.indexOf(INDEX_SEPARATOR);
        int subtaskIndex = 0;
        if (separatorIndex > -1) {
            subtaskIndex = Integer.parseInt(sSubtaskPath.substring(separatorIndex + INDEX_SEPARATOR.length()).trim()) - 1;
            sSubtaskPath = sSubtaskPath.substring(0, separatorIndex).trim();
        }
        ISubtaskSheet itask = super.getSubtask(sSubtaskPath);
        itask.setIndex(subtaskIndex);
        return itask;
    }

    protected boolean containSubtask(String sSubtaskPath) {
        int separatorIndex = sSubtaskPath.indexOf(INDEX_SEPARATOR);
        if (separatorIndex > -1) {
            sSubtaskPath = sSubtaskPath.substring(0, separatorIndex).trim();
        }
        return super.containSubtask(sSubtaskPath);
    }

    protected void switchTo(String sSubtaskPath, boolean needSelection) {
        TreeItem treeItem;
        super.switchTo(sSubtaskPath);
        if (needSelection && (treeItem = this.navTree.findTreeItem(sSubtaskPath)) != null) {
            this.navTree.setSelection(new TreeItem[]{treeItem});
        }
        this.createSubtaskArea(this.cmpSubtaskContainer, this.getSubtask(sSubtaskPath));
        this.cmpSubtaskContainer.layout();
        if (this.container != null) {
            this.container.packWizard();
        }
        this.setSubtaskSelection(sSubtaskPath);
        if (this.container != null) {
            this.container.firePageChanged(this.getCurrentSubtask());
        }
        if (this.needHistory) {
            this.history.addHistoryEntry(sSubtaskPath);
        }
    }

    public void switchTo(String sSubtaskPath) {
        this.switchTo(sSubtaskPath, true);
    }

    public void switchToTreeItem(TreeItem treeItem) {
        if (treeItem == null) {
            return;
        }
        this.navTree.setSelection(new TreeItem[]{treeItem});
        this.switchTo(this.navTree.getNodePath(treeItem), false);
    }

    protected void createSubtaskArea(Composite parent, ISubtaskSheet subtask) {
        if (subtask != null) {
            subtask.createControl(parent);
            subtask.attachPopup(this.getPopupSelection());
        }
    }

    public NavTree getNavigatorTree() {
        return this.navTree;
    }

    public void setPopupSelection(String popupName) {
        this.lastPopupRegistry.put(this.getContext().getWizardID(), popupName);
    }

    protected String getPopupSelection() {
        return this.lastPopupRegistry.get(this.getContext().getWizardID());
    }

    protected void setSubtaskSelection(String subtaskPath) {
        this.lastSubtaskRegistry.put(this.getContext().getWizardID(), subtaskPath);
    }

    protected String getSubtaskSelection() {
        return this.lastSubtaskRegistry.get(this.getContext().getWizardID());
    }

    public void dispose() {
        super.dispose();
        if (this.needHistory) {
            this.history.clearHistory();
        }
    }
}

