/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.debug;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.acute.ProjectFileAccessor;
import org.eclipse.acute.debug.DebuggerTab;
import org.eclipse.acute.debug.DebuggersRegistry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DotnetDebugLaunchDelegate
extends DSPLaunchDelegate {
    static final String ID = "org.eclipse.acute.debug.launchType";

    public void launch(ILaunchConfiguration configuration, final String mode, final ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        IContainer container = this.getContainer(configuration);
        if (container == null) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DotnetDebugLaunchDelegate_noFolderSelected_title, (String)Messages.DotnetDebugLaunchDelegate_noFolderSelected_message));
            return;
        }
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", DotnetDebugLaunchDelegate.createDebugParam(container, configuration.getAttribute("PROJECT_ARGUMENTS", "")));
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MODE", "launch server");
        wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false);
        if (wc.getAttribute(DebuggerTab.ATTR_DEFAULT_DEBUGGER, true)) {
            DebuggersRegistry.DebuggerInfo debuggerInfo = DebuggersRegistry.getDefaultDebugger();
            wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_CMD", debuggerInfo.debugger.getAbsolutePath());
            wc.setAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_ARGS", debuggerInfo.args);
        }
        wc.setAttribute("PROJECT_CONFIGURATION", "Debug");
        final ILaunchConfiguration config = wc.doSave();
        IMarker[] iMarkerArray = container.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("severity", -1) == 2) {
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DotnetDebugLaunchDelegate_errorsOnProject_title, (String)Messages.DotnetDebugLaunchDelegate_errorsOnProject_message));
                return;
            }
            ++n2;
        }
        if (this.projectNeedsRebuild()) {
            Job buildJob = Job.create((String)("dotnet build > " + container.getFullPath()), mon -> {
                Process restoreProcess;
                String[] cmdLine = new String[]{AcutePlugin.getDotnetCommand(), "build"};
                try {
                    restoreProcess = DebugPlugin.exec((String[])cmdLine, (File)container.getLocation().toFile());
                }
                catch (CoreException e1) {
                    return new Status(4, "org.eclipse.acute", "", (Throwable)e1);
                }
                try {
                    restoreProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (restoreProcess.exitValue() != 0) {
                    return new Status(4, "org.eclipse.acute", "");
                }
                return Status.OK_STATUS;
            });
            buildJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getResult().isOK()) {
                            DotnetDebugLaunchDelegate.super.launch(config, mode, launch, monitor);
                        } else {
                            launch.terminate();
                        }
                    }
                    catch (Exception ex) {
                        AcutePlugin.logError(ex);
                    }
                    super.done(event);
                }
            });
            buildJob.schedule();
        } else {
            super.launch(config, mode, launch, monitor);
        }
    }

    private boolean projectNeedsRebuild() {
        return true;
    }

    private IContainer getContainer(ILaunchConfiguration configuration) throws CoreException {
        String projectPath = configuration.getAttribute("PROJECT_FOLDER", "");
        if (projectPath == null) {
            return null;
        }
        Path location = new Path(projectPath);
        if (location.toFile().isDirectory()) {
            return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)location);
        }
        if (location.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(location.segments()[0]);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)location);
    }

    static File getProgram(IContainer project) {
        IPath projectFile = ProjectFileAccessor.getProjectFile(project);
        String projectConfiguration = "Debug";
        String[] frameworks = ProjectFileAccessor.getTargetFrameworks(project.getWorkspace().getRoot().getFile(projectFile).getLocation());
        if (frameworks.length > 0) {
            return new File(String.valueOf(project.getLocation().toFile().getAbsolutePath()) + "/bin/" + projectConfiguration + "/" + frameworks[0] + "/" + projectFile.removeFileExtension().addFileExtension("dll").lastSegment());
        }
        return null;
    }

    static String createDebugParam(IContainer project, String programArgs) {
        JsonObject conf = new JsonObject();
        conf.addProperty("request", "launch");
        File program = DotnetDebugLaunchDelegate.getProgram(project);
        conf.addProperty("program", program.getAbsolutePath());
        if (programArgs != null && !programArgs.trim().isEmpty()) {
            JsonArray args = new JsonArray();
            String[] stringArray = programArgs.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                args.add(arg);
                ++n2;
            }
            conf.add("args", (JsonElement)args);
        }
        String dbgParam = new Gson().toJson((JsonElement)conf);
        return dbgParam;
    }
}

