/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests.dotnetnew;

import java.util.Arrays;
import org.eclipse.acute.SWTBotTests.AbstractDotnetTest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.ui.IWorkingSet;
import org.junit.Assert;

public class AbstractNewWizardTest
extends AbstractDotnetTest {
    @Override
    public void setup() throws CoreException {
        this.buildEmptyProject();
    }

    protected SWTBotShell openWizard() {
        bot = new SWTWorkbenchBot();
        bot.menu("File").menu("New").menu("Other...").click();
        bot.waitUntil(Conditions.shellIsActive((String)"New"));
        SWTBotShell shell = bot.shell("New");
        shell.activate();
        bot.tree().expandNode(new String[]{".NET Core"}).select(".NET Core Project");
        bot.button("Next >").click();
        while (!bot.list(0).itemAt(0).equals("No available templates") && !bot.list(0).isEnabled()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return shell;
    }

    protected IProject checkProjectCreate(SWTBotShell shell, IWorkingSet[] workingSets) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String pathToFolder = bot.textWithLabel("Location").getText();
        String projectName = bot.textWithLabel("Project name").getText();
        Boolean isTemplateSelected = bot.list(0).selectionCount() != 0;
        IContainer container = root.getContainerForLocation((IPath)new Path(pathToFolder));
        int beforeFileCount = 0;
        if (container != null) {
            try {
                beforeFileCount = container.members().length;
            }
            catch (CoreException e) {
                Assert.fail((String)"Unable to get containing folder content");
            }
        }
        bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)bot.button("Finish")), 60000L);
        bot.button("Finish").click();
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 60000L);
        IProject createdProject = root.getProject(projectName);
        Assert.assertTrue((String)"No .project file", (createdProject.getFile(".project") != null ? 1 : 0) != 0);
        try {
            if (isTemplateSelected.booleanValue() && !dotnetVersion.isEmpty() && dotnetVersion.matches("2\\..*") || dotnetVersion.matches("^1\\.1.*")) {
                Assert.assertTrue((String)"No files created with wizard", (createdProject.members().length > beforeFileCount + 1 ? 1 : 0) != 0);
            }
        }
        catch (CoreException e) {
            Assert.fail((String)"Unable to get project folder content");
        }
        if (workingSets != null) {
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                Assert.assertTrue((String)("Project not part of Working Set " + iWorkingSet.getName()), (boolean)Arrays.asList(iWorkingSet.getElements()).contains(createdProject));
                ++n2;
            }
        }
        return createdProject;
    }
}

