/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug.ls;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.acceleo.debug.DSLSource;
import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.acceleo.debug.event.debugger.BreakpointReply;
import org.eclipse.acceleo.debug.event.debugger.DeleteVariableReply;
import org.eclipse.acceleo.debug.event.debugger.ResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SetCurrentInstructionReply;
import org.eclipse.acceleo.debug.event.debugger.SetVariableValueReply;
import org.eclipse.acceleo.debug.event.debugger.SpawnRunningThreadReply;
import org.eclipse.acceleo.debug.event.debugger.StepIntoResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepOverResumingReply;
import org.eclipse.acceleo.debug.event.debugger.StepReturnResumingReply;
import org.eclipse.acceleo.debug.event.debugger.SteppedReply;
import org.eclipse.acceleo.debug.event.debugger.SuspendedReply;
import org.eclipse.acceleo.debug.event.debugger.TerminatedReply;
import org.eclipse.acceleo.debug.event.debugger.VariableReply;
import org.eclipse.acceleo.debug.event.model.AbstractModelEventProcessor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.CompletionsArguments;
import org.eclipse.lsp4j.debug.CompletionsResponse;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.ContinuedEventArguments;
import org.eclipse.lsp4j.debug.DataBreakpointInfoArguments;
import org.eclipse.lsp4j.debug.DataBreakpointInfoResponse;
import org.eclipse.lsp4j.debug.DisassembleArguments;
import org.eclipse.lsp4j.debug.DisassembleResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExceptionInfoArguments;
import org.eclipse.lsp4j.debug.ExceptionInfoResponse;
import org.eclipse.lsp4j.debug.FunctionBreakpoint;
import org.eclipse.lsp4j.debug.GotoArguments;
import org.eclipse.lsp4j.debug.GotoTargetsArguments;
import org.eclipse.lsp4j.debug.GotoTargetsResponse;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.LoadedSourcesArguments;
import org.eclipse.lsp4j.debug.LoadedSourcesResponse;
import org.eclipse.lsp4j.debug.ModulesArguments;
import org.eclipse.lsp4j.debug.ModulesResponse;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.ReadMemoryArguments;
import org.eclipse.lsp4j.debug.ReadMemoryResponse;
import org.eclipse.lsp4j.debug.RestartArguments;
import org.eclipse.lsp4j.debug.RestartFrameArguments;
import org.eclipse.lsp4j.debug.ReverseContinueArguments;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArguments;
import org.eclipse.lsp4j.debug.RunInTerminalResponse;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetDataBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetDataBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetExpressionArguments;
import org.eclipse.lsp4j.debug.SetExpressionResponse;
import org.eclipse.lsp4j.debug.SetFunctionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetFunctionBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceArguments;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepBackArguments;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepInTargetsArguments;
import org.eclipse.lsp4j.debug.StepInTargetsResponse;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminateThreadsArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSLDebugServer
extends AbstractModelEventProcessor
implements IDebugProtocolServer {
    private IDebugProtocolClient client;
    private IDSLDebugger debugger;
    private boolean launched;
    private Map<String, Object> arguments;
    private final Map<Long, Map<String, Object>> frameIDToVariables = new HashMap<Long, Map<String, Object>>();
    private final ILabelProvider eLabelProvider;

    public DSLDebugServer() {
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.eLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory);
    }

    public void setDebugger(IDSLDebugger debugger) {
        this.debugger = debugger;
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        System.out.println("initialize");
        return CompletableFuture.supplyAsync(new Supplier<Capabilities>(){

            @Override
            public Capabilities get() {
                Capabilities res = DSLDebugServer.this.getCapabilities();
                DSLDebugServer.this.client.initialized();
                return res;
            }
        });
    }

    private Capabilities getCapabilities() {
        Capabilities res = new Capabilities();
        res.setSupportsCompletionsRequest(Boolean.valueOf(true));
        res.setSupportsConditionalBreakpoints(Boolean.valueOf(true));
        res.setSupportsConfigurationDoneRequest(Boolean.valueOf(true));
        res.setSupportsDataBreakpoints(Boolean.valueOf(false));
        res.setSupportsDelayedStackTraceLoading(Boolean.valueOf(false));
        res.setSupportsDisassembleRequest(Boolean.valueOf(false));
        res.setSupportsEvaluateForHovers(Boolean.valueOf(false));
        res.setSupportsExceptionInfoRequest(Boolean.valueOf(false));
        res.setSupportsExceptionOptions(Boolean.valueOf(false));
        res.setSupportsFunctionBreakpoints(Boolean.valueOf(false));
        res.setSupportsGotoTargetsRequest(Boolean.valueOf(false));
        res.setSupportsHitConditionalBreakpoints(Boolean.valueOf(true));
        res.setSupportsLoadedSourcesRequest(Boolean.valueOf(false));
        res.setSupportsLogPoints(Boolean.valueOf(false));
        res.setSupportsModulesRequest(Boolean.valueOf(false));
        res.setSupportsReadMemoryRequest(Boolean.valueOf(false));
        res.setSupportsRestartFrame(Boolean.valueOf(false));
        res.setSupportsRestartRequest(Boolean.valueOf(false));
        res.setSupportsSetExpression(Boolean.valueOf(false));
        res.setSupportsSetVariable(Boolean.valueOf(false));
        res.setSupportsStepBack(Boolean.valueOf(false));
        res.setSupportsStepInTargetsRequest(Boolean.valueOf(false));
        res.setSupportsTerminateRequest(Boolean.valueOf(true));
        res.setSupportsTerminateThreadsRequest(Boolean.valueOf(true));
        res.setSupportsValueFormattingOptions(Boolean.valueOf(false));
        return res;
    }

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(final SetBreakpointsArguments args) {
        System.out.println("setBreakpoints");
        return CompletableFuture.supplyAsync(new Supplier<SetBreakpointsResponse>(){

            @Override
            public SetBreakpointsResponse get() {
                return DSLDebugServer.this.getSetBreakpointResponse(args);
            }
        });
    }

    private SetBreakpointsResponse getSetBreakpointResponse(SetBreakpointsArguments args) {
        SetBreakpointsResponse res = new SetBreakpointsResponse();
        ArrayList<Breakpoint> responseBreakpoints = new ArrayList<Breakpoint>();
        this.debugger.clearBreakPoints();
        SourceBreakpoint[] sourceBreakpointArray = args.getBreakpoints();
        int n = sourceBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            SourceBreakpoint requestedBreakpoint = sourceBreakpointArray[n2];
            long column = requestedBreakpoint.getColumn() != null ? requestedBreakpoint.getColumn() : 0L;
            EObject instruction = this.debugger.getInstruction(args.getSource().getPath(), requestedBreakpoint.getLine().longValue(), column);
            if (instruction != null) {
                this.debugger.addBreakPoint(EcoreUtil.getURI((EObject)instruction));
                Breakpoint responseBreakpoint = new Breakpoint();
                DSLSource dslSource = this.debugger.getSource(instruction);
                if (dslSource != null) {
                    Source source = new Source();
                    source.setPath(dslSource.getPath());
                    responseBreakpoint.setVerified(Boolean.valueOf(true));
                    responseBreakpoint.setSource(source);
                    responseBreakpoint.setLine(Long.valueOf(dslSource.getStartLine()));
                    responseBreakpoint.setColumn(Long.valueOf(dslSource.getStartColumn()));
                    responseBreakpoint.setEndLine(Long.valueOf(dslSource.getEndLine()));
                    responseBreakpoint.setEndColumn(Long.valueOf(dslSource.getEndColumn()));
                    responseBreakpoints.add(responseBreakpoint);
                }
            }
            ++n2;
        }
        res.setBreakpoints(responseBreakpoints.toArray(new Breakpoint[responseBreakpoints.size()]));
        return res;
    }

    public CompletableFuture<SetFunctionBreakpointsResponse> setFunctionBreakpoints(final SetFunctionBreakpointsArguments args) {
        System.out.println("setFunctionBreakpoints");
        return CompletableFuture.supplyAsync(new Supplier<SetFunctionBreakpointsResponse>(){

            @Override
            public SetFunctionBreakpointsResponse get() {
                SetFunctionBreakpointsResponse res = new SetFunctionBreakpointsResponse();
                ArrayList responseBreakpoints = new ArrayList();
                FunctionBreakpoint[] functionBreakpointArray = args.getBreakpoints();
                int n = functionBreakpointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FunctionBreakpoint functionBreakpoint = functionBreakpointArray[n2];
                    ++n2;
                }
                res.setBreakpoints(responseBreakpoints.toArray(new Breakpoint[responseBreakpoints.size()]));
                return res;
            }
        });
    }

    public CompletableFuture<Void> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        System.out.println("setExceptionBreakpoints");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
            }
        });
    }

    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        System.out.println("configurationDone");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                if (DSLDebugServer.this.launched) {
                    DSLDebugServer.this.debugger.start();
                }
            }
        });
    }

    public CompletableFuture<Void> launch(final Map<String, Object> args) {
        System.out.println("launch");
        this.launched = true;
        this.arguments = args;
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                Object noDebug = DSLDebugServer.this.arguments.get("noDebug");
                if (noDebug instanceof Boolean && ((Boolean)noDebug).booleanValue()) {
                    DSLDebugServer.this.debugger.initialize(true, args);
                } else {
                    DSLDebugServer.this.debugger.initialize(false, args);
                }
                OutputEventArguments args2 = new OutputEventArguments();
                args2.setOutput(new String());
                DSLDebugServer.this.client.output(args2);
            }
        });
    }

    public CompletableFuture<Void> attach(Map<String, Object> args) {
        System.out.println("attach");
        this.arguments = args;
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
            }
        });
    }

    public CompletableFuture<Void> pause(final PauseArguments args) {
        System.out.println("pause");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                DSLDebugServer.this.debugger.suspend(args.getThreadId());
            }
        });
    }

    public CompletableFuture<ContinueResponse> continue_(final ContinueArguments args) {
        System.out.println("continue_");
        return CompletableFuture.supplyAsync(new Supplier<ContinueResponse>(){

            @Override
            public ContinueResponse get() {
                ContinueResponse res = new ContinueResponse();
                DSLDebugServer.this.debugger.resume(args.getThreadId());
                res.setAllThreadsContinued(Boolean.valueOf(false));
                return res;
            }
        });
    }

    public CompletableFuture<Void> next(final NextArguments args) {
        System.out.println("next");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                DSLDebugServer.this.debugger.stepOver(args.getThreadId());
            }
        });
    }

    public CompletableFuture<Void> stepIn(final StepInArguments args) {
        System.out.println("stepIn");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                DSLDebugServer.this.debugger.stepInto(args.getThreadId());
            }
        });
    }

    public CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        System.out.println("setVariable");
        return CompletableFuture.supplyAsync(new Supplier<SetVariableResponse>(){

            @Override
            public SetVariableResponse get() {
                SetVariableResponse res = new SetVariableResponse();
                return res;
            }
        });
    }

    public CompletableFuture<Void> terminateThreads(final TerminateThreadsArguments args) {
        System.out.println("terminateThreads");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                Long[] longArray = args.getThreadIds();
                int n = longArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Long threadId = longArray[n2];
                    DSLDebugServer.this.debugger.terminate(threadId);
                    ++n2;
                }
            }
        });
    }

    public CompletableFuture<Void> terminate(TerminateArguments args) {
        System.out.println("terminate");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                DSLDebugServer.this.debugger.terminate();
            }
        });
    }

    public CompletableFuture<Void> disconnect(final DisconnectArguments args) {
        System.out.println("disconnect");
        this.eLabelProvider.dispose();
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                if (DSLDebugServer.this.launched || args.getTerminateDebuggee().booleanValue()) {
                    DSLDebugServer.this.debugger.terminate();
                }
                DSLDebugServer.this.debugger.disconnect();
            }
        });
    }

    public CompletableFuture<CompletionsResponse> completions(CompletionsArguments args) {
        System.out.println("completions");
        return null;
    }

    public CompletableFuture<DataBreakpointInfoResponse> dataBreakpointInfo(DataBreakpointInfoArguments args) {
        System.out.println("dataBreakpointInfo");
        return null;
    }

    public CompletableFuture<DisassembleResponse> disassemble(DisassembleArguments args) {
        System.out.println("disassemble");
        return null;
    }

    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        System.out.println("evaluate");
        return null;
    }

    public CompletableFuture<ExceptionInfoResponse> exceptionInfo(ExceptionInfoArguments args) {
        System.out.println("exceptionInfo");
        return null;
    }

    public CompletableFuture<Void> goto_(GotoArguments args) {
        System.out.println("goto_");
        return null;
    }

    public CompletableFuture<GotoTargetsResponse> gotoTargets(GotoTargetsArguments args) {
        System.out.println("gotoTargets");
        return null;
    }

    public CompletableFuture<LoadedSourcesResponse> loadedSources(LoadedSourcesArguments args) {
        System.out.println("loadedSources");
        return null;
    }

    public CompletableFuture<ModulesResponse> modules(ModulesArguments args) {
        System.out.println("modules");
        return null;
    }

    public CompletableFuture<ReadMemoryResponse> readMemory(ReadMemoryArguments args) {
        System.out.println("readMemory");
        return null;
    }

    public CompletableFuture<Void> restart(RestartArguments args) {
        System.out.println("restart");
        return null;
    }

    public CompletableFuture<Void> restartFrame(RestartFrameArguments args) {
        System.out.println("restartFrame");
        return null;
    }

    public CompletableFuture<Void> reverseContinue(ReverseContinueArguments args) {
        System.out.println("reverseContinue");
        return null;
    }

    public CompletableFuture<RunInTerminalResponse> runInTerminal(RunInTerminalRequestArguments args) {
        System.out.println("runInTerminal");
        return null;
    }

    public CompletableFuture<ScopesResponse> scopes(final ScopesArguments args) {
        System.out.println("scope");
        return CompletableFuture.supplyAsync(new Supplier<ScopesResponse>(){

            @Override
            public ScopesResponse get() {
                return DSLDebugServer.this.getScopesResponse(args);
            }
        });
    }

    private ScopesResponse getScopesResponse(ScopesArguments args) {
        System.out.println(args);
        ScopesResponse res = new ScopesResponse();
        Scope scope = new Scope();
        scope.setName("Variables");
        scope.setVariablesReference(Long.valueOf(args.getFrameId() + 1L));
        res.setScopes(new Scope[]{scope});
        return res;
    }

    public CompletableFuture<SetDataBreakpointsResponse> setDataBreakpoints(SetDataBreakpointsArguments args) {
        System.out.println("setDataBreakpoints");
        return null;
    }

    public CompletableFuture<SetExpressionResponse> setExpression(SetExpressionArguments args) {
        System.out.println("setExpression");
        return null;
    }

    public CompletableFuture<SourceResponse> source(SourceArguments args) {
        System.out.println("source");
        return null;
    }

    public CompletableFuture<StackTraceResponse> stackTrace(final StackTraceArguments args) {
        System.out.println("stackTrace");
        return CompletableFuture.supplyAsync(new Supplier<StackTraceResponse>(){

            @Override
            public StackTraceResponse get() {
                return DSLDebugServer.this.getStackTraceResponse(args);
            }
        });
    }

    private StackTraceResponse getStackTraceResponse(StackTraceArguments args) {
        StackTraceResponse res = new StackTraceResponse();
        ArrayList<StackFrame> resFrames = new ArrayList<StackFrame>();
        Deque stackFrames = this.debugger.getStackFrame(args.getThreadId());
        Iterator it = stackFrames.descendingIterator();
        long id = 0L;
        while (it.hasNext()) {
            org.eclipse.acceleo.debug.util.StackFrame currentFrame = (org.eclipse.acceleo.debug.util.StackFrame)it.next();
            StackFrame resFrame = new StackFrame();
            this.frameIDToVariables.put(id, currentFrame.getVariables());
            resFrame.setId(Long.valueOf(id));
            resFrame.setName(this.eLabelProvider.getText((Object)currentFrame.getContext()));
            DSLSource dslSource = this.debugger.getSource(currentFrame.getInstruction());
            if (dslSource == null) continue;
            resFrame.setLine(Long.valueOf(dslSource.getStartLine()));
            resFrame.setColumn(Long.valueOf(dslSource.getStartColumn()));
            resFrame.setEndLine(Long.valueOf(dslSource.getEndLine()));
            resFrame.setEndColumn(Long.valueOf(dslSource.getEndColumn()));
            Source source = new Source();
            source.setName(dslSource.getPath());
            source.setPath(dslSource.getPath());
            resFrame.setSource(source);
            resFrames.add(resFrame);
            ++id;
        }
        res.setTotalFrames(Long.valueOf(resFrames.size()));
        res.setStackFrames(resFrames.toArray(new StackFrame[resFrames.size()]));
        return res;
    }

    public CompletableFuture<ThreadsResponse> threads() {
        System.out.println("threads");
        return CompletableFuture.supplyAsync(new Supplier<ThreadsResponse>(){

            @Override
            public ThreadsResponse get() {
                ThreadsResponse res = new ThreadsResponse();
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (Map.Entry entry : DSLDebugServer.this.debugger.getThreads().entrySet()) {
                    Thread thread = new Thread();
                    thread.setId((Long)entry.getKey());
                    thread.setName((String)entry.getValue());
                    threads.add(thread);
                }
                res.setThreads(threads.toArray(new Thread[threads.size()]));
                return res;
            }
        });
    }

    public CompletableFuture<Void> stepBack(StepBackArguments args) {
        System.out.println("stepBack");
        return null;
    }

    public CompletableFuture<StepInTargetsResponse> stepInTargets(StepInTargetsArguments args) {
        System.out.println("stepInTargets");
        return null;
    }

    public CompletableFuture<Void> stepOut(final StepOutArguments args) {
        System.out.println("stepOut");
        return CompletableFuture.runAsync(new Runnable(){

            public void run() {
                DSLDebugServer.this.debugger.stepReturn(args.getThreadId());
            }
        });
    }

    public CompletableFuture<VariablesResponse> variables(final VariablesArguments args) {
        System.out.println("variables");
        return CompletableFuture.supplyAsync(new Supplier<VariablesResponse>(){

            @Override
            public VariablesResponse get() {
                return DSLDebugServer.this.getVariablesResponse(args);
            }
        });
    }

    private VariablesResponse getVariablesResponse(VariablesArguments args) {
        VariablesResponse res = new VariablesResponse();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Map<String, Object> vars = this.frameIDToVariables.get(args.getVariablesReference() - 1L);
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            Variable variable = new Variable();
            variable.setName(entry.getKey());
            variable.setEvaluateName(entry.getKey());
            variable.setType(entry.getValue().getClass().getSimpleName());
            variable.setValue(entry.getValue().toString());
            variables.add(variable);
        }
        res.setVariables(variables.toArray(new Variable[variables.size()]));
        return res;
    }

    public void connect(IDebugProtocolClient debugProtocolClient) {
        this.client = debugProtocolClient;
    }

    protected void notifyClientSetVariableValueReply(SetVariableValueReply variableValueReply) {
    }

    protected void notifyClientSetCurrentInstructionReply(SetCurrentInstructionReply setCurrentInstructionReply) {
    }

    protected void notifyClientDeleteVariableReply(DeleteVariableReply deleteVariableReply) {
    }

    protected void notifyClientVariableReply(VariableReply variableReply) {
    }

    protected void notifyClientStepIntoResumingReply(StepIntoResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(Long.valueOf(resumingReply.getThreadID()));
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
        this.client.continued(eventArguments);
    }

    protected void notifyClientStepOverResumingReply(StepOverResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(Long.valueOf(resumingReply.getThreadID()));
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
        this.client.continued(eventArguments);
    }

    protected void notifyClientStepReturnResumingReply(StepReturnResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(Long.valueOf(resumingReply.getThreadID()));
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
        this.client.continued(eventArguments);
    }

    protected void notifyClientResumedReply(ResumingReply resumingReply) {
        ContinuedEventArguments eventArguments = new ContinuedEventArguments();
        eventArguments.setThreadId(Long.valueOf(resumingReply.getThreadID()));
        eventArguments.setAllThreadsContinued(Boolean.valueOf(false));
        this.client.continued(eventArguments);
    }

    protected void notifyClientSpawnRunningThreadReply(SpawnRunningThreadReply spawnThreadReply) {
        ThreadEventArguments eventArguments = new ThreadEventArguments();
        eventArguments.setThreadId(Long.valueOf(spawnThreadReply.getThreadID()));
        eventArguments.setReason("started");
        this.client.thread(eventArguments);
    }

    protected void notifyClientTerminatedReply(TerminatedReply terminatedReply) {
        if (terminatedReply.getThreadID() != null) {
            ThreadEventArguments eventArguments = new ThreadEventArguments();
            eventArguments.setThreadId(Long.valueOf(terminatedReply.getThreadID()));
            eventArguments.setReason("exited");
            this.client.thread(eventArguments);
        } else {
            TerminatedEventArguments eventArguments = new TerminatedEventArguments();
            eventArguments.setRestart((Object)false);
            this.client.terminated(eventArguments);
        }
    }

    protected void notifyClientSteppedReply(SteppedReply suspendReply) {
        StoppedEventArguments argument = new StoppedEventArguments();
        argument.setThreadId(Long.valueOf(suspendReply.getThreadID()));
        argument.setDescription("Paused after a step.");
        argument.setPreserveFocusHint(Boolean.valueOf(true));
        argument.setReason("step");
        argument.setAllThreadsStopped(Boolean.valueOf(false));
        this.client.stopped(argument);
    }

    protected void notifyClientBreakpointReply(BreakpointReply suspendReply) {
        StoppedEventArguments argument = new StoppedEventArguments();
        argument.setThreadId(Long.valueOf(suspendReply.getThreadID()));
        argument.setDescription("Paused after hitting a breakpoint.");
        argument.setPreserveFocusHint(Boolean.valueOf(true));
        argument.setReason("breakpoint");
        argument.setAllThreadsStopped(Boolean.valueOf(false));
        this.client.stopped(argument);
    }

    protected void notifyClientSuspendedReply(SuspendedReply suspendReply) {
        StoppedEventArguments argument = new StoppedEventArguments();
        argument.setThreadId(Long.valueOf(suspendReply.getThreadID()));
        argument.setDescription("Paused after a client request.");
        argument.setPreserveFocusHint(Boolean.valueOf(true));
        argument.setReason("pause");
        argument.setAllThreadsStopped(Boolean.valueOf(false));
        this.client.stopped(argument);
    }
}

