/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.print;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.print.PrintPreview;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PrintPreviewAction
extends Action {
    private GraphicalViewer viewer;

    public PrintPreviewAction(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.setId(ActionFactory.PRINT.getId());
        this.setText(Messages.PrintPreviewAction_LABEL_Print);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT_DISABLED"));
    }

    public boolean isEnabled() {
        if (this.viewer == null) {
            this.viewer = PrintPreviewAction.getViewer();
        }
        return this.viewer != null;
    }

    private static GraphicalViewer getViewer() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (editor != null) {
            return (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        }
        return null;
    }

    public void run() {
        if (this.viewer != null) {
            Shell shell = this.viewer.getControl().getShell();
            PrintPreview preview = new PrintPreview(shell, this.viewer, Messages.PrintPreviewAction_LABEL_PrintPreview);
            preview.setBlockOnOpen(true);
            preview.open();
        }
    }
}

