/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableColumn;

public class AttributeDeclarationTableColumn
implements NatTableColumn {
    public static final AttributeDeclarationTableColumn TYPE = new AttributeDeclarationTableColumn(FordiacMessages.Type);
    public static final AttributeDeclarationTableColumn COMMENT = new AttributeDeclarationTableColumn(FordiacMessages.Comment);
    public static final AttributeDeclarationTableColumn LOCATION = new AttributeDeclarationTableColumn(FordiacMessages.Location);
    public static final AttributeDeclarationTableColumn FILE_PATH = new AttributeDeclarationTableColumn(FordiacMessages.File_Path);
    public static final AttributeDeclarationTableColumn VALUE = new AttributeDeclarationTableColumn(FordiacMessages.Value);
    private final String displayName;

    AttributeDeclarationTableColumn(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static class AttributeDeclarationTableColumnProvider {
        private List<AttributeDeclarationTableColumn> columns;
        private Set<AttributeDeclarationTableColumn> editableColumns;

        public AttributeDeclarationTableColumnProvider(AttributeDeclaration attributeDeclaration) {
            AnyDerivedType type = attributeDeclaration.getType();
            if (type instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)type;
                String[] columnNames = (String[])structuredType.getMemberVariables().stream().map(INamedElement::getName).toArray(String[]::new);
                List<AttributeDeclarationTableColumn> instanceColumns = Arrays.stream(columnNames).map(AttributeDeclarationTableColumn::new).toList();
                this.columns = new ArrayList<AttributeDeclarationTableColumn>();
                this.columns.add(FILE_PATH);
                this.columns.add(LOCATION);
                this.columns.add(TYPE);
                this.columns.add(COMMENT);
                this.columns.addAll(instanceColumns);
                this.editableColumns = new HashSet<AttributeDeclarationTableColumn>();
                this.editableColumns.add(COMMENT);
                this.editableColumns.addAll(instanceColumns);
            } else if (type instanceof DirectlyDerivedType) {
                this.columns = new ArrayList<AttributeDeclarationTableColumn>();
                this.columns.add(FILE_PATH);
                this.columns.add(LOCATION);
                this.columns.add(TYPE);
                this.columns.add(COMMENT);
                this.columns.add(VALUE);
                this.editableColumns = new HashSet<AttributeDeclarationTableColumn>();
                this.editableColumns.add(COMMENT);
                this.editableColumns.add(VALUE);
            } else {
                this.columns = Collections.emptyList();
                this.editableColumns = Collections.emptySet();
            }
        }

        public List<AttributeDeclarationTableColumn> getColumns() {
            return this.columns;
        }

        public Set<AttributeDeclarationTableColumn> getEditableColumns() {
            return this.editableColumns;
        }
    }
}

