/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;

public class ModuloFreeformFigure
extends AbstractFreeformFigure {
    private final ZoomScalableFreeformRootEditPart zoomScalableFreeformRootEditPart;
    private final boolean useFeedbackLayer;
    private static final int PADDING = 0;
    private static final int BASE_WIDTH = 400;
    public static final int BASE_HEIGHT = 200;

    public ModuloFreeformFigure(ZoomScalableFreeformRootEditPart zoomScalableFreeformRootEditPart) {
        this(zoomScalableFreeformRootEditPart, true);
    }

    public ModuloFreeformFigure(ZoomScalableFreeformRootEditPart zoomScalableFreeformRootEditPart, boolean useFeedbackLayer) {
        this.zoomScalableFreeformRootEditPart = zoomScalableFreeformRootEditPart;
        this.useFeedbackLayer = useFeedbackLayer;
    }

    @Override
    protected Rectangle calculateFreeformExtent() {
        Rectangle contentsExtent = this.getUnscaledContentsExtent();
        contentsExtent.shrink(this.getInsets());
        int x = ModuloFreeformFigure.calcAxisOrigin(contentsExtent.x, 400);
        int y = ModuloFreeformFigure.calcAxisOrigin(contentsExtent.y, 200);
        int width = ModuloFreeformFigure.calcAxisExtent(contentsExtent.x, x, contentsExtent.width, 400);
        int height = ModuloFreeformFigure.calcAxisExtent(contentsExtent.y, y, contentsExtent.height, 200);
        contentsExtent = new Rectangle(x, y, width, height);
        contentsExtent.scale(this.getZoomScalableFreeformRootEditPart().getZoomManager().getZoom());
        return contentsExtent;
    }

    protected Rectangle getUnscaledContentsExtent() {
        Rectangle contentsExtent = ((FreeformFigure)this.getZoomScalableFreeformRootEditPart().getContentPane()).getFreeformExtent().getCopy();
        if (this.useFeedbackLayer) {
            contentsExtent.union(((FreeformFigure)this.getZoomScalableFreeformRootEditPart().getLayer("Handle Layer")).getFreeformExtent());
            contentsExtent.union(((FreeformFigure)this.getZoomScalableFreeformRootEditPart().getLayer("Feedback Layer")).getFreeformExtent());
        }
        return contentsExtent;
    }

    protected final ZoomScalableFreeformRootEditPart getZoomScalableFreeformRootEditPart() {
        return this.zoomScalableFreeformRootEditPart;
    }

    private static int calcAxisExtent(int baseOrigin, int newOrigin, int sourceExtent, int baseUnit) {
        int startExtent = sourceExtent + 0 + baseOrigin - newOrigin;
        int newExtend = Math.ceilDiv(startExtent, baseUnit) * baseUnit;
        if (newExtend < 3 * baseUnit) {
            newExtend = 3 * baseUnit;
        }
        return newExtend;
    }

    private static int calcAxisOrigin(int axisPos, int baseUnit) {
        return Math.floorDiv(axisPos, baseUnit) * baseUnit;
    }
}

