/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyler;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public final class GraphicalAnnotationStyles {
    private static final String GRAPHICAL_ANNOTATION_STYLES_EXTENSION_POINT_ID = "org.eclipse.fordiac.ide.gef.graphicalAnnotationStyle";
    private static final String ANNOTATION_TYPE_ATTRIBUTE = "annotationType";
    private static final String STYLER_ATTRIBUTE = "styler";
    private static final String LAYER_ATTRIBUTE = "layer";
    private static final Map<String, GraphicalAnnotationStyle> styles = GraphicalAnnotationStyles.loadStyles();

    public static Image getAnnotationImage(GraphicalAnnotation annotation) {
        GraphicalAnnotationStyle style = GraphicalAnnotationStyles.getAnnotationStyle(annotation);
        if (style != null) {
            return style.styler().getImage(annotation);
        }
        return null;
    }

    public static Image getAnnotationOverlayImage(GraphicalAnnotation annotation) {
        GraphicalAnnotationStyle style = GraphicalAnnotationStyles.getAnnotationStyle(annotation);
        if (style != null) {
            return style.styler().getOverlayImage(annotation);
        }
        return null;
    }

    public static boolean hasAnnotationEditPart(GraphicalAnnotation annotation) {
        GraphicalAnnotationStyle style = GraphicalAnnotationStyles.getAnnotationStyle(annotation);
        if (style != null) {
            return style.styler().hasEditPart(annotation);
        }
        return false;
    }

    public static EditPart getAnnotationEditPart(GraphicalAnnotation annotation) throws UnsupportedOperationException {
        GraphicalAnnotationStyle style = GraphicalAnnotationStyles.getAnnotationStyle(annotation);
        if (style != null) {
            return style.styler().getEditPart(annotation);
        }
        throw new UnsupportedOperationException("No style for annotation " + String.valueOf(annotation));
    }

    public static void updateAnnotationFeedback(IFigure annonFigure, Object target, GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback(annonFigure, target, event, (GraphicalAnnotation annotation) -> true);
    }

    @SafeVarargs
    public static void updateAnnotationFeedback(IFigure annonFigure, Object target, GraphicalAnnotationModelEvent event, Predicate<GraphicalAnnotation> ... filters) {
        GraphicalAnnotationStyles.updateAnnotationFeedback(annonFigure, target, event, Stream.of(filters).reduce(Predicate::or).orElse(annotation -> true));
    }

    public static void updateAnnotationFeedback(IFigure annonFigure, Object target, GraphicalAnnotationModelEvent event, Predicate<GraphicalAnnotation> filter) {
        event.getRemoved(target).stream().filter(filter).map(GraphicalAnnotationStyles::getStyledAnnotation).filter(Objects::nonNull).forEachOrdered(entry -> ((GraphicalAnnotationStyle)entry.getValue()).styler().removeStyles(annonFigure, (GraphicalAnnotation)entry.getKey()));
        event.getModel().getAnnotations(target).stream().filter(filter).map(GraphicalAnnotationStyles::getStyledAnnotation).filter(Objects::nonNull).sorted(Map.Entry.comparingByValue()).forEachOrdered(entry -> ((GraphicalAnnotationStyle)entry.getValue()).styler().applyStyles(annonFigure, (GraphicalAnnotation)entry.getKey()));
    }

    public static void addAnnotationBorder(IFigure annonFigure, AnnotationBorder annonBorder) {
        Border border = annonFigure.getBorder();
        if (border == null) {
            annonFigure.setBorder((Border)annonBorder);
        } else {
            annonFigure.setBorder((Border)new AnnotationCompoundBorder(border, annonBorder));
        }
    }

    public static <T extends AnnotationBorder> Optional<T> findAnnotationBorder(IFigure annonFigure, Class<T> borderClass) {
        return GraphicalAnnotationStyles.findAnnotationBorder(annonFigure.getBorder(), borderClass);
    }

    private static <T extends AnnotationBorder> Optional<T> findAnnotationBorder(Border border, Class<T> borderClass) {
        if (borderClass.isInstance(border)) {
            return Optional.of((AnnotationBorder)borderClass.cast(border));
        }
        if (border instanceof AnnotationCompoundBorder) {
            AnnotationCompoundBorder compBorder = (AnnotationCompoundBorder)border;
            return GraphicalAnnotationStyles.findAnnotationBorder(compBorder.getOuterBorder(), borderClass).or(() -> GraphicalAnnotationStyles.findAnnotationBorder(compBorder.getInnerBorder(), borderClass));
        }
        return Optional.empty();
    }

    public static void removeAnnotationBorders(IFigure annonFigure) {
        Border border = annonFigure.getBorder();
        while (border instanceof AnnotationCompoundBorder) {
            AnnotationCompoundBorder compBorder = (AnnotationCompoundBorder)border;
            border = compBorder.getOuterBorder();
        }
        if (border instanceof AnnotationBorder) {
            annonFigure.setBorder(null);
        } else {
            annonFigure.setBorder(border);
        }
    }

    public static void setAnnotationFeedbackBorder(IFigure annonFigure, Color color) {
        GraphicalAnnotationStyles.findAnnotationBorder(annonFigure, AnnotationFeedbackBorder.class).ifPresentOrElse(border -> border.setColor(color), () -> {
            if (annonFigure instanceof PolylineConnection) {
                GraphicalAnnotationStyles.addAnnotationBorder(annonFigure, new AnnotationFeedbackConnectionBorder(color));
            } else {
                GraphicalAnnotationStyles.addAnnotationBorder(annonFigure, new AnnotationFeedbackBorder(color));
            }
        });
        annonFigure.repaint();
    }

    public static void setAnnotationImageBorder(IFigure annonFigure, Image image) {
        GraphicalAnnotationStyles.findAnnotationBorder(annonFigure, AnnotationImageBorder.class).ifPresentOrElse(border -> border.setImage(image), () -> GraphicalAnnotationStyles.addAnnotationBorder(annonFigure, new AnnotationImageBorder(image)));
        annonFigure.repaint();
    }

    private static GraphicalAnnotationStyle getAnnotationStyle(GraphicalAnnotation annotation) {
        return styles.get(annotation.getType());
    }

    private static Map.Entry<GraphicalAnnotation, GraphicalAnnotationStyle> getStyledAnnotation(GraphicalAnnotation annotation) {
        GraphicalAnnotationStyle style = GraphicalAnnotationStyles.getAnnotationStyle(annotation);
        if (style != null) {
            return Map.entry(annotation, style);
        }
        return null;
    }

    private static Map<String, GraphicalAnnotationStyle> loadStyles() {
        return Stream.of(Platform.getExtensionRegistry().getExtensionPoint(GRAPHICAL_ANNOTATION_STYLES_EXTENSION_POINT_ID).getExtensions()).map(IExtension::getConfigurationElements).flatMap(iConfigurationElementArray -> Stream.of(iConfigurationElementArray)).map(GraphicalAnnotationStyles::loadStyles).filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(GraphicalAnnotationStyle::annotationType, Function.identity()));
    }

    private static GraphicalAnnotationStyle loadStyles(IConfigurationElement element) {
        String annotationType = element.getAttribute(ANNOTATION_TYPE_ATTRIBUTE);
        if (annotationType == null || annotationType.isEmpty()) {
            GraphicalAnnotationStyles.log("Missing annotation type", element);
            return null;
        }
        GraphicalAnnotationStyler styler = (GraphicalAnnotationStyler)SafeRunner.run(() -> (GraphicalAnnotationStyler)element.createExecutableExtension(STYLER_ATTRIBUTE));
        if (styler == null) {
            GraphicalAnnotationStyles.log("Invalid annotation styler", element);
            return null;
        }
        int layer = Integer.parseInt(element.getAttribute(LAYER_ATTRIBUTE));
        return new GraphicalAnnotationStyle(annotationType, styler, layer);
    }

    private static void log(String message, IConfigurationElement element) {
        Platform.getLog(GraphicalAnnotationStyles.class).error(String.format("%s in extension %s from plugin %s", message, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getDeclaringExtension().getContributor().getName()));
    }

    private GraphicalAnnotationStyles() {
        throw new UnsupportedOperationException();
    }

    public static interface AnnotationBorder
    extends Border {
    }

    public static final class AnnotationCompoundBorder
    extends CompoundBorder
    implements AnnotationBorder {
        public AnnotationCompoundBorder(Border outer, Border inner) {
            super(outer, inner);
        }

        public void paint(IFigure figure, Graphics g, Insets insets) {
            if (this.outer != null) {
                g.pushState();
                this.outer.paint(figure, g, insets);
                g.popState();
            }
            if (this.inner != null) {
                this.inner.paint(figure, g, insets);
            }
        }
    }

    public static class AnnotationFeedbackBorder
    extends LineBorder
    implements AnnotationBorder {
        private static final Insets INSETS = new Insets();
        private static final int FEEDBACK_BORDER_LINE_WIDTH = 2;
        public static final int ANNOTATION_FILL_ALPHA = 90;

        public AnnotationFeedbackBorder(Color color) {
            super(color, 2);
        }

        public Insets getInsets(IFigure figure) {
            return INSETS;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            tempRect.setBounds(AnnotationFeedbackBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            tempRect.expand(1, 1);
            graphics.setClip(tempRect.getExpanded(this.getWidth(), this.getWidth()));
            graphics.setLineStyle(1);
            graphics.setLineWidth(this.getWidth());
            graphics.setXORMode(false);
            graphics.setForegroundColor(this.getColor());
            graphics.setBackgroundColor(this.getColor());
            graphics.drawRoundRectangle(tempRect, 6, 6);
            graphics.setAlpha(90);
            graphics.fillRoundRectangle(tempRect, 6, 6);
        }
    }

    public static class AnnotationFeedbackConnectionBorder
    extends AnnotationFeedbackBorder {
        private static final int LINE_DISTANCE = 2;

        public AnnotationFeedbackConnectionBorder(Color color) {
            super(color);
        }

        @Override
        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            if (figure instanceof PolylineConnection) {
                Point p1;
                PolylineConnection conn = (PolylineConnection)figure;
                PointList upper = new PointList();
                PointList lower = new PointList();
                PointList base = conn.getPoints();
                int distance = conn.getLineWidth() / 2 + 2;
                int dx = 0;
                int dy = 0;
                Point p2 = p1 = base.getFirstPoint();
                int i = 1;
                while (i < base.size()) {
                    p1 = p2;
                    p2 = base.getPoint(i);
                    dx = AnnotationFeedbackConnectionBorder.calcDX(p1, p2, dx, distance);
                    dy = AnnotationFeedbackConnectionBorder.calcDY(p1, p2, dy, distance);
                    upper.addPoint(p1.x + dx, p1.y + dy);
                    lower.addPoint(p1.x - dx, p1.y - dy);
                    ++i;
                }
                dx = AnnotationFeedbackConnectionBorder.calcDX(p2, p1, 0, distance);
                dy = AnnotationFeedbackConnectionBorder.calcDY(p2, p1, 0, distance);
                upper.addPoint(p2.x - dx, p2.y - dy);
                lower.addPoint(p2.x + dx, p2.y + dy);
                graphics.setLineStyle(1);
                graphics.setLineWidth(this.getWidth());
                graphics.setXORMode(false);
                graphics.setForegroundColor(this.getColor());
                graphics.setBackgroundColor(this.getColor());
                graphics.drawPolyline(upper);
                graphics.drawPolyline(lower);
                graphics.setAlpha(90);
                graphics.setLineWidth(conn.getLineWidth() * 2 + 2);
                graphics.drawPolyline(base);
            } else {
                super.paint(figure, graphics, insets);
            }
        }

        private static int calcDX(Point p1, Point p2, int dx, int distance) {
            if (p2.y - p1.y < 0) {
                return distance;
            }
            if (p2.y - p1.y > 0) {
                return -distance;
            }
            return dx;
        }

        private static int calcDY(Point p1, Point p2, int dy, int distance) {
            if (p2.x - p1.x < 0) {
                dy = -distance;
            } else if (p2.x - p1.x > 0) {
                dy = distance;
            }
            return dy;
        }
    }

    public static class AnnotationImageBorder
    extends AbstractBorder
    implements AnnotationBorder {
        private static final Insets INSETS = new Insets();
        private Image image;

        public AnnotationImageBorder(Image image) {
            this.image = Objects.requireNonNull(image);
        }

        public Insets getInsets(IFigure figure) {
            return INSETS;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle rect = AnnotationImageBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
            int x = rect.x;
            int y = rect.y;
            graphics.drawImage(this.image, x, y);
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }
    }

    private record GraphicalAnnotationStyle(String annotationType, GraphicalAnnotationStyler styler, int layer) implements Comparable<GraphicalAnnotationStyle>
    {
        @Override
        public int compareTo(GraphicalAnnotationStyle o) {
            return Integer.compare(this.layer, o.layer);
        }
    }
}

