/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.data.EnumeratedValue;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class DataTypeExporter
extends AbstractTypeExporter {
    public DataTypeExporter(AnyDerivedType type) {
        super(type);
    }

    @Override
    public AnyDerivedType getType() {
        return (AnyDerivedType)super.getType();
    }

    @Override
    protected String getRootTag() {
        return "DataType";
    }

    @Override
    protected void createTypeSpecificXMLEntries() throws XMLStreamException {
        this.addCompilerInfo(this.getType().getCompilerInfo());
        AnyDerivedType anyDerivedType = this.getType();
        Objects.requireNonNull(anyDerivedType);
        AnyDerivedType anyDerivedType2 = anyDerivedType;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StructuredType.class, EnumeratedType.class}, (Object)anyDerivedType2, 0)) {
            case 0: {
                StructuredType structuredType = (StructuredType)anyDerivedType2;
                this.createStructContent(structuredType);
                break;
            }
            case 1: {
                EnumeratedType enumeratedType = (EnumeratedType)anyDerivedType2;
                this.createEnumeratedContent(enumeratedType);
                break;
            }
            default: {
                throw new XMLStreamException(MessageFormat.format(Messages.DataTypeExporter_UNSUPPORTED_DATA_TYPE, this.getType()));
            }
        }
        if (!this.getType().getAttributes().isEmpty()) {
            this.addAttributes((EList<Attribute>)this.getType().getAttributes());
        }
    }

    private void createStructContent(StructuredType type) throws XMLStreamException {
        this.addStartElement("StructuredType");
        for (VarDeclaration varDecl : type.getMemberVariables()) {
            this.addVarDeclaration(varDecl);
        }
        this.addEndElement();
    }

    private void createEnumeratedContent(EnumeratedType type) throws XMLStreamException {
        this.addStartElement("EnumeratedType");
        for (EnumeratedValue enumValue : type.getEnumeratedValues()) {
            this.addEnumeratedValue(enumValue);
        }
        this.addEndElement();
    }

    private void addEnumeratedValue(EnumeratedValue enumValue) throws XMLStreamException {
        this.addEmptyStartElement("EnumeratedValue");
        this.addNameAttribute(enumValue.getName());
        this.addCommentAttribute(enumValue.getComment());
    }
}

