/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.debug.ui.breakpoint.DeploymentWatchpointUtil;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class TogglePinnedHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TogglePinnedHandler.getWatches(HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event)).forEachOrdered(watch -> TogglePinnedHandler.togglePinned(watch, event));
        return null;
    }

    private static void togglePinned(IWatch watch, ExecutionEvent event) {
        IFile file = watch.getDebugTarget().getSystem().getTypeEntry().getFile();
        Optional<DeploymentWatchpoint> watchpoint = DeploymentWatchpointUtil.findExistingWatchpoint((IResource)file, watch.getQualifiedName());
        if (watchpoint.isEmpty()) {
            TogglePinnedHandler.createWatchpoint((IResource)file, watch.getWatchedElement(), event);
        } else {
            TogglePinnedHandler.updateWatchpoint(watchpoint.get(), event);
        }
    }

    private static void createWatchpoint(IResource resource, ITypedElement element, ExecutionEvent event) {
        try {
            DeploymentWatchpoint watchpoint = new DeploymentWatchpoint(resource, (INamedElement)element);
            watchpoint.setPinned(true);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)watchpoint);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), null, null, (IStatus)e.getStatus());
        }
    }

    private static void updateWatchpoint(DeploymentWatchpoint watchpoint, ExecutionEvent event) {
        try {
            watchpoint.setPinned(!watchpoint.isPinned());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), null, null, (IStatus)e.getStatus());
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        IEvaluationContext evaluationContext = ((IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)).getCurrentState();
        Object object = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (object instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)object;
            if (TogglePinnedHandler.getWatches(selection).noneMatch(IWatch::isPinned)) {
                element.setText(Messages.TogglePinnedHandler_PinWatch);
            } else if (TogglePinnedHandler.getWatches(selection).allMatch(IWatch::isPinned)) {
                element.setText(Messages.TogglePinnedHandler_UnpinWatch);
            }
        }
    }

    private static Stream<IWatch> getWatches(IStructuredSelection selection) {
        return selection.stream().filter(IWatch.class::isInstance).map(IWatch.class::cast);
    }
}

