/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;

public class STCoreRelatedResourcesProvider
extends RelatedResourcesProvider {
    @Inject
    private IResourceDescriptionsProvider resourceDescriptionsProvider;

    public List<RelatedResourcesProvider.RelatedResource> getRelatedResources(Collection<IResourceSnapshot> snapshots) {
        Map result = super.getRelatedResources(snapshots).stream().collect(Collectors.toMap(RelatedResourcesProvider.RelatedResource::getUri, Function.identity(), (a, b) -> a, LinkedHashMap::new));
        for (ResourceSet resourceSet : STCoreRelatedResourcesProvider.getDistinctResourceSets(snapshots)) {
            IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
            for (IResourceDescription description : resourceDescriptions.getAllResourceDescriptions()) {
                if (result.containsKey(description.getURI()) || !STCoreRelatedResourcesProvider.containsImportedName(description, snapshots)) continue;
                result.put(description.getURI(), new STCoreRelatedResource(description.getURI(), description.getImportedNames()));
            }
        }
        return result.values().stream().toList();
    }

    protected static SequencedSet<ResourceSet> getDistinctResourceSets(Collection<IResourceSnapshot> snapshots) {
        return snapshots.stream().map(IResourceSnapshot::getResource).map(Resource::getResourceSet).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected static boolean containsImportedName(IResourceDescription resourceDescription, Collection<IResourceSnapshot> snapshots) {
        Iterable importedNames = resourceDescription.getImportedNames();
        for (IResourceSnapshot res : snapshots) {
            for (IEObjectSnapshot obj : res.getObjects().values()) {
                for (IEObjectDescription desc : obj.getDescriptions()) {
                    for (QualifiedName name : importedNames) {
                        if (!name.equalsIgnoreCase((Object)desc.getQualifiedName())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public class STCoreRelatedResource
    extends RelatedResourcesProvider.RelatedResource {
        private final Iterable<QualifiedName> importedNames;

        public STCoreRelatedResource(URI uri, Iterable<QualifiedName> importedNames) {
            super(uri);
            this.importedNames = importedNames;
        }

        public Iterable<QualifiedName> getImportedNames() {
            return this.importedNames;
        }
    }
}

