/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;

public class AttributedPosition
extends Position {
    private final TextAttribute attribute;
    private final Object fLock;

    public AttributedPosition(int offset, int length, TextAttribute attribute, Object lock) {
        super(offset, length);
        this.attribute = attribute;
        this.fLock = lock;
    }

    public StyleRange createStyleRange() {
        int len = this.getLength();
        TextAttribute textAttribute = this.attribute;
        int style = textAttribute.getStyle();
        int fontStyle = style & 3;
        StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
        styleRange.strikeout = (style & 0x20000000) != 0;
        styleRange.underline = (style & 0x40000000) != 0;
        styleRange.font = textAttribute.getFont();
        return styleRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqual(int off, int len, TextAttribute other) {
        Object object = this.fLock;
        synchronized (object) {
            return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.attribute == other;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContained(int off, int len) {
        Object object = this.fLock;
        synchronized (object) {
            return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int off, int len) {
        Object object = this.fLock;
        synchronized (object) {
            super.setOffset(off);
            super.setLength(len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLength(int length) {
        Object object = this.fLock;
        synchronized (object) {
            super.setLength(length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(int offset) {
        Object object = this.fLock;
        synchronized (object) {
            super.setOffset(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = this.fLock;
        synchronized (object) {
            super.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undelete() {
        Object object = this.fLock;
        synchronized (object) {
            super.undelete();
        }
    }

    public TextAttribute getHighlighting() {
        return this.attribute;
    }
}

