/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.genericeditor.ContentTypeSpecializationComparator;
import org.eclipse.ui.internal.genericeditor.GenericContentTypeRelatedExtension;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReconcilerRegistry {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.reconcilers";
    private static final String RECONCILING_STRATEGY_ELT_NAME = "reconcilingStrategy";
    private static final String HIGHLIGHT_EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.highlightReconcilers";
    private static final String HIGHLIGHT_RECONCILING_STRATEGY_ELT_NAME = "highlightReconcilingStrategy";
    private static final String FOLDING_EXTENSION_POINT_ID = "org.eclipse.ui.genericeditor.foldingReconcilers";
    private static final String FOLDING_RECONCILING_STRATEGY_ELT_NAME = "foldingReconcilingStrategy";
    private final Map<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>> extensions = new HashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>>();
    private final Map<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>> highlightExtensions = new HashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>>();
    private final Map<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>> foldingExtensions = new HashMap<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>>();
    private boolean outOfSync = true;
    private boolean highlightOutOfSync = true;
    private boolean foldingOutOfSync = true;

    public ReconcilerRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.outOfSync = true;
        }, EXTENSION_POINT_ID);
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.highlightOutOfSync = true;
        }, HIGHLIGHT_EXTENSION_POINT_ID);
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            boolean bl = this.foldingOutOfSync = true;
        }, FOLDING_EXTENSION_POINT_ID);
    }

    public List<IReconciler> getReconcilers(ISourceViewer sourceViewer, ITextEditor editor, List<IReconcilingStrategy> reconcilingStrategies, Set<IContentType> contentTypes) {
        if (this.outOfSync) {
            this.sync();
        }
        return ReconcilerRegistry.getReconcilers(sourceViewer, editor, reconcilingStrategies, contentTypes, RECONCILING_STRATEGY_ELT_NAME, this.extensions);
    }

    public List<IReconciler> getHighlightReconcilers(ISourceViewer sourceViewer, ITextEditor editor, List<IReconcilingStrategy> reconcilingStrategies, Set<IContentType> contentTypes) {
        if (this.highlightOutOfSync) {
            this.syncHighlight();
        }
        return ReconcilerRegistry.getReconcilers(sourceViewer, editor, reconcilingStrategies, contentTypes, HIGHLIGHT_RECONCILING_STRATEGY_ELT_NAME, this.highlightExtensions);
    }

    public List<IReconciler> getFoldingReconcilers(ISourceViewer sourceViewer, ITextEditor editor, List<IReconcilingStrategy> reconcilingStrategies, Set<IContentType> contentTypes) {
        if (this.foldingOutOfSync) {
            this.syncFolding();
        }
        return ReconcilerRegistry.getReconcilers(sourceViewer, editor, reconcilingStrategies, contentTypes, FOLDING_RECONCILING_STRATEGY_ELT_NAME, this.foldingExtensions);
    }

    private static List<IReconciler> getReconcilers(ISourceViewer sourceViewer, ITextEditor editor, List<IReconcilingStrategy> reconcilingStrategies, Set<IContentType> contentTypes, String contributionName, Map<IConfigurationElement, GenericContentTypeRelatedExtension<IReconciler>> extensionsMap) {
        ArrayList<IReconciler> reconcilers = new ArrayList<IReconciler>();
        List extensions = extensionsMap.values().stream().filter(ext -> contentTypes.contains(ext.targetContentType)).filter(ext -> ext.matches(sourceViewer, editor)).sorted(new ContentTypeSpecializationComparator().reversed()).collect(Collectors.toList());
        for (GenericContentTypeRelatedExtension ext2 : extensions) {
            if (contributionName.equals(ext2.getContributionName())) {
                IReconcilingStrategy reconcilingStrategy = (IReconcilingStrategy)ext2.createDelegateWithoutTypeCheck();
                reconcilingStrategies.add(reconcilingStrategy);
                continue;
            }
            IReconciler reconciler = (IReconciler)ext2.createDelegate();
            if (reconciler == null) continue;
            reconcilers.add(reconciler);
        }
        return reconcilers;
    }

    private void sync() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.extensions.containsKey(extension)) {
                try {
                    this.extensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.extensions.remove(toRemove);
        }
        this.outOfSync = false;
    }

    private void syncHighlight() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(HIGHLIGHT_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.highlightExtensions.containsKey(extension)) {
                try {
                    this.highlightExtensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.highlightExtensions.remove(toRemove);
        }
        this.highlightOutOfSync = false;
    }

    private void syncFolding() {
        HashSet<IConfigurationElement> toRemoveExtensions = new HashSet<IConfigurationElement>(this.extensions.keySet());
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(FOLDING_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            toRemoveExtensions.remove(extension);
            if (!this.foldingExtensions.containsKey(extension)) {
                try {
                    this.foldingExtensions.put(extension, new GenericContentTypeRelatedExtension(extension));
                }
                catch (Exception ex) {
                    GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
                }
            }
            ++n2;
        }
        for (IConfigurationElement toRemove : toRemoveExtensions) {
            this.foldingExtensions.remove(toRemove);
        }
        this.foldingOutOfSync = false;
    }
}

