/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.scaling;

import java.util.function.Consumer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.NatTableConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.FixedScalingDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;

public final class ScalingUtil {
    private static int[] OS_SCALING_FACTORS = new int[]{96, 120, 144, 192, 288};

    private ScalingUtil() {
    }

    public static void zoomIn(NatTable natTable, Consumer<IConfigRegistry> registryUpdater) {
        ScalingUtil.zoomIn(natTable, false, registryUpdater);
    }

    public static void zoomOut(NatTable natTable, Consumer<IConfigRegistry> registryUpdater) {
        ScalingUtil.zoomOut(natTable, false, registryUpdater);
    }

    public static void zoomIn(NatTable natTable, boolean percentageIncrease, Consumer<IConfigRegistry> registryUpdater) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        IDpiConverter hDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int hdpi = hDpiConverter.getDpi();
        int newHorizontalDpi = ScalingUtil.getNewZoomInDPI(hdpi, percentageIncrease);
        IDpiConverter vDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.VERTICAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int vdpi = vDpiConverter.getDpi();
        int newVerticalDpi = ScalingUtil.getNewZoomInDPI(vdpi, percentageIncrease);
        if (hdpi != newHorizontalDpi || vdpi != newVerticalDpi) {
            natTable.doCommand(new ConfigureScalingCommand(new FixedScalingDpiConverter(newHorizontalDpi), new FixedScalingDpiConverter(newVerticalDpi)));
            if (registryUpdater != null) {
                registryUpdater.accept(configRegistry);
            }
            natTable.refresh(false);
        }
    }

    public static void zoomOut(NatTable natTable, boolean percentageDecrease, Consumer<IConfigRegistry> registryUpdater) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        IDpiConverter hDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int hdpi = hDpiConverter.getDpi();
        int newHorizontalDpi = ScalingUtil.getNewZoomOutDPI(hdpi, percentageDecrease);
        IDpiConverter vDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.VERTICAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int vdpi = vDpiConverter.getDpi();
        int newVerticalDpi = ScalingUtil.getNewZoomOutDPI(vdpi, percentageDecrease);
        if (hdpi != newHorizontalDpi || vdpi != newVerticalDpi) {
            natTable.doCommand(new ConfigureScalingCommand(new FixedScalingDpiConverter(newHorizontalDpi), new FixedScalingDpiConverter(newVerticalDpi)));
            if (registryUpdater != null) {
                registryUpdater.accept(configRegistry);
            }
            natTable.refresh(false);
        }
    }

    public static int getNewZoomOutDPI(int currentDPI) {
        int dpi = currentDPI;
        if (currentDPI == 288) {
            dpi = 192;
        } else if (currentDPI == 192) {
            dpi = 144;
        } else if (currentDPI == 144) {
            dpi = 120;
        } else if (currentDPI == 120) {
            dpi = 96;
        } else if (currentDPI <= 96) {
            dpi = Math.max(12, dpi / 2);
        }
        return dpi;
    }

    public static int getNewZoomInDPI(int currentDPI) {
        int dpi = currentDPI;
        if (currentDPI == 192) {
            dpi = 288;
        } else if (currentDPI == 144) {
            dpi = 192;
        } else if (currentDPI == 120) {
            dpi = 144;
        } else if (currentDPI == 96) {
            dpi = 120;
        } else if (currentDPI < 96) {
            dpi *= 2;
        }
        return dpi;
    }

    public static int getNewZoomOutDPI(int currentDPI, boolean percentageDecrease) {
        int decrease = percentageDecrease ? Math.max(12, Double.valueOf((double)currentDPI * 0.9).intValue()) : ScalingUtil.getNewZoomOutDPI(currentDPI);
        int i = OS_SCALING_FACTORS.length - 1;
        while (i >= 0) {
            int osScale = OS_SCALING_FACTORS[i];
            int diff = osScale - decrease;
            if (diff > -7 && diff < 7) {
                return osScale;
            }
            --i;
        }
        return decrease;
    }

    public static int getNewZoomInDPI(int currentDPI, boolean percentageIncrease) {
        int increase = percentageIncrease ? Math.min(288, Double.valueOf((double)currentDPI / 0.9).intValue()) : ScalingUtil.getNewZoomInDPI(currentDPI);
        int i = OS_SCALING_FACTORS.length - 1;
        while (i >= 0) {
            int osScale = OS_SCALING_FACTORS[i];
            int diff = osScale - increase;
            if (diff > -7 && diff < 7) {
                return osScale;
            }
            --i;
        }
        return increase;
    }
}

