/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.NonTransparentRedundancyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.NonTransparentNetworkRedundancyType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.NetworkGroupDataType;

public class NonTransparentNetworkRedundancyTypeNode
extends NonTransparentRedundancyTypeNode
implements NonTransparentNetworkRedundancyType {
    public NonTransparentNetworkRedundancyTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public NetworkGroupDataType[] getServerNetworkGroups() throws UaException {
        PropertyTypeNode node = this.getServerNetworkGroupsNode();
        return this.cast(node.getValue().getValue().getValue(), NetworkGroupDataType[].class);
    }

    @Override
    public void setServerNetworkGroups(NetworkGroupDataType[] serverNetworkGroups) throws UaException {
        PropertyTypeNode node = this.getServerNetworkGroupsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure[])serverNetworkGroups);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public NetworkGroupDataType[] readServerNetworkGroups() throws UaException {
        try {
            return this.readServerNetworkGroupsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerNetworkGroups(NetworkGroupDataType[] serverNetworkGroups) throws UaException {
        try {
            this.writeServerNetworkGroupsAsync(serverNetworkGroups).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NetworkGroupDataType[]> readServerNetworkGroupsAsync() {
        return ((CompletableFuture)this.getServerNetworkGroupsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), NetworkGroupDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeServerNetworkGroupsAsync(NetworkGroupDataType[] serverNetworkGroups) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure[])serverNetworkGroups);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getServerNetworkGroupsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerNetworkGroupsNode() throws UaException {
        try {
            return this.getServerNetworkGroupsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerNetworkGroupsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerNetworkGroups", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

