/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.router;

import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.figures.HideableConnection;
import org.eclipse.fordiac.ide.gef.policies.AdjustConnectionEditPolicy;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.EditPolicy;

public class MoveableRouter
extends BendpointConnectionRouter
implements BendpointPolicyRouter {
    public static final int MIN_CONNECTION_FB_DISTANCE = 12;
    private static final PrecisionPoint START_POINT = new PrecisionPoint();
    private static final PrecisionPoint END_POINT = new PrecisionPoint();

    public void route(Connection conn) {
        PointList points = conn.getPoints();
        points.removeAllPoints();
        if (conn instanceof HideableConnection && ((HideableConnection)conn).getModel() != null) {
            MoveableRouter.handleHideableConnection((HideableConnection)conn, points);
        } else {
            MoveableRouter.setStartEndPoints(conn, MoveableRouter.needsSwap(conn));
            points.addPoint((Point)START_POINT);
            MoveableRouter.setCreationBendPoints((Point)START_POINT, (Point)END_POINT, points);
        }
        points.addPoint((Point)END_POINT);
        conn.setPoints(points);
    }

    private static void handleHideableConnection(HideableConnection conn, PointList points) {
        MoveableRouter.setStartEndPoints((Connection)conn, false);
        points.addPoint((Point)START_POINT);
        org.eclipse.fordiac.ide.model.libraryElement.Connection model = conn.getModel();
        if (MoveableRouter.invalidOneSegmentConnection(model.getRoutingData())) {
            ConnectionRoutingData newRoutingData = MoveableRouter.setCreationBendPoints((Point)START_POINT, (Point)END_POINT, points);
            model.setRoutingData(newRoutingData);
        } else {
            if (model.getRoutingData().isNeedsValidation()) {
                MoveableRouter.valdidateConnectionRoutingParams(model.getRoutingData(), (Point)START_POINT, (Point)END_POINT);
                model.getRoutingData().setNeedsValidation(false);
            }
            MoveableRouter.createBendPointList((Point)START_POINT, (Point)END_POINT, model.getRoutingData(), points);
        }
    }

    private static boolean invalidOneSegmentConnection(ConnectionRoutingData routingData) {
        return routingData.getDx1() == 0 && (MoveableRouter.START_POINT.y != MoveableRouter.END_POINT.y || MoveableRouter.START_POINT.x > MoveableRouter.END_POINT.x);
    }

    private static boolean needsSwap(Connection conn) {
        if (conn.getSourceAnchor() instanceof FixedAnchor) {
            return ((FixedAnchor)conn.getSourceAnchor()).isInput();
        }
        return false;
    }

    private static void setStartEndPoints(Connection conn, boolean needsSwap) {
        if (needsSwap) {
            END_POINT.setLocation(conn.getSourceAnchor().getLocation(conn.getSourceAnchor().getReferencePoint()));
            START_POINT.setLocation(conn.getTargetAnchor().getLocation(conn.getTargetAnchor().getReferencePoint()));
        } else {
            START_POINT.setLocation(conn.getSourceAnchor().getLocation(conn.getSourceAnchor().getReferencePoint()));
            END_POINT.setLocation(conn.getTargetAnchor().getLocation(conn.getTargetAnchor().getReferencePoint()));
        }
        conn.translateToRelative((Translatable)START_POINT);
        conn.translateToRelative((Translatable)END_POINT);
    }

    private static ConnectionRoutingData setCreationBendPoints(Point sourceP, Point destP, PointList points) {
        ConnectionRoutingData routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        MoveableRouter.valdidateConnectionRoutingParams(routingData, sourceP, destP);
        MoveableRouter.createBendPointList(sourceP, destP, routingData, points);
        return routingData;
    }

    private static void createBendPointList(Point sourceP, Point destP, ConnectionRoutingData routingData, PointList points) {
        if (routingData.getDx1() != 0) {
            points.addPoint(sourceP.x + routingData.getDx1(), sourceP.y);
            if (routingData.getDy() == 0) {
                points.addPoint(new Point(sourceP.x + routingData.getDx1(), destP.y));
            } else {
                points.addPoint(new Point(sourceP.x + routingData.getDx1(), sourceP.y + routingData.getDy()));
                points.addPoint(new Point(destP.x - routingData.getDx2(), sourceP.y + routingData.getDy()));
                points.addPoint(new Point(destP.x - routingData.getDx2(), destP.y));
            }
        }
    }

    private static void valdidateConnectionRoutingParams(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (routingData.getDx1() == 0) {
            MoveableRouter.validate1SegmentConn(routingData, sourceP, destP);
        } else if (sourceP.y == destP.y && !MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            routingData.setDx1(0);
        } else if (routingData.getDx2() == 0) {
            MoveableRouter.validate3SegmentConn(routingData, sourceP, destP);
        } else {
            MoveableRouter.validate5SegmentConn(routingData, sourceP, destP);
        }
    }

    private static void validate1SegmentConn(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (sourceP.y != destP.y || MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            if (MoveableRouter.requires5SegementConnection(sourceP, destP)) {
                MoveableRouter.generateInitial5SegmentParams(routingData, sourceP, destP);
            } else {
                MoveableRouter.generateInitial3SegmentParams(routingData, sourceP, destP);
            }
        }
    }

    private static void validate3SegmentConn(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            MoveableRouter.generateInitial5SegmentParams(routingData, sourceP, destP);
        } else if (sourceP.x + routingData.getDx1() > destP.x - 12) {
            routingData.setDx1(destP.x - sourceP.x - 12);
        }
    }

    private static void validate5SegmentConn(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        if (!MoveableRouter.requires5SegementConnection(sourceP, destP)) {
            routingData.setDx2(0);
            routingData.setDy(0);
            MoveableRouter.generateInitial3SegmentParams(routingData, sourceP, destP);
        }
    }

    private static void generateInitial3SegmentParams(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        routingData.setDx1((destP.x - sourceP.x) / 2);
    }

    private static void generateInitial5SegmentParams(ConnectionRoutingData routingData, Point sourceP, Point destP) {
        routingData.setDx1(12);
        routingData.setDx2(12);
        routingData.setDy((destP.y - sourceP.y) / 2);
        if (routingData.getDy() == 0) {
            routingData.setDy(24);
        }
    }

    private static boolean requires5SegementConnection(Point sourceP, Point destP) {
        return sourceP.x >= destP.x - 24;
    }

    @Override
    public EditPolicy getBendpointPolicy(Object modelObject) {
        if (modelObject instanceof org.eclipse.fordiac.ide.model.libraryElement.Connection) {
            return new AdjustConnectionEditPolicy((org.eclipse.fordiac.ide.model.libraryElement.Connection)modelObject);
        }
        return null;
    }
}

