/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.widgets.TypeInfoWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class TypeInfoSection
extends AbstractSection {
    private TypeInfoWidget typeInfo;
    private Text fbTypeNameText;
    private Text commentText;

    protected LibraryElement getType() {
        return (LibraryElement)this.type;
    }

    @Override
    protected void setInputInit() {
        this.typeInfo.initialize(this.getType(), this::executeCommand);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTypeAndCommentSection(this.getLeftComposite());
        this.typeInfo = new TypeInfoWidget((FormToolkit)this.getWidgetFactory());
        this.typeInfo.createControls(this.getLeftComposite(), this.getRightComposite());
    }

    private void createTypeAndCommentSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.TypeName) + ":");
        this.fbTypeNameText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Comment) + ":");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(e -> this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText())));
    }

    @Override
    public void setInputCode() {
        this.commentText.setEnabled(false);
        this.typeInfo.setEnabled(false);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.fbTypeNameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.typeInfo.refresh();
        }
        this.commandStack = commandStackBuffer;
    }
}

