/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.gef.properties.TypeInfoSection;
import org.eclipse.fordiac.ide.gef.provider.CompilerContentProvider;
import org.eclipse.fordiac.ide.gef.provider.CompilerLabelProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerInfoClassdefCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerInfoHeaderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerLanguageCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerProductCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerVendorCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCompilerVersionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewCompilerCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteCompilerCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Language;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class CompilableTypeInfoSection
extends TypeInfoSection {
    private static final String LANGUAGE_OTHER = "Other";
    private static final String LANGUAGE_C = "C";
    private static final String LANGUAGE_CPP = "Cpp";
    private static final String LANGUAGE_JAVA = "Java";
    private TableViewer compilerViewer;
    private Text headerText;
    private Text classdefText;
    private static final String COMPILER_VERSION = "compiler_version";
    private static final String COMPILER_LANGUAGE = "language";
    private static final String COMPILER_VENDOR = "vendor";
    private static final String COMPILER_PRODUCT = "product";
    private static final String[] VALUE_SET = new String[]{"Java", "Cpp", "C", "Other"};

    protected CompilableTypeInfoSection() {
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createCompilerInfoGroup(this.getRightComposite());
    }

    private void createCompilerInfoGroup(Composite parent) {
        Group compilerInfoGroup = this.getWidgetFactory().createGroup(parent, FordiacMessages.CompilerInfo);
        compilerInfoGroup.setLayout((Layout)new GridLayout(1, false));
        compilerInfoGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = this.getWidgetFactory().createComposite((Composite)compilerInfoGroup, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, false, false));
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Header) + ":");
        this.headerText = this.createGroupText(composite, true);
        this.headerText.addModifyListener(e -> this.executeCommand((Command)new ChangeCompilerInfoHeaderCommand((FBType)this.type, this.headerText.getText())));
        this.getWidgetFactory().createCLabel(composite, String.valueOf(FordiacMessages.Classdef) + ":");
        this.classdefText = this.createGroupText(composite, true);
        this.classdefText.addModifyListener(e -> this.executeCommand((Command)new ChangeCompilerInfoClassdefCommand((FBType)this.type, this.classdefText.getText())));
        Composite compositeBottom = this.getWidgetFactory().createComposite((Composite)compilerInfoGroup);
        compositeBottom.setLayout((Layout)new GridLayout(2, false));
        compositeBottom.setLayoutData((Object)new GridData(4, 0, true, false));
        AddDeleteWidget buttons = new AddDeleteWidget();
        buttons.createControls(compositeBottom, (FormToolkit)this.getWidgetFactory());
        this.compilerViewer = TableWidgetFactory.createPropertyTableViewer((Composite)compositeBottom);
        Table table = this.compilerViewer.getTable();
        CompilableTypeInfoSection.configureTableLayout(table);
        this.compilerViewer.setContentProvider((IContentProvider)new CompilerContentProvider());
        this.compilerViewer.setLabelProvider((IBaseLabelProvider)new CompilerLabelProvider());
        this.compilerViewer.setCellEditors(new CellEditor[]{ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])VALUE_SET), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.compilerViewer.setColumnProperties(new String[]{COMPILER_LANGUAGE, COMPILER_VENDOR, COMPILER_PRODUCT, COMPILER_VERSION});
        buttons.bindToTableViewer(this.compilerViewer, (CommandExecutor)this, ref -> new AddNewCompilerCommand((FBType)this.type), ref -> new DeleteCompilerCommand(((FBType)this.type).getCompilerInfo(), (Compiler)ref));
        this.compilerViewer.setCellModifier((ICellModifier)new CompilerCellModifier());
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Language);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Vendor);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Product);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(FordiacMessages.Version);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 80));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 80));
        table.setLayout((Layout)layout);
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.commandStack = this.getCommandStack(part, null);
        if (this.commandStack == null) {
            this.headerText.setEnabled(false);
            this.classdefText.setEnabled(false);
            this.compilerViewer.setCellModifier(null);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type instanceof FBType && ((FBType)this.type).getCompilerInfo() != null) {
            this.headerText.setText(((FBType)this.type).getCompilerInfo().getHeader() != null ? ((FBType)this.type).getCompilerInfo().getHeader() : "");
            this.classdefText.setText(((FBType)this.type).getCompilerInfo().getClassdef() != null ? ((FBType)this.type).getCompilerInfo().getClassdef() : "");
            this.compilerViewer.setInput(this.type);
        }
        this.commandStack = commandStackBuffer;
    }

    private class CompilerCellModifier
    implements ICellModifier {
        private static final int LANGUAGE_JAVA_INDEX = 0;
        private static final int LANGUAGE_CPP_INDEX = 1;
        private static final int LANGUAGE_C_INDEX = 2;
        private static final int LANGUAGE_OTHER_INDEX = 3;

        private CompilerCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            switch (property) {
                case "language": {
                    return this.getLanguageIndex(((Compiler)element).getLanguage().getName());
                }
                case "product": {
                    return ((Compiler)element).getProduct();
                }
                case "vendor": {
                    return ((Compiler)element).getVendor();
                }
            }
            return ((Compiler)element).getVersion();
        }

        private Object getLanguageIndex(String language) {
            switch (language) {
                case "Java": {
                    return 0;
                }
                case "Cpp": {
                    return 1;
                }
                case "C": {
                    return 2;
                }
            }
            return 3;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Compiler data = (Compiler)tableItem.getData();
            Command cmd = this.getModificationCommand(property, value, data);
            if (cmd != null) {
                CompilableTypeInfoSection.this.executeCommand(cmd);
                CompilableTypeInfoSection.this.compilerViewer.refresh((Object)data);
            }
        }

        private Command getModificationCommand(String property, Object value, Compiler data) {
            ChangeCompilerVersionCommand cmd = null;
            block5 : switch (property) {
                case "language": {
                    switch ((Integer)value) {
                        case 0: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_JAVA));
                            break block5;
                        }
                        case 1: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_CPP));
                            break block5;
                        }
                        case 2: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_C));
                            break block5;
                        }
                        case 3: {
                            cmd = new ChangeCompilerLanguageCommand(data, Language.get((String)CompilableTypeInfoSection.LANGUAGE_OTHER));
                            break block5;
                        }
                    }
                    break;
                }
                case "product": {
                    cmd = new ChangeCompilerProductCommand(data, value.toString());
                    break;
                }
                case "vendor": {
                    cmd = new ChangeCompilerVendorCommand(data, value.toString());
                    break;
                }
                default: {
                    cmd = new ChangeCompilerVersionCommand(data, value.toString());
                }
            }
            return cmd;
        }
    }
}

