/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.properties.AbstractEditInterfaceSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeArraySizeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.edit.providers.DataLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeDropdown;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.CustomTextCellEditor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractEditInterfaceDataSection
extends AbstractEditInterfaceSection {
    protected static final String ARRAY_SIZE = "arraysize";
    protected static final String INITIAL_VALUE = "initialvalue";
    protected static final int ARRAYSIZE_WIDTH = 100;
    protected static final int INITIALVALUE_WIDTH = 100;
    private DataTypeDropdown typeDropdown;

    @Override
    protected CellEditor createTypeCellEditor(TableViewer viewer) {
        this.typeDropdown = new DataTypeDropdown(this.getDataTypeLib(), viewer);
        return this.typeDropdown;
    }

    @Override
    protected Object getTypeValue(Object element, TableViewer viewer, int TYPE_COLUMN_INDEX) {
        VarDeclaration variable = (VarDeclaration)element;
        return variable.getTypeName();
    }

    @Override
    protected Command createChangeDataTypeCommand(VarDeclaration data, Object value, TableViewer viewer) {
        if (value instanceof String) {
            DataType dataType = this.typeDropdown.getType((String)value);
            return dataType == null ? null : this.newChangeTypeCommand(data, dataType);
        }
        return null;
    }

    @Override
    protected IContentProvider getOutputsContentProvider() {
        return new DataInterfaceContentProvider(false);
    }

    @Override
    protected IContentProvider getInputsContentProvider() {
        return new DataInterfaceContentProvider(true);
    }

    @Override
    protected String[] fillTypeCombo() {
        ArrayList<String> list = new ArrayList<String>();
        for (DataType dataType : this.getDataTypeLib().getDataTypesSorted()) {
            list.add(dataType.getName());
        }
        return list.toArray(new String[0]);
    }

    protected DataType getLastUsedDataType(InterfaceList interfaceList, boolean isInput, IInterfaceElement interfaceElement) {
        if (interfaceElement != null) {
            return interfaceElement.getType();
        }
        EList<VarDeclaration> dataList = AbstractEditInterfaceDataSection.getDataList(interfaceList, isInput);
        if (!dataList.isEmpty()) {
            return ((VarDeclaration)dataList.get(dataList.size() - 1)).getType();
        }
        return IecTypes.ElementaryTypes.BOOL;
    }

    @Override
    protected int getInsertingIndex(IInterfaceElement interfaceElement, boolean isInput) {
        if (interfaceElement != null) {
            InterfaceList interfaceList = (InterfaceList)interfaceElement.eContainer();
            return this.getInsertingIndex(interfaceElement, AbstractEditInterfaceDataSection.getDataList(interfaceList, isInput));
        }
        return -1;
    }

    private static EList<VarDeclaration> getDataList(InterfaceList interfaceList, boolean isInput) {
        return isInput ? interfaceList.getInputVars() : interfaceList.getOutputVars();
    }

    public void addEntry(Object entry, int index, CompoundCommand cmd) {
        if (entry instanceof VarDeclaration && !(entry instanceof AdapterDeclaration)) {
            cmd.add((Command)this.newInsertCommand((IInterfaceElement)entry, this.isInputsViewer(), index));
        }
    }

    @Override
    protected TableLayout createTableLayout(Table table) {
        TableLayout layout = super.createTableLayout(table);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(FordiacMessages.InitialValue);
        TableColumn column5 = new TableColumn(table, 16384);
        column5.setText(FordiacMessages.ArraySize);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        return layout;
    }

    @Override
    protected LabelProvider getLabelProvider() {
        return new DataLabelProvider();
    }

    @Override
    protected AbstractEditInterfaceSection.InterfaceCellModifier getCellModifier(TableViewer viewer) {
        return new DataInterfaceCellModifier(viewer);
    }

    @Override
    protected void setCellEditors(TableViewer viewer) {
        super.setCellEditors(viewer);
        CellEditor[] nameTypeCommentEditors = viewer.getCellEditors();
        viewer.setCellEditors(new CellEditor[]{nameTypeCommentEditors[0], nameTypeCommentEditors[1], nameTypeCommentEditors[2], new CustomTextCellEditor((Composite)viewer.getTable()), new CustomTextCellEditor((Composite)viewer.getTable())});
    }

    @Override
    protected String[] getColumnProperties() {
        String[] nameTypeComment = super.getColumnProperties();
        return new String[]{nameTypeComment[0], nameTypeComment[1], nameTypeComment[2], INITIAL_VALUE, ARRAY_SIZE};
    }

    protected class DataInterfaceCellModifier
    extends AbstractEditInterfaceSection.InterfaceCellModifier {
        public DataInterfaceCellModifier(TableViewer viewer) {
            super(AbstractEditInterfaceDataSection.this, viewer);
        }

        @Override
        public boolean canModify(Object element, String property) {
            if (AbstractEditInterfaceDataSection.INITIAL_VALUE.equals(property)) {
                return true;
            }
            if (AbstractEditInterfaceDataSection.ARRAY_SIZE.equals(property)) {
                return true;
            }
            return super.canModify(element, property);
        }

        @Override
        public Object getValue(Object element, String property) {
            switch (property) {
                case "arraysize": {
                    int arraySize = ((VarDeclaration)element).getArraySize();
                    return arraySize <= 0 ? "" : String.valueOf(arraySize);
                }
                case "initialvalue": {
                    if (((VarDeclaration)element).getValue() == null) {
                        return "";
                    }
                    return ((VarDeclaration)element).getValue().getValue();
                }
            }
            return super.getValue(element, property);
        }

        @Override
        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Object data = tableItem.getData();
            ChangeArraySizeCommand cmd = null;
            switch (property) {
                case "arraysize": {
                    cmd = new ChangeArraySizeCommand((VarDeclaration)data, (String)value);
                    break;
                }
                case "initialvalue": {
                    cmd = new ChangeValueCommand((VarDeclaration)data, (String)value);
                    break;
                }
                default: {
                    super.modify(element, property, value);
                }
            }
            if (cmd != null) {
                AbstractEditInterfaceDataSection.this.executeCommand((Command)cmd);
                this.viewer.refresh(data);
            }
        }
    }

    protected static class DataInterfaceContentProvider
    extends AbstractEditInterfaceSection.InterfaceContentProvider {
        public DataInterfaceContentProvider(boolean inputs) {
            super(inputs);
        }

        @Override
        protected Object[] getInputs(Object inputElement) {
            InterfaceList interfaceList = DataInterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                return interfaceList.getInputVars().toArray();
            }
            return new Object[0];
        }

        @Override
        protected Object[] getOutputs(Object inputElement) {
            InterfaceList interfaceList = DataInterfaceContentProvider.getInterfaceListFromInput(inputElement);
            if (interfaceList != null) {
                return interfaceList.getOutputVars().toArray();
            }
            return new Object[0];
        }
    }
}

