/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.draw2d.UnderlineAlphaLabel;
import org.eclipse.fordiac.ide.gef.figures.FBShapeShadowBorder;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.model.edit.providers.ResultListLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.resource.JFaceResources;

public class FBShape
extends Shape
implements IFontUpdateListener {
    private static final int FB_NOTCH_INSET = 9;
    private RoundedRectangle top;
    private RoundedRectangle middle;
    private RoundedRectangle bottom;
    private final Figure eventInputs = new Figure();
    private final Figure eventOutputs = new Figure();
    private final Figure dataInputs = new Figure();
    private final Figure sockets = new Figure();
    private final Figure dataOutputs = new Figure();
    private final Figure errorMarkerInput = new Figure();
    private final Figure errorMarkerOutput = new Figure();
    private final Figure plugs = new Figure();
    private UnderlineAlphaLabel typeLabel;

    public FBShape(FBType fbType) {
        this.configureMainFigure();
        this.createFBFigureShape(fbType);
        this.setTypeLabelFont();
        this.setBorder((Border)new FBShapeShadowBorder());
    }

    public Figure getEventInputs() {
        return this.eventInputs;
    }

    public Figure getEventOutputs() {
        return this.eventOutputs;
    }

    public Figure getDataInputs() {
        return this.dataInputs;
    }

    public Figure getSockets() {
        return this.sockets;
    }

    public Figure getDataOutputs() {
        return this.dataOutputs;
    }

    public Figure getErrorMarkerInput() {
        return this.errorMarkerInput;
    }

    public Figure getErrorMarkerOutput() {
        return this.errorMarkerOutput;
    }

    public Figure getPlugs() {
        return this.plugs;
    }

    public UnderlineAlphaLabel getTypeLabel() {
        return this.typeLabel;
    }

    public RoundedRectangle getTop() {
        return this.top;
    }

    public RoundedRectangle getMiddle() {
        return this.middle;
    }

    public RoundedRectangle getBottom() {
        return this.bottom;
    }

    public void setAlpha(int value) {
        super.setAlpha(value);
        this.bottom.setAlpha(value);
        this.top.setAlpha(value);
        this.getMiddle().setAlpha(value);
        if (this.getTypeLabel() != null) {
            this.getTypeLabel().setAlpha(value);
        }
    }

    @Override
    public void updateFonts() {
        this.setTypeLabelFont();
        this.invalidateTree();
        this.revalidate();
    }

    private void setTypeLabelFont() {
        this.typeLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
    }

    public void paintFigure(Graphics graphics) {
        if (this.getBorder() instanceof AbstractBackground) {
            ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
        }
        super.paintFigure(graphics);
    }

    private void configureMainFigure() {
        this.setFillXOR(false);
        this.setOpaque(false);
        GridLayout mainLayout = new GridLayout(1, true);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = -1;
        this.setLayoutManager((LayoutManager)mainLayout);
    }

    private void createFBFigureShape(FBType fbType) {
        Figure fbFigureContainer = this.createFigureContainer();
        this.createFBTop(fbFigureContainer, 6);
        this.configureFBMiddle(fbType, fbFigureContainer);
        this.createFBBottom(fbFigureContainer, 6);
    }

    private void createFBBottom(Figure fbFigureContainer, int cornerDim) {
        this.bottom = new RoundedRectangle();
        this.bottom.setOutline(false);
        this.bottom.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        GridLayout bottomLayout = new GridLayout(3, false);
        bottomLayout.marginHeight = 4;
        bottomLayout.marginWidth = 0;
        bottomLayout.horizontalSpacing = 0;
        bottomLayout.verticalSpacing = 0;
        this.bottom.setLayoutManager((LayoutManager)bottomLayout);
        GridData bottomLayoutData = new GridData(1808);
        bottomLayoutData.verticalAlignment = 128;
        fbFigureContainer.add((IFigure)this.bottom);
        fbFigureContainer.setConstraint((IFigure)this.bottom, (Object)bottomLayoutData);
        this.setBottomIOs((IFigure)this.bottom);
    }

    private void configureFBMiddle(FBType fbType, Figure fbFigureContainer) {
        Figure middleContainer = new Figure();
        BorderLayout borderLayout = new BorderLayout();
        middleContainer.setLayoutManager((LayoutManager)borderLayout);
        borderLayout.setHorizontalSpacing(10);
        middleContainer.setBorder((Border)new MarginBorder(0, 9, 0, 9));
        fbFigureContainer.add((IFigure)middleContainer);
        GridData middleLayouData = new GridData(768);
        fbFigureContainer.setConstraint((IFigure)middleContainer, (Object)middleLayouData);
        this.setupTypeNameAndVersion(fbType, middleContainer);
    }

    private void createFBTop(Figure fbFigureContainer, int cornerDim) {
        this.top = new RoundedRectangle();
        this.top.setOutline(false);
        this.top.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        GridLayout topLayout = new GridLayout(3, false);
        topLayout.marginHeight = 4;
        topLayout.marginWidth = 0;
        topLayout.horizontalSpacing = 0;
        topLayout.verticalSpacing = 0;
        this.top.setLayoutManager((LayoutManager)topLayout);
        fbFigureContainer.add((IFigure)this.top);
        GridData topLayoutData = new GridData(784);
        fbFigureContainer.setConstraint((IFigure)this.top, (Object)topLayoutData);
        this.setupTopIOs((IFigure)this.top);
    }

    private Figure createFigureContainer() {
        Figure fbFigureContainer = new Figure();
        this.add((IFigure)fbFigureContainer);
        this.setConstraint((IFigure)fbFigureContainer, new GridData(64));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = -1;
        fbFigureContainer.setLayoutManager((LayoutManager)gridLayout);
        return fbFigureContainer;
    }

    private void setupTopIOs(IFigure parent) {
        ToolbarLayout topInputsLayout = new ToolbarLayout(false);
        GridData topInputsLayoutData = new GridData(1808);
        this.eventInputs.setLayoutManager((LayoutManager)topInputsLayout);
        parent.add((IFigure)this.eventInputs);
        parent.setConstraint((IFigure)this.eventInputs, (Object)topInputsLayoutData);
        ToolbarLayout topOutputsLayout = new ToolbarLayout(false);
        GridData topOutputsLayoutData = new GridData(1680);
        topOutputsLayout.setMinorAlignment(2);
        this.eventOutputs.setLayoutManager((LayoutManager)topOutputsLayout);
        parent.add((IFigure)this.eventOutputs);
        parent.setConstraint((IFigure)this.eventOutputs, (Object)topOutputsLayoutData);
    }

    private void setBottomIOs(IFigure parent) {
        Figure bottomInputArea = new Figure();
        bottomInputArea.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        GridData bottomInputsLayoutData = new GridData(1808);
        bottomInputsLayoutData.verticalAlignment = 128;
        parent.add((IFigure)bottomInputArea);
        parent.setConstraint((IFigure)bottomInputArea, (Object)bottomInputsLayoutData);
        this.dataInputs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        bottomInputArea.add((IFigure)this.dataInputs);
        this.sockets.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        bottomInputArea.add((IFigure)this.sockets);
        this.errorMarkerInput.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        bottomInputArea.add((IFigure)this.errorMarkerInput);
        Figure bottomOutputArea = new Figure();
        bottomOutputArea.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)bottomOutputArea.getLayoutManager()).setMinorAlignment(2);
        GridData bottomOutputsLayoutData = new GridData(1808);
        parent.add((IFigure)bottomOutputArea);
        parent.setConstraint((IFigure)bottomOutputArea, (Object)bottomOutputsLayoutData);
        this.dataOutputs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)this.dataOutputs.getLayoutManager()).setMinorAlignment(2);
        bottomOutputArea.add((IFigure)this.dataOutputs);
        this.plugs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)this.plugs.getLayoutManager()).setMinorAlignment(2);
        bottomOutputArea.add((IFigure)this.plugs);
        this.errorMarkerOutput.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)this.errorMarkerOutput.getLayoutManager()).setMinorAlignment(2);
        bottomOutputArea.add((IFigure)this.errorMarkerOutput);
    }

    protected void setupTypeNameAndVersion(FBType type, Figure container) {
        this.middle = new RoundedRectangle();
        this.middle.setOutline(false);
        container.add((IFigure)this.middle, (Object)BorderLayout.CENTER);
        this.middle.setCornerDimensions(new Dimension());
        GridLayout middleLayout = new GridLayout(1, true);
        middleLayout.marginHeight = 2;
        middleLayout.verticalSpacing = 1;
        this.middle.setLayoutManager((LayoutManager)middleLayout);
        String typeName = type != null ? type.getName() : Messages.FBFigure_TYPE_NOT_SET;
        this.typeLabel = new UnderlineAlphaLabel(typeName != null ? typeName : FordiacMessages.ND);
        this.typeLabel.setTextAlignment(2);
        this.typeLabel.setOpaque(false);
        this.typeLabel.setIcon(ResultListLabelProvider.getTypeImage((LibraryElement)type));
        this.middle.add((IFigure)this.typeLabel);
        this.middle.setConstraint((IFigure)this.typeLabel, (Object)new GridData(768));
    }

    protected void changeTypeLabelText(String text) {
        this.typeLabel.setText(text);
        this.typeLabel.setIcon(null);
    }
}

