/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.search.SearchParticipantXML;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.xml.sax.Attributes;

public class CheatsheetSearchParticipant
extends SearchParticipantXML {
    private static final String INTRO_DESC = "cheatsheet/intro/description";
    private static final String ITEM_DESC = "cheatsheet/item/description";
    private static final String CCS_DESC = "compositeCheatsheet/taskGroup/intro";

    public Set<String> getAllDocuments(String locale) {
        IConfigurationElement[] elements;
        HashSet<String> set = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.cheatsheets.cheatSheetContent");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId;
            String id;
            String fileName;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("cheatsheet") && CheatsheetSearchParticipant.isExtensionValid(fileName = element.getAttribute("contentFile"), id = element.getAttribute("id"), pluginId = element.getContributor().getName())) {
                try {
                    fileName = CheatsheetSearchParticipant.resolveVariables((String)pluginId, (String)fileName, (String)locale);
                    set.add("/" + pluginId + "/" + fileName + "?id=" + id);
                }
                catch (Throwable t) {
                    CheatSheetPlugin.logError("Error parsing cheat sheet extension from plug-in " + pluginId + ", id " + id + ", file " + fileName, t);
                }
            }
            ++n2;
        }
        return set;
    }

    public Set<String> getContributingPlugins() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.cheatsheets.cheatSheetContent");
        HashSet<String> set = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("cheatsheet")) {
                set.add(element.getContributor().getName());
            }
            ++n2;
        }
        return set;
    }

    protected void handleStartElement(String name, Attributes attributes, SearchParticipantXML.IParsedXMLContent data) {
        switch (name) {
            case "cheatsheet": {
                data.setTitle(attributes.getValue("title"));
                data.addText(attributes.getValue("title"));
                break;
            }
            case "compositeCheatsheet": {
                data.addText(attributes.getValue("name"));
                data.setTitle(attributes.getValue("name"));
                break;
            }
            case "item": {
                data.addText(attributes.getValue("title"));
                break;
            }
            case "subitem": {
                data.addText(attributes.getValue("label"));
                break;
            }
            case "task": 
            case "taskGroup": {
                data.addText(attributes.getValue("name"));
                break;
            }
        }
    }

    protected void handleEndElement(String name, SearchParticipantXML.IParsedXMLContent data) {
    }

    protected void handleText(String text, SearchParticipantXML.IParsedXMLContent data) {
        String stackPath = this.getElementStackPath();
        String top = this.getTopElement();
        if ("intro".equals(top)) {
            data.addText(text);
            if (stackPath.equalsIgnoreCase(CCS_DESC)) {
                data.addToSummary(text);
            }
        } else if ("onCompletion".equals(top)) {
            data.addText(text);
        } else {
            if (stackPath.equalsIgnoreCase(INTRO_DESC)) {
                data.addText(text);
                data.addToSummary(text);
                return;
            }
            if (stackPath.equalsIgnoreCase(ITEM_DESC)) {
                data.addText(text);
                return;
            }
        }
    }

    public boolean open(String id) {
        OpenCheatSheetAction openAction = new OpenCheatSheetAction(id);
        openAction.run();
        return true;
    }

    private static boolean isExtensionValid(String fileName, String id, String pluginId) {
        if (fileName.indexOf(92) != -1) {
            CheatSheetPlugin.logError("Error in cheat sheet extension id " + id + " from plug-in " + pluginId + ": path should not contain back-slashes (\\): " + fileName + ". This cheat sheet will not be indexed for searching.", null);
            return false;
        }
        return true;
    }
}

