/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.LibraryRecord;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.model.util.VersionComparator;
import org.eclipse.fordiac.ide.library.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class LibrarySelectionPage
extends WizardPage {
    private List<LibDisplay> libraries;
    private Map<String, List<LibDisplay>> libGroupings;
    private CheckboxTableViewer tableViewer;
    private boolean showStandard;
    private boolean showWorkspace;
    private final boolean selectAll;
    private final VersionComparator versionComparator;

    public LibrarySelectionPage(String pageName, boolean alwaysComplete, boolean selectAll, boolean showStandard, boolean showWorkspace) {
        super(pageName);
        this.setPageComplete(alwaysComplete);
        this.showStandard = showStandard;
        this.showWorkspace = showWorkspace;
        this.selectAll = selectAll;
        this.versionComparator = new VersionComparator();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.findLibs();
        if (this.selectAll) {
            this.selectAll();
        }
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)0);
        this.configureTableViewer(this.tableViewer);
        this.tableViewer.setInput(this.libraries);
        this.configureSelectionListener();
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setFont(parent.getFont());
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.createButtons(buttonComposite);
        buttonComposite.layout();
        tableComposite.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() || this.libraries.stream().anyMatch(LibDisplay::isSelected);
    }

    private void configureSelectionListener() {
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrarySelectionPage.this.setPageComplete(LibrarySelectionPage.this.isPageComplete());
            }
        });
    }

    private void findLibs() {
        this.libGroupings = new HashMap<String, List<LibDisplay>>();
        if (this.showStandard) {
            LibraryManager.INSTANCE.getStandardLibraries().forEach((symbolicName, reclist) -> {
                List libd = this.libGroupings.computeIfAbsent((String)symbolicName, s -> new ArrayList());
                reclist.forEach(rec -> {
                    boolean bl = libd.add(new LibDisplay((LibraryRecord)rec));
                });
            });
        }
        if (this.showStandard) {
            LibraryManager.INSTANCE.getExtractedLibraries().forEach((symbolicName, reclist) -> {
                List libd = this.libGroupings.computeIfAbsent((String)symbolicName, s -> new ArrayList());
                reclist.forEach(rec -> {
                    boolean bl = libd.add(new LibDisplay((LibraryRecord)rec));
                });
            });
        }
        this.libraries = new ArrayList<LibDisplay>();
        this.libGroupings.values().forEach(this.libraries::addAll);
    }

    public Map<Required, URI> getChosenLibraries() {
        HashMap<Required, URI> libs = new HashMap<Required, URI>();
        this.libraries.stream().filter(LibDisplay::isSelected).forEach(lib -> {
            URI uRI = libs.put(ManifestHelper.createRequired((String)lib.getSymbolicName(), (String)lib.getVersion()), lib.getUri());
        });
        return libs;
    }

    private void selectAll() {
        this.deselectAll();
        VersionComparator comparator = new VersionComparator();
        this.libGroupings.forEach((symb, list) -> list.stream().max((l1, l2) -> comparator.compare(l1.getVersion(), l2.getVersion())).ifPresent(lib -> lib.setSelected(true)));
    }

    private void deselectAll() {
        this.libraries.forEach(lib -> lib.setSelected(false));
    }

    private void selectLib(LibDisplay lib, boolean selected) {
        if (!lib.isSelected()) {
            this.libGroupings.get(lib.getSymbolicName()).forEach(l -> l.setSelected(false));
        }
        lib.setSelected(selected);
    }

    private void configureTableViewer(CheckboxTableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)this.createTableLayout());
        table.setSortDirection(1024);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)viewer, 16384);
        nameColumn.getColumn().setText(Messages.LibraryPage_Name);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LibDisplay)element).getName();
            }
        });
        TableViewerColumn versionColumn = new TableViewerColumn((TableViewer)viewer, 16384);
        versionColumn.getColumn().setText(Messages.LibraryPage_Version);
        versionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LibDisplay)element).getVersion();
            }
        });
        TableViewerColumn commentColumn = new TableViewerColumn((TableViewer)viewer, 16384);
        commentColumn.getColumn().setText(Messages.LibraryPage_Comment);
        commentColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LibDisplay)element).getComment();
            }
        });
        TableViewerColumn symNameColumn = new TableViewerColumn((TableViewer)viewer, 16384);
        symNameColumn.getColumn().setText(Messages.LibraryPage_SymbolicName);
        symNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LibDisplay)element).getSymbolicName();
            }
        });
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LibDisplay lib1 = (LibDisplay)e1;
                LibDisplay lib2 = (LibDisplay)e2;
                int comp = lib1.getSymbolicName().compareTo(lib2.getSymbolicName());
                if (comp == 0) {
                    comp = LibrarySelectionPage.this.versionComparator.compare(lib1.getVersion(), lib2.getVersion());
                }
                return comp;
            }
        });
        viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ((LibDisplay)element).isSelected();
            }
        });
        viewer.addCheckStateListener(event -> {
            LibDisplay lib = (LibDisplay)event.getElement();
            this.selectLib(lib, event.getChecked());
            viewer.update(this.libGroupings.get(lib.getSymbolicName()).toArray(), null);
        });
    }

    private TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(180, 100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(150, 200, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 100, true));
        return layout;
    }

    private void createButtons(Composite buttonComposite) {
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setFont(buttonComposite.getFont());
        selectAllButton.setText(Messages.LibraryPage_SelectAll);
        this.setButtonLayoutData(selectAllButton);
        Button deselectButton = new Button(buttonComposite, 8);
        deselectButton.setFont(buttonComposite.getFont());
        deselectButton.setText(Messages.LibraryPage_DeselectAll);
        this.setButtonLayoutData(deselectButton);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrarySelectionPage.this.selectAll();
                LibrarySelectionPage.this.tableViewer.refresh();
            }
        });
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrarySelectionPage.this.deselectAll();
                LibrarySelectionPage.this.tableViewer.refresh();
            }
        });
    }

    public boolean isShowStandard() {
        return this.showStandard;
    }

    public void setShowStandard(boolean showStandard) {
        this.showStandard = showStandard;
        this.findLibs();
        this.tableViewer.setInput(this.libraries);
    }

    public boolean isShowWorkspace() {
        return this.showWorkspace;
    }

    public void setShowWorkspace(boolean showWorkspace) {
        this.showWorkspace = showWorkspace;
        this.findLibs();
        this.tableViewer.setInput(this.libraries);
    }

    private class LibDisplay {
        private boolean selected;
        private final LibraryRecord libraryRecord;

        public LibDisplay(boolean selected, LibraryRecord libRecord) {
            this.selected = selected;
            this.libraryRecord = libRecord;
        }

        public LibDisplay(LibraryRecord libRecord) {
            this(false, libRecord);
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public String getName() {
            return this.libraryRecord.name();
        }

        public String getSymbolicName() {
            return this.libraryRecord.symbolicName();
        }

        public String getVersion() {
            return this.libraryRecord.version().toString();
        }

        public String getComment() {
            return this.libraryRecord.comment();
        }

        public URI getUri() {
            return this.libraryRecord.uri();
        }

        public LibraryRecord getLibraryRecord() {
            return this.libraryRecord;
        }
    }
}

