#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# Copyright 2001 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
#
# @(#)cmn.Makefile 1.12 06/12/12
#

CC	= cc
LINT	= lint
LINTFLAGS =
AR	= ar
CCSBIN	= $(DESTDIR)/usr/ccs/bin
CCSLIB	= $(DESTDIR)/usr/lib

SGSBASE	= ../../../..
INCBASE	= ../../../hdr
INCLIST	= -I$(SGSBASE)/sgs/inc/common -I$(INCBASE)

SOURCES	= auxf.c chkid.c chksid.c cmpdate.c date_ab.c date_ba.c del_ab.c del_ba.c \
          dodelt.c dofile.c dohist.c doie.c dolist.c encode.c eqsid.c   \
          flushto.c fmterr.c getline.c logname.c newstats.c permiss.c   \
          pf_ab.c putline.c rdmod.c setup.c sid_ab.c sid_ba.c           \
          sidtoser.c sinit.c strptim.c newsid.c getser.c stats_ab.c
FILES	= $(SOURCES:%.c=%.o)
LFILES	= $(SOURCES:%.c=%.ln)
SRC_DIR_SOURCES = $(SOURCES:%=$(SRC_DIR)/%)

LIBRARY	= comobj.a
LLIBRARY = llib-lcom.ln
PRODUCTS = $(LIBRARY) 

all: $(PRODUCTS) messages.po
	@echo "Library $(PRODUCTS) is up to date\n"

install: $(PRODUCTS) messages.po

clean:
	-$(RM) *.o *.a
	-$(RM) lint.out
	-$(RM) *.ln
	-rm -f messages.po

clobber: clean
	-$(RM) $(PRODUCTS)

.SUFFIXES : .o .c .e .r .f .y .yr .ye .l .s .ln

$(LIBRARY): $(FILES)
	$(AR) crv $(LIBRARY) $(FILES)

%.o: $(SRC_DIR)/%.c
	$(CC) $(CPPFLAGS) $(CFLAGS) $(INCLIST) -c $<

lintit: $(LLIBRARY)
	@echo "Library $(LLIBRARY) is up to date"

$(LLIBRARY): $(LFILES)
	$(RM) $(LLIBRARY)
	$(LINT) $(CFLAGS) $(LINTFLAGS) *.ln -o com >> lint.out

%.ln: $(SRC_DIR)/%.c
	echo "$<:" >> lint.out
	$(LINT) $(CFLAGS) $(LINTFLAGS) $(INCLIST) $< -c >> lint.out

auxf.o:		$(INCBASE)/defines.h $(SRC_DIR)/auxf.c
chkid.o:	$(INCBASE)/defines.h $(SRC_DIR)/chkid.c
chksid.o:	$(INCBASE)/defines.h $(SRC_DIR)/chksid.c
cmpdate.o:	$(SRC_DIR)/cmpdate.c
date_ab.o:	$(SRC_DIR)/date_ab.c
date_ba.o:	$(INCBASE)/defines.h $(SRC_DIR)/date_ba.c
del_ab.o:	$(INCBASE)/defines.h $(SRC_DIR)/del_ab.c
del_ba.o:	$(INCBASE)/defines.h $(SRC_DIR)/del_ba.c
dodelt.o:	$(INCBASE)/defines.h $(SRC_DIR)/dodelt.c
dofile.o:	$(INCBASE)/defines.h $(SRC_DIR)/dofile.c
dohist.o:	$(INCBASE)/defines.h $(INCBASE)/had.h $(SRC_DIR)/dohist.c
doie.o:		$(INCBASE)/defines.h $(SRC_DIR)/doie.c
dolist.o:	$(INCBASE)/defines.h $(SRC_DIR)/dolist.c
encode.o:	$(INCBASE)/defines.h $(SRC_DIR)/encode.c
eqsid.o:	$(INCBASE)/defines.h $(SRC_DIR)/eqsid.c
flushto.o:	$(INCBASE)/defines.h $(SRC_DIR)/flushto.c
fmterr.o:	$(INCBASE)/defines.h $(SRC_DIR)/fmterr.c
getline.o:	$(INCBASE)/defines.h $(SRC_DIR)/getline.c
logname.o:	$(SRC_DIR)/logname.c
newstats.o:	$(INCBASE)/defines.h $(SRC_DIR)/newstats.c
permiss.o:	$(INCBASE)/defines.h $(SRC_DIR)/permiss.c
pf_ab.o:	$(INCBASE)/defines.h $(SRC_DIR)/pf_ab.c
putline.o:	$(INCBASE)/defines.h $(SRC_DIR)/putline.c
rdmod.o:	$(INCBASE)/defines.h $(SRC_DIR)/rdmod.c
setup.o:	$(INCBASE)/defines.h $(SRC_DIR)/setup.c
sid_ab.o:	$(INCBASE)/defines.h $(SRC_DIR)/sid_ab.c
sid_ba.o:	$(INCBASE)/defines.h $(SRC_DIR)/sid_ba.c
sidtoser.o:	$(INCBASE)/defines.h $(SRC_DIR)/sidtoser.c
sinit.o:	$(INCBASE)/defines.h $(SRC_DIR)/sinit.c
stats_ab.o:	$(INCBASE)/defines.h $(SRC_DIR)/stats_ab.c
strptim.o:	$(SRC_DIR)/strptim.c

auxf.ln:	$(INCBASE)/defines.h $(SRC_DIR)/auxf.c
chkid.ln:	$(INCBASE)/defines.h $(SRC_DIR)/chkid.c
chksid.ln:	$(INCBASE)/defines.h $(SRC_DIR)/chksid.c
cmpdate.ln:	$(SRC_DIR)/cmpdate.c
date_ab.ln:	$(SRC_DIR)/date_ab.c
date_ba.ln:	$(INCBASE)/defines.h $(SRC_DIR)/date_ba.c
del_ab.ln:	$(INCBASE)/defines.h $(SRC_DIR)/del_ab.c
del_ba.ln:	$(INCBASE)/defines.h $(SRC_DIR)/del_ba.c
dodelt.ln:	$(INCBASE)/defines.h $(SRC_DIR)/dodelt.c
dofile.ln:	$(INCBASE)/defines.h $(SRC_DIR)/dofile.c
dohist.ln:	$(INCBASE)/defines.h $(INCBASE)/had.h $(SRC_DIR)/dohist.c
doie.ln:	$(INCBASE)/defines.h $(SRC_DIR)/doie.c
dolist.ln:	$(INCBASE)/defines.h $(SRC_DIR)/dolist.c
encode.ln:	$(INCBASE)/defines.h $(SRC_DIR)/encode.c
eqsid.ln:	$(INCBASE)/defines.h $(SRC_DIR)/eqsid.c
flushto.ln:	$(INCBASE)/defines.h $(SRC_DIR)/flushto.c
fmterr.ln:	$(INCBASE)/defines.h $(SRC_DIR)/fmterr.c
getline.ln:	$(INCBASE)/defines.h $(SRC_DIR)/getline.c
logname.ln:	$(SRC_DIR)/logname.c
newstats.ln:	$(INCBASE)/defines.h $(SRC_DIR)/newstats.c
permiss.ln:	$(INCBASE)/defines.h $(SRC_DIR)/permiss.c
pf_ab.ln:	$(INCBASE)/defines.h $(SRC_DIR)/pf_ab.c
putline.ln:	$(INCBASE)/defines.h $(SRC_DIR)/putline.c
rdmod.ln:	$(INCBASE)/defines.h $(SRC_DIR)/rdmod.c
setup.ln:	$(INCBASE)/defines.h $(SRC_DIR)/setup.c
sid_ab.ln:	$(INCBASE)/defines.h $(SRC_DIR)/sid_ab.c
sid_ba.ln:	$(INCBASE)/defines.h $(SRC_DIR)/sid_ba.c
sidtoser.ln:	$(INCBASE)/defines.h $(SRC_DIR)/sidtoser.c
sinit.ln:	$(INCBASE)/defines.h $(SRC_DIR)/sinit.c
stats_ab.ln:	$(INCBASE)/defines.h $(SRC_DIR)/stats_ab.c
strptim.ln:	$(SRC_DIR)/strptim.c

messages.po: $(SRC_DIR_SOURCES)
	$(RM) $@
	/bin/xgettext -s $(SRC_DIR_SOURCES)
