#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# Copyright 2005 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
#
# @(#)cmn.Makefile 1.60 06/12/12
#

include $(TOP)/global.macro.Makefile

CC	= cc
LINT	= lint
LINTFLAGS =
CCSBIN	= $(DESTDIR)/usr/ccs/bin
XPG4BIN	= $(DESTDIR)/usr/xpg4/bin
CCSLIB	= $(DESTDIR)/usr/lib
INSDIR	= $(CCSBIN)
INSXPG4 = $(XPG4BIN)
HELPLIB	= $(CCSLIB)/help

SGSBASE	= $(SGS_DIR)
INCBASE = $(HDR_DIR)
INCLIST	= -I$(SGSBASE)/sgs/inc/common -I$(INCBASE)

INSTALL = /usr/sbin/install
LDFLAGS += -L/usr/lib
LINK_MODE = 
LIBS    = \
        $(LIB_DIR)/comobj/$(CPU)/comobj.a \
        $(LIB_DIR)/cassi/$(CPU)/cassi.a \
        $(LIB_DIR)/mpwlib/$(CPU)/mpwlib.a
CMD_LDLIBS = -lintl

DATE:sh     = date '+%B %Y'
PRODVER_V   = SunOS 5.11
VERSTRING   = RELEASE VERSION ${PRODVER_V} ${RELEASE_VER} ${DATE}

SOURCES = admin.c comb.c delta.c get.c prs.c prt.c sccs.c unget.c \
	  val.c vc.c what.c
LFILES	= $(SOURCES:%.c=%.out) rmchg.out help.out help2.out
SRC_DIR_SOURCES = $(SOURCES:%=$(SRC_DIR)/%)

LLIBS	= \
	$(LIB_DIR)/comobj/$(CPU)/llib-lcom.ln \
	$(LIB_DIR)/cassi/$(CPU)/llib-lcassi.ln \
	$(LIB_DIR)/mpwlib/$(CPU)/llib-lmpw.ln

C_CMDS	= admin cdc comb delta get prs prt rmdel sact sccs unget \
	  val vc what

XPG4_CMDS = delta get sccs

CMDS	= $(C_CMDS) sccsdiff 

MORE_CATALOGS = \
	$(LIB_DIR)/comobj/$(CPU)/messages.po \
	$(LIB_DIR)/cassi/$(CPU)/messages.po \
	$(LIB_DIR)/mpwlib/$(CPU)/messages.po

all:	all_$(TARG_DIR) 

all_xpg4 := CPPFLAGS += -DXPG4

all_ccs: $(CMDS) help help2 messages.po SUNW_SPRO_SCCS.po
 
all_xpg4: $(XPG4_CMDS) 

%: %.o $(LIBS)
	$(CC) $(LDFLAGS) -o $@ $< $(LINK_MODE) $(LIBS) $(CMD_LDLIBS) 

%.o: $(SRC_DIR)/%.c
	$(CC) $(CPPFLAGS) $(CFLAGS) $(INCLIST) -c  $<
			

cdc rmdel: rmchg
	-$(RM) $@
	-ln rmchg $@

sact: unget
	-$(RM) $@
	-ln unget $@

sccsdiff: $(SRC_DIR)/sccsdiff.sh
	cp $(SRC_DIR)/sccsdiff.sh $@
	chmod +x $@

install: install_$(TARG_DIR) SUNW_SPRO_SCCS.po
	test -d $(DESTDIR)/usr/lib/locale/C/LC_MESSAGES/SUNW_SPRO_SCCS.po || mkdir -p $(DESTDIR)/usr/lib/locale/C/LC_MESSAGES
	mv SUNW_SPRO_SCCS.po $(DESTDIR)/usr/lib/locale/C/LC_MESSAGES

install_ccs: all_ccs 
	for i in $(C_CMDS) help help2; do \
	   if [ "$(STRIPFLAG)" = "-s" ]; \
	   then \
		strip $$i; \
		mcs -d $$i; \
	   fi; \
	   mcs -a '@(#)$(VERSTRING)' $$i; \
	done
	-chmod 755 $(CMDS) help help2
	$(INSTALL) -d $(INSDIR)
	for i in $(CMDS); do \
		$(INSTALL) -f $(INSDIR) $$i; \
	done
	$(INSTALL) -d  $(HELPLIB)/lib
	$(INSTALL) -u $(OWN) -g $(GRP) -f $(HELPLIB)/lib help2
	$(INSTALL) -u $(OWN) -g $(GRP) -f $(INSDIR) help
	$(INSTALL) -d $(DESTDIR)/usr/ccs/lib
	(cd $(DESTDIR)/usr/ccs/lib; rm -f help; ln -s ../../lib/help help)

install_xpg4: all_xpg4
	for i in $(XPG4_CMDS); do \
	   if [ "$(STRIPFLAG)" = "-s" ]; \
	   then \
		strip $$i; \
		mcs -d $$i; \
	   fi; \
	   mcs -a '@(#)$(VERSTRING)' $$i; \
	done
	-chmod 775 $(XPG4_CMDS) 
	$(INSTALL) -d $(INSXPG4)
	for i in $(XPG4_CMDS); do \
		$(INSTALL) -f $(INSXPG4) $$i; \
	done

get_only: get

install_codemgr: get $(INSDIR)/bin/get
	install -d $(INSDIR)/CodeManager/bin
	install $(STRIP2) get $(INSDIR)/CodeManager/bin/get

$(INSDIR)/bin/get: FRC
	@if [ ! -h $@ ]; then \
		echo install -d ${@D}; \
		install -d ${@D}; \
		echo rm -f $@; \
		rm -f $@; \
		echo ln -s ../CodeManager/bin/${@F} $@; \
		ln -s ../CodeManager/bin/${@F} $@; \
	fi

FRC:

clean:
	-$(RM) *.o
	-$(RM) messages.po SUNW_SPRO_SCCS.po
	-$(RM) $(LFILES)

clobber: clean
	-$(RM) $(CMDS) rmchg help help2

lintit: $(LFILES)

%.out: $(SRC_DIR)/%.c
	$(RM) $@
	$(LINT) $< $(LINTFLAGS) $(CFLAGS) $(INCLIST) $(LLIBS) > $@

SUNW_SPRO_SCCS.po: messages.po $(MORE_CATALOGS)
	$(RM) $@
	cat messages.po $(MORE_CATALOGS) > $@

messages.po: $(SRC_DIR_SOURCES)
	$(RM) $@
	/bin/xgettext -s $(SRC_DIR_SOURCES)

$(MORE_CATALOGS):
	cd $(@D); $(MAKE) $(@F)

