//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<T, 6>, 287> igamma_big_data = { {
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1730655441178896580822765827178955078125e-7), SC_(-1), SC_(0.2993117912029903240422582053899047098779533956541385552546168739467202263345519375546082579259835689e-4), SC_(577797.90391619920649973095027584836128926282155274216943338008435801586707772349755359609709258809), SC_(0.9999700688208797009675957741794610095290122046604345861444745383126053279773665448062442806862583006) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.8653277063785935752093791961669921875e-6), SC_(13.38277582367555562294055416847373915500263659346494217875993623821221196887112446988546507684731302), SC_(0.2316099655383339755405731669847576162961123204586203558223557251327214945205980959748823352959805302e-4), SC_(577801.8158305834504756449335090514614341009677858339594077124115869397920785194231187741120056354752), SC_(0.9999768390034461666024459426833015242383703887679541379644177644274867278505479401904023114002150846) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.15575898260067333467304706573486328125e-5), SC_(12.79500378214091254793715786456975103024623413471734292810881005720669047076428987935745392946724363), SC_(0.2214376467251173939070843604623148303831679646741287024258011317172427658231597089388494422353631048e-4), SC_(577802.4036026249851187199369053553654222257241882927070069630627131207976000175299533646400167828553), SC_(0.9999778562353274882606092915639537685169616832035325871297574198868282757234176840291059234224082336) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.1730655412757187150418758392333984375e-5), SC_(12.68964583907062077871829961486723468135682689673266287978904878277523088091119954467857396528045035), SC_(0.2196142619591161296471772336172777007255716660501426039935550192381060291894820144394071807910637318e-4), SC_(577802.5089605680554104891557636050679385746135955306916870113824743952290596073830436993188967470421), SC_(0.9999780385738040883870352822766382722299274428333949857396006444980761893970810517985558692139197711) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.19037209995076409541070461273193359375e-5), SC_(12.59433798893655043954589862357055470940362305301481664366705173244103638298812628401438143132385277), SC_(0.2179648098442542012919725801196235526752581619134538802152189012490537997981862095991665699048812574e-4), SC_(577802.6042684181894808283281645963646185465667993744095332475044714455632541053061169599830892809987), SC_(0.9999782035190155745798708027419880376447324741838086546119784781098750946200201813790398946910551472) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.346131082551437430083751678466796875e-5), SC_(11.99651588829393824582180456312241868001302147867883382726363976385247472204566448446731588772998297), SC_(0.2076185589653493482621881863527269295135816556729123147246768142978789975019603223353600738511731743e-4), SC_(577803.2020905188320930220522586568127545759574009487455160639078834141518157662485787595301548245925), SC_(0.9999792381441034650651737811813647273070486418344327087685275323185702121002498039677662842228674524) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(100), SC_(0.3683627182454331134963955188773865444199332047934531274456895593248745425858894973030111393161584247e-45), SC_(0.6375095690349819561521120606914926108297136245134545709768047316328210161282911224399118544097308838e-51), SC_(577815.1986064071260312678740632199351732559704224270559871729260900645078949694168616600942877298302), SC_(0.9999999999999999999999999999999999999999999999999993624904309650180438478879393085073891702863754865) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.2165750601079707848839461803436279296875e-7), SC_(17.07036298743991829639232909707087901526592903518599127734139540188516463205963663609773648657087723), SC_(0.3697019560232757110772732624480593336583723516402296244222007952690817919777008967240987096315205331e-4), SC_(461716.0286732860299357310725043145832190410385140498351914099753626833373215850444505022444334646984), SC_(0.999963029804397672428892272673755194066634162764835977037557779920473091820802229910327270922330567) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.1082875314750708639621734619140625e-5), SC_(13.15847397691465595815267467658117236635160976637264298180412548481293452753278961720297628581992752), SC_(0.2849800892415757764539734483805658830800200360898241591461531657548830413725265774914562236687744426e-4), SC_(461719.9405622965551980693121587350729256899528333186485397055126326004095516895712975211391936654494), SC_(0.9999715019910758424223546026551619434116919979963910175840853846834245116958627473422506079043676802) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.1949175612026010639965534210205078125e-5), SC_(12.57070526636212517657129379971158284943858132030323149197288591584777613568565108919579056236543589), SC_(0.2722504687794664306569369785134358990534116641373655972975320770778744429628254055229370221303254972e-4), SC_(461720.5283310071077288508935396119425152068658617647179511953438721693747100814184360491463793889039), SC_(0.9999727749531220533569343063021486564100946588335862634402702467922922125557037174594474707528583518) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.216575062950141727924346923828125e-5), SC_(12.46534797873423664682712357366176987162472172738379809193584747614716729169916499965524978602165451), SC_(0.2699686898069866664183548452276314691424700035617881842498407894456650352425582613848998322249744459e-4), SC_(461720.6336882947356173806377098379923281846797213576373845953809106090753189254049221386869201652476), SC_(0.9999730031310193013333581645154772368530857529996438211815750159210554334964757441738612764307485453) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.2382325646976823918521404266357421875e-5), SC_(12.37004071696991805388122752478307298700621276058091950265758048467078476384585545609003052590305182), SC_(0.2679045696050075721547716691574204592244930158617242358470809118887179680331039379286281767451411551e-4), SC_(461720.7289955564999359735836058868710250692982303244402631846591776005517014532582316822521394253662), SC_(0.9999732095430394992427845228330842579540775506984138275764152919088111282031966896062069053683368566) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.43315012590028345584869384765625e-5), SC_(11.77222202288641210205964167726460731035184670773110091246245945382178746024664362553109279728970161), SC_(0.2549572912892171401404180030095052432599185661069912133627122154282800848058328121324720391504851142e-4), SC_(461721.3268142505834419254051917343894907459525963772900817748542986314006987568574435128110771539796), SC_(0.9999745042708710782859859581996990494756740081433893008786637287784571719915194167187865320972916923) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(100), SC_(0.3683634579017030862943995949753137846949736979296757741127256914376144677962154307133740093495808363e-45), SC_(0.7977843881466350722692047722021738976382706440159930605192038431116437783506465250207545631610617926e-51), SC_(461733.0990362734698540274648334116540980563044430846528192294150549989280866221287773176113335726772), SC_(0.999999999999999999999999999999999999999999999999999202215611853364927730795227797826102361729355984) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.7270019608540678746066987514495849609375e-7), SC_(15.85873131324027603680994500593701083673995551510827497457378784799406402441597983944788065984676601), SC_(0.0001152937700708314574190375921633958573930633611632172214032709001883959995018869165672190219989383104), SC_(137534.7765154773198155043727784530103263311602038221971826660153368209797591918890572085146268195923), SC_(0.9998847062299291685425809624078366041426069366388367827785967290998116040004981130834317859606150677) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.363500976163777522742748260498046875e-5), SC_(11.94712370377855206849356853972802387128008268591504291389545599044297977188193456270625002844103574), SC_(0.868561870495419015631694962376837056380169046553848836742030704855372577688384839675927895023169524e-4), SC_(137538.688123086781539472689154919219313296620076651390414726693668678530843444423102485256257450998), SC_(0.9999131438129504580984368305037623162943619830953446151163257969295144627422311615160316563336632746) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.654301766189746558666229248046875e-5), SC_(11.35939219617933366143120008086493854405691096926337486689608980095578074772077473924953323650483309), SC_(0.8258334958467143799950171794348266133126127344865110178937324906877842427949992341364148713573494716e-4), SC_(137539.2758545943807578797515233780823986238432483680420827736930348680180424685842623087129742429342), SC_(0.9999174166504153285620004982820565173386687387265513488982106267509312215757205000765856443189256825) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.72700195232755504548549652099609375e-5), SC_(11.25404152411781013189063221030791950069213486896481451201744166449599357258178579846150790743580515), SC_(0.8181744492801532375947886460140903722510746521679776491443785314602565395703504194717704954065827439e-4), SC_(137539.3812052664422814092920912486394176672080244683406431285716830044778296437232512495009995720032), SC_(0.9999181825550719846762405211353985909627748925347832022350855621468539743460429649580521153319173109) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.7997021384653635323047637939453125e-5), SC_(11.15874024755388081703378542276070157549981458020172273054652486564002395885863126609049696032298202), SC_(0.8112459987940510325956129320339107435160215638035605125726023380005315176840924661421761839904966304e-4), SC_(137539.476506543006210724148938036186635592400344757103734910042599803333799257446405781872010519116), SC_(0.9999188754001205948967404387067966089256483978436196439487427397661999468482315907533850807112287131) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.14540039046551100909709930419921875e-4), SC_(10.56095948655061168623605418003161853323578819344933772554926100916849496396397890725434425870422914), SC_(0.767787038395159161757367222671493221399764679021626603575413867936745207659445426399210347886488265e-4), SC_(137540.0742873040094798549466692789157186346643711438561199150398636598053282523410581407081632207348), SC_(0.9999232212961604840838242632777328506778600235320978373396424586132063254792340554573594146049528292) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(100), SC_(0.3683721352040578625035542191213058231001385172015235695102827758219171635643319097964745619715389846e-45), SC_(0.2678083852852675296525747931813028293308341797284316939479666731722330013321908997535126058327254522e-50), SC_(137550.635246790560091541182723458947337167900159336937085505385066806470268997183732405754158996547), SC_(0.9999999999999999999999999999999999999999999999999973219161471473247034742520681869717066916582027157) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.14000005421621608547866344451904296875e-6), SC_(15.20267805917854753815628244090214839667049079013284121307207600981527369429051379479050029246563141), SC_(0.000212839284799294089771515202962972979787263184811743923962510356993572455648372128284605839985121416), SC_(71412.76736757672594226777131614926452425899670482796435759812610549247602601578025739683076592211497), SC_(0.9997871607152007059102284847970370270202127368151882560760374896430064275443516278717135571888613995) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.70000023697502911090850830078125e-5), SC_(11.29141909326230883966958875900019584358646658107430454213881289111615105204428414548153264983317026), SC_(0.0001580811982483630764639288404865989626895654210675549296284020672607670587485524042452843453497320055), SC_(71416.67862654264218096625800983116647681208072903702289426905936861117514865802648704613973356474743), SC_(0.9998419188017516369235360711595134010373104345789324450703715979327392329412514475957533488014886493) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.126000040836515836417675018310546875e-4), SC_(10.70373329082055239449657483518606481142874325545821945131987913327529111609288538115779787067004457), SC_(0.0001498535277424495070345925587342959337960485628714949943651616208608914719572016270715187995841055091), SC_(71417.26631234508393741143102375498060784423845236263897935987830236901600859397788581046346834391056), SC_(0.9998501464722575504929654074412657040662039514371285050056348383791391085280427983729271849847834439) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.14000004739500582218170166015625e-4), SC_(10.59839072270521094524351095575880524386997946950893653234037834073484898520661255840222881734977303), SC_(0.0001483787193718905056334122230314149572977420671679956361699029601390606768301478556951013052574995591), SC_(71417.37165491319927886068408763440786741179721614858826227885780316155645072486415863321903739723083), SC_(0.9998516212806281094943665877769685850427022579328320043638300970398609393231698521443036151408736946) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.1540000448585487902164459228515625e-4), SC_(10.50309683838772573125941726421973020244283911278816693802809721877148404719015973281760898508378721), SC_(0.0001470445937589604281730698265658277177395861433369834394530184624954932090593614476786270573218152004), SC_(71417.46694879751676407466818132594694245322435650530903187317008428351981566288061145880365722949682), SC_(0.9998529554062410395718269301734341722822604138566630165605469815375045067909406385523201008427606316) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.2800000947900116443634033203125e-4), SC_(9.905362625758730832950380165732997088838389659552109844584580076431198316831313148705327140762918642), SC_(0.0001386762443259988347965664731737503432671106791399389549124501709095361518293591970133145764479534118), SC_(71418.06468301014575897297721842443367556682880595854508896661360142586010139323945804291593907381769), SC_(0.9998613237556740011652034335268262496567328893208600610450875498290904638481706408029854851689431666) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(100), SC_(0.3683835765509991294862982614804136847801099409567709282365033456679433396999382650467739713261291934e-45), SC_(0.515741349384052073532197492849381798262021063178704056359276164773687862416427823871341331934634477e-50), SC_(71427.97004563590448980592759859016667265566719561772881523464718237280500144859035812007682196294087), SC_(0.999999999999999999999999999999999999999999999999994842586506159479264678025071506182017379789368213) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.1719645439379746676422655582427978515625e-6), SC_(14.99669319731847902681516901432820497411594146304800437538380922933153677323336904126149912001708466), SC_(0.0002578925163746625551575993078008476785681224051462033705263730458097938280913594746895087755902741312), SC_(58135.94699503091176460657656108692274293661971223570330985275344143300339644004833247949176315386748), SC_(0.9997421074836253374448424006921991523214318775948537966294736269541902061719086405253082653069983582) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.85982273958506993949413299560546875e-5), SC_(11.0855947401242460358028130769947720703971405472239617885567410624616105500881617874679656184668242), SC_(0.0001906348209851726835515900888048454979817969614369117035420426388904830987287387166029562530382486766), SC_(58139.85809348810599759758891702425617584033851315152735243958050959987332266319353973328529665541774), SC_(0.9998093651790148273164484099111951545020182030385630882964579573611095169012712612833953952683876202) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.1547680949443019926548004150390625e-4), SC_(10.49792985626979618498343837040865603489875493195003895029183893179584539788755762879245379872454632), SC_(0.0001805289680689213239964193315133342527700934346776491379903331398469127758468745331930792183429475664), SC_(58140.44575837196044744840829173084229187583689876680127527784541173053908781539414389196080847516002), SC_(0.9998194710319310786760035806684866657472299065653223508620096668601530872241531254668053590665666157) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.17196454791701398789882659912109375e-4), SC_(10.39259104243131584787684932172789160220998254074606161008377922421908251753583638818731650795845545), SC_(0.0001787174959386796170171417214660036462509920156648633276951343784698577165443165555401638674670448533), SC_(58140.55109718579892778551488077952305630852567115800525261805347143811585069574586513256594576592611), SC_(0.9998212825040613203829828582785339963537490079843351366723048656215301422834556834444582899697797568) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.189161000889725983142852783203125e-4), SC_(10.29730049288262983915572894419899582622032686300292319384286203571641340667613238799666075647570598), SC_(0.0001770788200461682436542865143285542655243668892838192491637975251267220026923230344308867743589514937), SC_(58140.64638773534761379423600115705195208451532683574839103429438862661851980660556913275660151740886), SC_(0.9998229211799538317563457134856714457344756331107161807508362024748732779973076769655675811316884015) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.3439290958340279757976531982421875e-4), SC_(9.699587680807103601261622470650203003996266491733915126728166383320062295122274381742032062262985566), SC_(0.0001668001766714344289542290154568729225088539118597567100029557551304502067213839272724209870582841905), SC_(58141.24410054742314003213010763060074490673938720701739910140908427901487091815942713901123021162158), SC_(0.9998331998233285655710457709845431270774911460881402432899970442448695497932786160727261351659598326) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(100), SC_(0.3683890108172782336916850566214648572490832360795647799218485822274949449073067860649358834823228436e-45), SC_(0.6335047850510686697307408415657771107469595030823606800328451826042509413873890781797682010954556142e-50), SC_(58150.94368822823024363339173010125094791073565369838292521731997242864324815666023716275797032750635), SC_(0.9999999999999999999999999999999999999999999999999936649521494893133026925915843422288925304049691764) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.6008507398291840218007564544677734375e-6), SC_(13.74160058590621974033625312730012610410136537881295930824709044545026889620745748440375184515969386), SC_(0.0008256937528942705699607849998658442771868595790970147844407880786142834291538660487838749299250098172), SC_(16628.74907799601202594084165196443464948382177535210832602381574808990587957874779370504510783318879), SC_(0.9991743062471057294300392150001341557228131404209029852155592119213857165708461339512089946743206323) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.300425381283275783061981201171875e-4), SC_(9.832513238723005633097631837924955082193825264175287541690476668759603163349480283667417317916510588), SC_(0.0005908077960576523146351736035109017568698260732630412794481689840933306317500101458272154249803039506), SC_(16632.65816534319524004808027325380982050572931546674599779037236186659654531160577090578144236043197), SC_(0.999409192203942347685364826396489098243130173926736958720551831015906669368249989854167671121737354) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.540765686309896409511566162109375e-4), SC_(9.245107859044843211173818163972984215461691665379384177706413383467141179757266030996728587384159573), SC_(0.0005555122750312157622728934347320953145866629704717469787356004622299329217492690713533177013194531898), SC_(16633.24557072287340247000408692776179137246144906554190115435642515188900729519798515845213109096432), SC_(0.9994444877249687842377271065652679046854133370295282530212643995377700670782507309286418719245451614) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.60085076256655156612396240234375e-4), SC_(9.139815195325465702058514116998788563501807142701475440765267106771579289880354623906060301361921934), SC_(0.0005491855379007642438464238237169830346760645732453909708238330810904250465776863793357928139140845955), SC_(16633.35086338659277997911939097473598702442133358821980989129757142858456918507489656554279937698656), SC_(0.9994508144620992357561535761762830169653239354267546090291761669189095749534223136206594511390163093) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.660935838823206722736358642578125e-4), SC_(9.044566393625459415121859073459850158828436398432103153348140456124938928569654963060372528875497449), SC_(0.0005434623079143664209121383555396154554432696531687514968083873931753596021393389520867990065129290215), SC_(16633.44611218829278626605604601827492542909470433248918217871469807923120954638559622638848714947299), SC_(0.9994565376920856335790878616444603845445567303468312485031916126068246403978606610479084940912271084) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.00012017015251331031322479248046875), SC_(8.447118325642176779371141162360900327601474944636635193409056350052051339196526154640029285169099398), SC_(0.0005075633502690321533981228019510321159233334164265252246066292012368729961569458832773514890373635888), SC_(16634.04356025627606890180676392937387526032166578628465013865378218530409713575872503480883039317939), SC_(0.9994924366497309678466018771980489678840766665835734747753933707987631270038430541167182498695001737) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(100), SC_(0.3684619332693842740366397112563557679129773136014184841391168077019097073523515211979175459196833086e-45), SC_(0.221398311337843792387906651823397378558814310863986769724390019581641709025448504005509468793646639e-49), SC_(16642.49067858191824568117790509173477558792314073055282339879345426131950876369889556444397301350545), SC_(0.9999999999999999999999999999999999999999999999999778601688662156207612093348176602621441185689136013) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.1167831896964344196021556854248046875e-5), SC_(13.0723722013825449744898100710193462792359716907703252698597158252004788687927453810442498996448669), SC_(0.001526736277332467809695602437123220235263581107362260605721933446410778907540799054028524584634579557), SC_(8549.226431769367830517097646440596109822685037794675407325303178003370324075052683729709571259703343), SC_(0.9984732637226675321903043975628767797647364188926377393942780665535892210924592009459582847131158751) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.583915971219539642333984375e-4), SC_(9.165749854253180926409802205477689189204018839063786945225902234841021037759656339096568352787215729), SC_(0.001070477691108208140608981919686359311648580961364237183752566991085173562551927909006291655595040755), SC_(8553.133054116497194565177654306137766912716990646381945649936991593729781906085772771657252806560994), SC_(0.9989295223088917918593910180803136406883514190386357628162474330089148264374480720909844363536076973) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.0001051048748195171356201171875), SC_(8.578658478262451685615326332573925102449459095256783298304689641438356262261613546923759105099506562), SC_(0.001001910663790910279977445274614486871801867310549409211969606741492792215683564431003801905795198654), SC_(8553.720145492487923805972130179041530999471550390188949296858204187132446681583815563830062054248703), SC_(0.9989980893362090897200225547253855131281981326894505907880303932585072077843164355689875150115471557) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.000116783194243907928466796875), SC_(8.473421634611367997218891715600607210314226082228594954553317127160311652789916356205949154787229542), SC_(0.0009896199406965141471241631575803399976897707371128530024174505270783175141644578049364631228025379822), SC_(8553.82538233613900749436856479601484889160678340321713764060957670141049129105551275454787200456098), SC_(0.9990103800593034858528758368424196600023102292628871469975825494729216824858355421950549593570405584) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.0001284615136682987213134765625), SC_(8.3782233269478559990432172622259390592758960016299563191319285312489835544646004154868362947800528), SC_(0.0009785016289156447435129559980555660843558508977079827560413401591820682591048119667241341447079291968), SC_(8553.920580643802519492544239249389517042645113483815776276030965297321819389380828695266984864568157), SC_(0.999021498371084355256487044001944433915644149102292017243958659840817931740895188033267383828035512) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.00023356638848781585693359375), SC_(7.781095695005977892942787662267736085116650989029568955515214759815343271383915268781534958881021346), SC_(0.0009087624565727032356397173210058719962540604705711151881320363859761981242119678619361453332751609037), SC_(8554.517708275744397598644668849347720016804358496416163639647679068755459672461513841972286200467188), SC_(0.9990912375434272967643602826789941280037459395294288848118679636140238018757880321380559716149212019) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(100), SC_(0.3685583578191641738102885449268264348666032848345216446320717264577480665695232465450804608746700508e-45), SC_(0.4304432328947056962621323115107149816375975950216664061390675433944389059467304308819915958797644574e-49), SC_(8562.298803970750375491587456511615456101921009485077174237343729654760514398918602749427713618803923), SC_(0.9999999999999999999999999999999999999999999999999569556767105294303737867688489285018362402404978334) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.14905200487191905267536640167236328125e-5), SC_(12.82591299746853564780110293902388174831655823815863925015513487528138181275844026445097264307240789), SC_(0.001911892535376961605983536062691480293914244401543544143477023382264412065499890086163749263164473714), SC_(6695.664632439852437033167401705228498509464571792463308993994675330823833233030981151177831147347796), SC_(0.9980881074646230383940164639373085197060857555984564558565229766177355879345001099138197285204982504) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.745260040275752544403076171875e-4), SC_(8.92063961729477488038309863232250613118874207958871869969383909765235132049465342609921076122509333), SC_(0.001329753624436724272362880267554856885879507745235091597946684888456099795023059019598671447543247654), SC_(6699.569905820026197800585406011929874126592387951033229544455971108452863725294767989529593029195111), SC_(0.9986702463755632757276371197324451431141204922547649084020533151115439002049769409803898068354501711) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.00013414680142886936664581298828125), SC_(8.3337189144549510455177521460598951321921957899653410630788260012547864560952328857614541672987351), SC_(0.001242264389881715600481292828695385168054450509254023087812967207616643457676123648814990083256489705), SC_(6700.156826522866021635450752498192485125588934240656607181070984204850428589694188529867349623121469), SC_(0.9987577356101182843995187071713046148319455494907459769121870327923833565423238763511742397211532327) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.000149052008055150508880615234375), SC_(8.228512348380456936136461223589742428679018610277749064505318060775217626194556265242838588467072322), SC_(0.001226581791037472050906377105104480090337804907220777113643310236584122671925661721709200437517198241), SC_(6700.262033088940515744832043420662637829102111420344199179644492145329997419594865150385965201953132), SC_(0.9987734182089625279490936228948955199096621950927792228863566897634158773280743382782801640784253738) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.00016395721468143165111541748046875), SC_(8.13334143308931556881479551947183001929658259457265424498945050928880024099500889443920832114991824), SC_(0.001212395154767130962760914267280408171755982125560476182798894925488893725331738066083379555809061714), SC_(6700.357204004231657112153709124780550238484547436049293999160359696816414804794412521189595469270286), SC_(0.9987876048452328690372390857327195918282440178744395238172011050745111062746682619339061068215377929) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.00029810401611030101776123046875), SC_(7.536387988654402915813414189164240021039561217650163168049429265432893840755490975832852636611563383), SC_(0.001123410391295872653089055777548919613971431092152241499195370394003992076729423439392761956208297706), SC_(6700.95415744866656976515509045508814023674156881297178507610038094067232120503393043979595115380864), SC_(0.9988765896087041273469109442224510803860285689078477585008046296059960079232705765605974887889583636) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(100), SC_(0.3686132475540991527791898043272195985514249652803170791010463586754863934818284125077493762437758491e-45), SC_(0.5494727093337053496710913137576219364357407661067643588527523279820194877649056864192383335403874864e-49), SC_(6708.490545437320972680968504644252380257781130030253334996595711053326025241462201874703127000145633), SC_(0.9999999999999999999999999999999999999999999999999450527290666294650328908686242378063564259233893236) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.39852520785643719136714935302734375e-5), SC_(11.82534165286607861284016769509361004518294908318135101712795122901946412642735323788024248212876687), SC_(0.004713780377457679352754002329823002072784290627147123193223268683119837404219601810061188267815974851), SC_(2496.849375017734120681094229641806145312755020869613516311155949460665435827634872677060984845276173), SC_(0.9952862196225423206472459976701769979272157093728528768067767313168801625957803981898980165379870503) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.00019926260574720799922943115234375), SC_(7.929812627478122406660341211111822337131184007547313038469023759514452459983191955701682556591959385), SC_(0.003160956888823837489122898688646882279549658778907627703745334068363254610215450042677662195629649791), SC_(2500.744904043122076887274056125787933020806785945247554289814876930170447494079033959239544770812981), SC_(0.9968390431111761625108771013113531177204503412210923722962546659316367453897845499572948941151671463) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.000358672696165740489959716796875), SC_(7.34410881241020574238958926442583214740343491562664173285216266962784416146682424379465797129069188), SC_(0.002927485482118213924172628917447962850896548713128960074590118601215267929980173386835526831989028036), SC_(2501.330607858189993551544808072473923210534535037168225595431738020057055792595401671146569356114248), SC_(0.9970725145178817860758273710825520371491034512868710399254098813987847320700198266131390369153743512) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.0003985252114944159984588623046875), SC_(7.239118403480033821563601840293710511746459940926763489256499924585445043085863997188056523312207318), SC_(0.002885634536584107194486046522975616601739423417237144172322524987519690841104229473232686216140080694), SC_(2501.435598267120165472370795496606044846191510011868103839027400765099454910976361917753170804092733), SC_(0.9971143654634158928055139534770243833982605765827628558276774750124803091588957705267422373745103062) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.0004383777268230915069580078125), SC_(7.144143015013571403969513236431739620833436615553467894701051331470534067868827633079037374020859175), SC_(0.002847775746907098186160050696011596070720694057886760815244156823319827619119980079296297558945183091), SC_(2501.530573655586627889964884100468015737104533337241399433582849358214365886193398281862189953384081), SC_(0.997152224253092901813839949303988403929279305942113239184755843176680172380880019920678951549591255) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.000797050422988831996917724609375), SC_(6.548431941579626590096309850874953360834389096936048320349744133280280687230312968061949222223000232), SC_(0.002610315278447263086359249361497287320377469666963091227205296128546697951443408056256761969182627094), SC_(2502.12628472902057270383808748602480199710358085585881900793415655640461926683191294687927810518194), SC_(0.9973896847215527369136407506385027126796225303330369087727947038714533020485565919437205288747175992) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(100), SC_(0.369037881200369694291732341218443782419461060966120489770537804029279942322658075462328388114400921e-45), SC_(0.1471047157879998510604919985587903650436826333234689456068351855902051506097277723167553993658512991e-48), SC_(2508.67471667060019929393439733689975535793796995242582944708353099539316761284378215409254749657258), SC_(0.9999999999999999999999999999999999999999999999998528952842120001489395080014412096349563173666765311) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.63875340856611728668212890625e-5), SC_(11.33900744119970074154938058757495806266712693522488946278408447204030265191463930183154316299193179), SC_(0.007245498134783457873763633175853087093182466309113106071535298453471078304367228977173631314813688396), SC_(1553.633783975933591682506820225378510916043075383315698460597005482261326677785092660636323807320736), SC_(0.992754501865216542126236366824146912906817533690886893928464701546528921695632771022763587061785862) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.000319376704283058643341064453125), SC_(7.452215932648408787122305750038079639161187565070604238440976491942121256760535147549706194063144187), SC_(0.004761882106525434937029618145105976223121874387923607690605731984066139837400203035300951085748853616), SC_(1557.520575484484883636933895062915389339549014753469983684940113462359508072939196814918160776249524), SC_(0.9952381178934745650629703818548940237768781256120763923093942680159338601625997969646576419064162296) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.000574878067709505558013916015625), SC_(6.867587963770300474981909290374802856251529829263364846236198065191668678548248203491919863670523861), SC_(0.004388311414380232305597584145250441546231315049827691163830841789050650860426759745835867266437627494), SC_(1558.105203453362991949074291522578666122458672489277223077144891889109960651151483758975947106642144), SC_(0.9956116885856197676944024158547495584537686849501723088361691582109493491395732402541259407677630615) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.00063875340856611728668212890625), SC_(6.762788423834918432298633441926342277122075359218380456582909518543396385211313757248095465488869595), SC_(0.004321345687876781288916411414922912587279792102939472551261831986855345208431327195583192233166517682), SC_(1558.210002993298373991757567371027126701588126959322207466798180435758232944488418205219771504823799), SC_(0.9956786543121232187110835885850770874127202078970605274487381680131446547915686728043791921246863752) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.000702628749422729015350341796875), SC_(6.667985693060746123028839467410531762349362614430057379130705432578838031571448663862082422639980508), SC_(0.004260767809913596138825870400992498500678885539113946756949297476950579901550678272725026564985441717), SC_(1558.304805724072546301027361345542937216360839704110530544250384521722791298128283298605784547672688), SC_(0.9957392321900864038611741295990075014993211144608860532430507025230494200984493217272378791411107008) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.0012775068171322345733642578125), SC_(6.073373332949844197435641829764176238961560470669251834902939457628333551317855309876682675839362196), SC_(0.003880817204144622179424763517390375783349194601184469336432621132901458462850631367079678328687376136), SC_(1558.899418084183448226620558983189292739748641847871336088478150496673295778381876652591184294473306), SC_(0.9961191827958553778205752364826096242166508053988155306635673788670985415371493686328864973265634669) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(100), SC_(0.3694472410323591250558914787939423659848299480013090809584703811951613621686811845631038825666292493e-45), SC_(0.2360726289035432642931835256208859435643703367345898079567704817267591466340569110451892593983580926e-48), SC_(1564.972791417133292424056200812953468978710202318171140682348730829245737850905789609952246256839724), SC_(0.9999999999999999999999999999999999999999999999997639273710964567357068164743791140564356296632654102) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.10718167686718516051769256591796875e-4), SC_(10.79753030490348580512959586666263753162166163888995228001371468647879516467928257205932258472971769), SC_(0.0115801252444873165343976168637232264497149877446461999994865252863961572630400084677037370875270495), SC_(921.621599621486328129410120868570456659090866283142017172949218577636418177047752320923134991289961), SC_(0.9884198747555126834656023831362767735502850122553538000005134747136038427369599915321957193754861771) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.00053590838797390460968017578125), SC_(6.925604325237507242456803509902997408800829650619206779185877969897006810003486199793342183086458978), SC_(0.007427565676161375768740897346652563253993371624296786216034259614693445522217353889373281204089342181), SC_(925.4935256011523066920829132253300967819116982714127626737770552942182065317235486931891153929332197), SC_(0.9925724343238386242312591026533474367460066283757032137839657403853065544777826461105619734461801008) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.0009646351099945604801177978515625), SC_(6.342784984935700829992976879241734287565303087444222671111935506203703316966212883148935900791563806), SC_(0.006802504132917601577874216396132373031734379853351279792626734261568927207618936172705182172655394642), SC_(926.0763449414541131045467398559913599031472248345877467818509977579115100247608220098335216752281149), SC_(0.9931974958670823984221257836038676269682656201466487202073732657384310727923810638272354609783215098) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.0010718167759478092193603515625), SC_(6.238306143511707249494326440714779793049143862986205228008813874816947545133284003139086942921297872), SC_(0.006690452762379717286790619756823062156410227396726664431656896575511097708499810427226870525102427047), SC_(926.1808237828781066850453902945183143976633840590457642249541193892982657965937508898433706330983808), SC_(0.9933095472376202827132093802431769378435897726032733355683431034244889022915001895727147385929795436) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.0011789985001087188720703125), SC_(6.143793459584995340518564587913168407023113056295507853231542431502654675215884452365672897753080281), SC_(0.00658908988715195008184126631354098977003838506810365917095700116412101523338301929853973262544869406), SC_(926.2753364668048185940211521473199257836894148657364615997313908326125586665111504406167846782665984), SC_(0.9934109101128480499181587336864590102299616149318963408290429988358789847666169807014027503168683122) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.002143633551895618438720703125), SC_(5.551028733614631441136079945563908235545435915614176767460896380550216784285428030962514558349729002), SC_(0.005953362125949581852682808924678013567301646657883961294154434209933452408736435231681831115962090178), SC_(926.8681011927751824934036367896691859551670920064177926855020368835649965574416068620199430176699497), SC_(0.9940466378740504181473171910753219864326983533421160387058455657900665475912635647682661322778848798) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(100), SC_(0.3701863482966125637807009834686369616110976989170770830279898842911922994633419877963486551793694475e-45), SC_(0.3970171100263001544390324287018903201561376017683191023028076445923793733971044582745929822837954262e-48), SC_(932.4191299263898139345397167352330941907125279216617831046663207003345123582583979394101800761413619), SC_(0.9999999999999999999999999999999999999999999999996029828899736998455609675712981096798438623982316809) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.30219152904464863240718841552734375e-4), SC_(9.670884523427657957178827825207640912463524823689696089247963977392906817722815715315768932319175677), SC_(0.02927539433052311514314216255008856965429587773324587314292120345867458704448957878192524315602858739), SC_(320.6708493655194561420245316058817520065052804372223350980607664213471368056830316577456339997583557), SC_(0.970724605669476884856857837449911430345704122266754126857078796541325412955510421217818433559045076) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.001510957605205476284027099609375), SC_(5.858928105222976109133588154704940451689511531300336420106738180152772524944561558751766720038131745), SC_(0.01773596098878807048086285734381247131070843457470518036825401251096938206489388550259649817325956596), SC_(324.4828057837241379900697712763844524672792937296116947672019922185872710984612858143096362120393996), SC_(0.9822640390112119295191371426561875286892915654252948196317459874890306179351061144972474139238437218) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.002719723619520664215087890625), SC_(5.283238685655406106020684922572791795541801156757024358477546251764271058409234063307784776411764904), SC_(0.01599325227078787122196055059176023367066905038451960746992431571969384434194896690688188812841831683), SC_(325.0584952032917079931826745085166011234270041041550068288311841469757725649966133097536181556657664), SC_(0.9840067477292121287780394494082397663293309496154803925300756842803061556580510330929771617201621888) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.00302191521041095256805419921875), SC_(5.180022250992443098456572963282556906941511350140492757862696040032919389731579399244015058727596809), SC_(0.01568079875954710903689181324959728123587836662354167121109134448456551526408297367485485997505175671), SC_(325.1617116379546710007467864678068360120272939107715384294460343587071242336742679738173878733499345), SC_(0.9843192012404528909631081867504027187641216333764583287889086555154344847359170263250069039493536374) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.0033241068013012409210205078125), SC_(5.08665155954614832816695020562558519856732388819313760834233943952276587339279488248698220462329858), SC_(0.01539814996931679640512162380521019618516324742657983782779919071422804833579404817772218506732349783), SC_(325.2550823294009657710364092254638077204014813727188935789663909592172777500130524905744207274542328), SC_(0.9846018500306832035948783761947898038148367525734201621722008092857719516642059518221420340391198634) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.0060438304208219051361083984375), SC_(4.501174235431703607743793915757073362030162525535349963178890780962259995120753938138193741532333018), SC_(0.01362581161768948428002382983633363229931422314729661959844291873166388034825127448149335275571310275), SC_(325.8405596535154104914595655153323195569386427353766812241298396177777836282850934349232091905451983), SC_(0.9863741883823105157199761701636663677006857768527033804015570812683361196517487255183862614751267574) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(100), SC_(0.3735329358894014290597755983828277403109000009585095691185899796962630068955920695468847481341579698e-45), SC_(0.1130747034266563940839653378009513670204434622477854366552695647743251468644841772118695732365306121e-47), SC_(330.3417338889471140992033594310893929189688052605384982514193289696802680250230196356206315849448808), SC_(0.9999999999999999999999999999999999999999999999988692529657334360591603466219904863297955653775221456) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.499413363286294043064117431640625e-4), SC_(9.09143174186392218206792714789936156812904780177882655511645754144008392955147525520112582681862457), SC_(0.0455339659818498517717554159843204991325968723648847552163487246073129995344092074225748777688535861), SC_(190.5712057162443534637401226274029819634962592814549820787079322695971581532795795007449751245225544), SC_(0.9544660340181501482282445840156795008674031276351152447836512753926870004655907925770231834121139608) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.002497066743671894073486328125), SC_(5.333963711356164951856899934737899395234655036721267980759368209113746040033645118790511921612526542), SC_(0.02671488155852542720348233893967370255631947969822798173340480476036001826163187326127585870850951479), SC_(194.3286737467521106939511498405644441363906520465125406530650216019234960427974096371555890297286524), SC_(0.9732851184414745727965176610603262974436805203017720182665951952396399817383681267384869280297806661) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.004494720138609409332275390625), SC_(4.764608103543422396273460767824913797680918211220254147530766736990032763475791527601286078974636713), SC_(0.02386329342435485410528915621892655527894975521180483827248315548180341266576066691682837163027671281), SC_(194.8980293545648532495345890074774297339443888720135544862936230740472093193552632283448148723665423), SC_(0.9761367065756451458947108437810734447210502447881951617275168445181965873342393330829593753788794447) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.00499413348734378814697265625), SC_(4.662511603034318364168528096863620509671749270448326278452821039711349440063013476125319687531537714), SC_(0.02335194837848704542317501479979960785677943859199818879547148696844760256087874240214563959245228623), SC_(195.0001258550739572816395216784387230219535578127854823553715687713258926427680412798207812638096413), SC_(0.9766480516215129545768249852002003921432205614080018112045285130315523974391212575976465832772595711) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.005493546836078166961669921875), SC_(4.570153968023475697973028726833585950462441863354771181689858907128424789689959379371679135045553744), SC_(0.02288937993710691762717340242447631479229364077362362993790510926817164659201098401309690294652813575), SC_(195.0924834900847999478350210484687575811628652198790374521345309039088172931410953765744218162956252), SC_(0.9771106200628930823728265975755236852077063592263763700620948907318283534079890159866993688366479582) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.0099882669746875762939453125), SC_(3.991154013512935049369200187919861138929383257565931837405545879976870092643426316924994579798069139), SC_(0.01998948859097551085592371345634047802657512403398820023558724073513120474144401325627472905378199928), SC_(195.6714834445953405964388495873824823926959238256678767964188439310603719901876284390211063715431098), SC_(0.9800105114090244891440762865436595219734248759660117997644127592648687952585559867435469258036936357) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(100), SC_(0.3769482555838579136592010864491944174085838190332996002822334124753414275598606857542089750306573573e-45), SC_(0.1887925855246434792730496837795316524181267413081017706657594232476888183287282829143324349246616454e-47), SC_(199.6626374581082756458080497753023435316253070828568603782405318973780409963818603402858604413590935), SC_(0.9999999999999999999999999999999999999999999999981120741447535652072695031622046834758187325869189823) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.92842339654453098773956298828125e-4), SC_(8.32766758281048418780735292973223209604337085137833520544395327107364742252310003489523494741898463), SC_(0.07772597516178416795338408655014516648855152950494450081309343933563117399553230793294010541061578969), SC_(98.81370395323916382835676107678233359685726732004611689093914473336659824016357222231446793635237771), SC_(0.9222740248382158320466159134498548335114484704950554991869065606643688260044676920663617631519646603) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.004642116837203502655029296875), SC_(4.677052055182783950361462479187826891351644382410773636499047275642185592328110193550925652380952967), SC_(0.04365309112744655672435066251454637088986352549279301888821675817858136467846696401925340767241710544), SC_(102.4643194808668640658026515273267388015489937890136784598840507287980600703585620636587772313904094), SC_(0.9563469088725534432756493374854536291101364745072069811117832418214186353215330359803517078474026215) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.008355810306966304779052734375), SC_(4.119868713825767954507639185022242702497989461348359320156153154746091619273779670866706133311348331), SC_(0.03845264116709168479462783327141273082956462734885718329377983165867922002567451544279706791885230281), SC_(103.021502822223880061656474821492322990402648710076092776226944849694154043412892586342996750460014), SC_(0.9615473588329083152053721667285872691704353726511428167062201683413207799743254845568543313445203168) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.00928423367440700531005859375), SC_(4.019921519306157572967927141052306454797972293850429574819892281139435411660594998072654171327963586), SC_(0.0375197877502770480302210199949516089940305508088718070103011894688949231653096730082703479188234313), SC_(103.1214500167434904431961868654622592381026658775740225215632057233008102510260772591370487124433988), SC_(0.9624802122497229519697789800050483910059694491911281929896988105311050768346903269913893536931239148) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.010212657041847705841064453125), SC_(3.929508072902123437757774897504080575693994395736268934160771242632819260911881416743229201902800358), SC_(0.03667591721634783750587383327156302243799217393479799690498142709119028246928578208069198371104557265), SC_(103.211863463147524578406339109010485117206643775688183162222326761807426401774790840466473681868562), SC_(0.9633240827836521624941261667284369775620078260652020030950185729088097175307142179189752283062863023) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.0185684673488140106201171875), SC_(3.362962876825342551025582987367579337130892353710432880232450815972945791421066869679704070831109699), SC_(0.03138808873371396968047089077038353233395064458846974896064565363933813332400386490393294692476573265), SC_(103.7784086592243054651385310191469863557697458177140192161506471884672998712656053875299988129402526), SC_(0.968611911266286030319529109229616467666049355411530251039354346360661866675996135095781326500580384) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(100), SC_(0.3844857168704707606007207826703247070525704986636359420305976050073019330636593149686501224985731785e-45), SC_(0.3588583115543780419206393147274009793743086058135421976561276361251404038603301301046849133096950379e-47), SC_(107.1413715360496480161641140065145656929006381710399663795126272438395248800163475511113681489592739), SC_(0.999999999999999999999999999999999999999999999996411416884456219580793606852725990206256913941864578) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.000241700225160457193851470947265625), SC_(6.989567342457767291165813682115083248727717058265847893227551241610436479959394934663352244835979721), SC_(0.1712300864900691830809638583306832029813253539450049252077231783514842512094658469882268373944706235), SC_(33.83017109096958859719977396603901368488700926845493356384309385747826733839150788430927781670596628), SC_(0.8287699135099308169190361416693167970186746460549950747922768216485157487905341530101415161086734135) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.01208501122891902923583984375), SC_(3.645052082619493510754250102657795647363402619166810163394885759470165706667119548268590046156765514), SC_(0.08929631160092280070447033991155493817323429700259338574714854113985110677424714195589810307485385417), SC_(37.17468635080786237761133754549630128625132370755397129367575933961853811168378327070404001538518049), SC_(0.9107036883990771992955296600884450618267657029974066142528514588601488932257528580432426069697986838) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.021753020584583282470703125), SC_(3.121681115364872992249370429142630243919758769039445295540102139950204724424648880240696291300224489), SC_(0.07647479467454212823112470840782652796143400926368964944287913565960182578074431119624266771320275773), SC_(37.69805731806248289611621721901146668969496755768133616153054295913849909392625393873193377024172151), SC_(0.9235252053254578717688752915921734720385659907363103505571208643403981742192556888030189055833083723) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.0241700224578380584716796875), SC_(3.027690225756868892212711633036930400330173071117682435181204227694799527195760005172705581038071537), SC_(0.07417221035589703876248814311106669867021141835493692191966636116530191427281757861109726798229924587), SC_(37.79204820767048699615287601511716653328455325560309902188944087139390429115514281379992448050387446), SC_(0.925827789644102961237511856888933301329788581645063078080333638834698085727182421388186010844846675) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.02658702433109283447265625), SC_(2.942664605341138937082562074383595860306832724172044272497882818529802086726566077422282020376315413), SC_(0.07208925677317387450963942331401971774864863598173722366608932259553293193482061295798446137870319249), SC_(37.87707382808621695128302557377050107330789360254873718457276228055890173162433674155034804116563059), SC_(0.9279107432268261254903605766859802822513513640182627763339106774044670680651793870413184526090032108) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.048340044915676116943359375), SC_(2.41074817473566482145221784161961838217114178626157130000716892699054591244755314591797108724580003), SC_(0.05905839349429781950594739017608665222518690248510542891560361255106979598651410633025419940717016623), SC_(38.40899025869169106691336980653447855144358454045921015706347617209815790590334967305465897429614597), SC_(0.940941606505702180494052609823913347774813097514894571084396387448930204013485893669171551255748135) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(100), SC_(0.4118273612568114120065807345413501643158568873446145015743819726283523844643802566458722417876724156e-45), SC_(0.1008892700105018944978675108213807722934186311209931576611431317504181560003000532484582926238701235e-46), SC_(40.81973843342735588836558764815409693361472632630895409581383368708212308380955265504227989096454242), SC_(0.9999999999999999999999999999999999999999999999899110729989498105502132489178619227706581368879006842) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.0006227754056453704833984375), SC_(5.398853673219018710862483990962030873762547549939303465609769883203068434312148164896365027156798183), SC_(0.3474560013087092846111301271350181153322167628923569217302635472598482984210909987319052934013456492), SC_(10.13938326292248918091803717140500686234141136932799736792065339615436856422024698064523810115224422), SC_(0.6525439986912907153888698728649818846677832371076430782697364527401517015789090012642543091559873733) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.031138770282268524169921875), SC_(2.624621777840601468672742465553647526902424779628133001278346272637876820856672407823865884146425678), SC_(0.1689137441157049196929670663951454244447909282434660775658465961050462673597111095768335096934485378), SC_(12.91361515830090642310777869681339020920153413963916783225207700671956017767572273771773724416261673), SC_(0.8310862558842950803070329336048545755552090717565339224341534038949537326402888904212728334573946703) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.056049786508083343505859375), SC_(2.162313294165328988202510718803524978627655348865636422277632922509021076722403194443007421877550004), SC_(0.1391607878713606352032987274631824194122117693300193732474663311578257858007756912177290988729444308), SC_(13.3759236419761789035780104435635127574763035704016644112527903568484159218099919510985957064314924), SC_(0.8608392121286393647967012725368175805877882306699806267525336688421742141992243087807016564848934745) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.06227754056453704833984375), SC_(2.079041815599814320147626715140559656723511682076184551416263895975773589837334878234708586848491379), SC_(0.1338016548559650776876410841887370321781490089503796887164231224142746680182809514557714062729304056), SC_(13.45919512054169357163289444722647807938044723719111628211415938338166340869506026730689454146055102), SC_(0.8661983451440349223123589158112629678218509910496203112835768775857253319817190485427177825445887742) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.068505294620990753173828125), SC_(2.003712420009585882584341039453708853317621415374573048462234158676614018214682470062007753415859851), SC_(0.1289536533806487659647983473729504724818872072493062222239213561417858309354665544217620992042013603), SC_(13.53452451613192200919618012291332888278633750389272778506818912068082298031771267547959537489318255), SC_(0.8710463466193512340352016526270495275181127927506937777760786438582141690645334455767799499356738501) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.1245550811290740966796875), SC_(1.53441423129112475737524518331096500840725759515087388767695993717246997306190379676601324775586921), SC_(0.09875085813127999347876403213381417164850985029241959548600682134325557222950784960495023341689149482), SC_(14.00382270485038313440527597905607272769670132411642694585346334218496702547049134877558988055317319), SC_(0.9012491418687200065212359678661858283514901497075804045139931786567444277704921503939211327623995619) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(100), SC_(0.491012558925029502038958259186637674187082070198644614704728540139757730717007602661319035304115905e-45), SC_(0.3160027491812458572459559308108164731267571181137289219138336973784283559240105100161042789885729545e-46), SC_(15.53823693614150789178052116236703773610395891877628827460539377731847873934575747152474911809627915), SC_(0.9999999999999999999999999999999999999999999999683997250818754142754044069189183526873242881886271078) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.001223441795445978641510009765625), SC_(4.107633028355164744805499178379042539887472133455579773171056895053209516655909782745786364362480172), SC_(0.5330801041122809893124112359299492773161319212862964349749276702570415880581830814691555528860698043), SC_(3.597837494119984489847548621434082521137867680861747675331544830881957821265703839306715563836387709), SC_(0.4669198958877190106875887640700507226838680787137035650250723297429584119418169185234395265537106464) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.061172090470790863037109375), SC_(1.936485981850182971451375681345119726702234863196777116823460031031266400004195740881376398203023874), SC_(0.2513131386593307540991640684543589236443925141145175751221147698677769739319418090600471325094999253), SC_(5.768984540624966263201672118468005334323104951120550331679141694903900937917417881171125529995844007), SC_(0.7486868613406692459008359315456410763556074858854824248778852301322230260680581909363951205060113066) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.11010976135730743408203125), SC_(1.53816896265897443986409464099250739729409691824235216567496380983889196492551187328576895409782409), SC_(0.1996203811529064426596921912381727440618982217331183744501991772754181001205835601426286413225377901), SC_(6.167301559816174794788953158820617663731242896074975282827637916096275372996101748766732974101043791), SC_(0.8003796188470935573403078087618272559381017782668816255498008227245818998794164398545194112902246047) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.12234418094158172607421875), SC_(1.466088111094671282794200828064019673740085117198127869023649937447605151191232298855822127351016404), SC_(0.1902658775759919254783410584245027757110291178093905520960858364206883179566070806285394901876464333), SC_(6.239382411380477951858846971749105387285254697119199579478951788487562186730381323196679800847851477), SC_(0.8097341224240080745216589415754972242889708821906094479039141635793116820433929193687362864076535596) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.13457860052585601806640625), SC_(1.400881043051031737065670764700271767545156491544346318989223397553252185517998812020194463448278763), SC_(0.1818034393830944269473777475699449060079741042819292252135731778565926538411797911185361027107102345), SC_(6.304589479424117497587377035112853293480183322772981129513378328381915152403614810032307464750589118), SC_(0.8181965606169055730526222524300550939920258957180707747864268221434073461588202088788552178361301191) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.2446883618831634521484375), SC_(0.99729395709067241735766067751443046709332587714511939610752695882967697915408677511463530479783466), SC_(0.1294267435300397349603572970957870869630942140868148552925934774957263859825167016525201561153885356), SC_(6.708176565384476817295387122298694593932013937172208052395074767105490358767526846937866623401033221), SC_(0.870573256469960265039642702904212913036905785913185144707406522504273614017483298345586302346735954) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(100), SC_(0.6478611415197960360753281775792439832263535501609430361693974315110165286653233546268382397444183374e-45), SC_(0.840780766898178008869243443837877352348032400258965863581678185676534322639265269047427246718208775e-46), SC_(7.705470522475149234653047799813125061025339813669466306982805689859839160342369638932330721638712915), SC_(0.9999999999999999999999999999999999999999999999159219233101821991130756556162122647651967599741034136) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.002495576627552509307861328125), SC_(2.734855898436444538960197568353345302797643920782849867350472698862801247231931660276599701395230536), SC_(0.7529056368605864071477954107757553871130981376578315260167339297055082424891270839650389931798900742), SC_(0.8975460448403471907260352889952074418600755755686656141024711031215454179607615030145266344852466741), SC_(0.247094363139413592852204589224244612886901862342168473983266070294491757510872916018279343723885963) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.1247788369655609130859375), SC_(1.306037037931325273110975961858785853889497163910375544775166642973791438732260951219539444462276157), SC_(0.3595519048624747086399495819773797417369647630495458043003775292793755251130963726432952726923473251), SC_(2.326364905345466456575256895489766890768222332441139936677777159010555226460432212071586891418201053), SC_(0.6404480951375252913600504180226202582630352369504541956996224707206244748869036273485294401209486908) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.22460190951824188232421875), SC_(0.9885007575877314066316087571272734600340200679794221131391294101259479058115424831901932604404540439), SC_(0.272134189174010942792674792979994779607650072007003386385396071326733875426150437485572609245441222), SC_(2.643901185689060323054624100221279284623699428372093368313814391858398759381150680100933075440023166), SC_(0.727865810825989057207325207020005220392349927992996613614603928673266124573849562508142534216676462) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.249557673931121826171875), SC_(0.9304697144207498511786181051137991461677681312267180398489822962468753694437254969284556768438195259), SC_(0.2561582470637521534054660006356217865146657410166091897536349301024895988045117668110852797208631096), SC_(2.701932228856041878507614752234753598489951365124797441603961505737471295748967666362670659036657684), SC_(0.7438417529362478465945339993643782134853342589833908102463650698975104011954882331829753476099553385) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.2745134532451629638671875), SC_(0.8779709241956378784576011912540914136437534750787434695660536599649324901601121739182438383623023227), SC_(0.2417053338000419192707989657345748364586452241630348852579539371629114370069908716417725859412519299), SC_(2.754431019081153851228631666094461331013966021272772011886890142019414175032580989372882497518174888), SC_(0.7582946661999580807292010342654251635413547758369651147420460628370885629930091283526005893666361667) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.49911534786224365234375), SC_(0.5574820380397203326014285069632281249087055106561841394270302097686210563673830228776534924132712701), SC_(0.1534747659387098248433194606279114074359802765577343833076334934826433282648710371337205904567250712), SC_(3.07491990523707139708480435038532461974901398569533134202591359221572560882531014041347284346720594), SC_(0.8465252340612901751566805393720885925640197234422656166923665065173566717351289628625605936378764203) }}, 
      {{ SC_(0.249557673931121826171875), SC_(100), SC_(0.1165337414094056672186119633118372326386267415447466476909140907381699722823700492455473836872619049e-44), SC_(0.3208173082967809365334248788561654088276764416394031356193657910033720148158538043442309513458402166e-45), SC_(3.632401943276791729686232857348552744657719495186178067358887129798227032074320836984863090598461107), SC_(0.9999999999999999999999999999999999999999999996791826917032190634665751211438345911723235583605968644) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.0049122213385999202728271484375), SC_(1.654360476952788395565091483618429332080299510750906167043467749622058646861070307300335318412492263), SC_(0.9172475617092936111196120635221962448847409686540639143040750236326102528158054772151362150352426506), SC_(0.1492534502075985265254821470991394670727200544207034025295844784011311472281284530845095489966979154), SC_(0.08275243829070638888038793647780375511525903134593608569592497636738974718419452273806179935283266554) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.24561107158660888671875), SC_(0.8591102891364148659027227687752104865250632846967394109711640330263828509348316936924987093062755665), SC_(0.476327154164860371328269663275900029881429197034646391173478221112698601696158930860391522911504252), SC_(0.9445036380239720561878508619423583126279562804748701586018881949968069431543670666923461581029146122), SC_(0.5236728458351396286717303367240999701185708029653536088265217788873013983038410691144755392478034605) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.44209992885589599609375), SC_(0.6151178843458194174576092293340509371826806145099227504262259297702119124452239873890995638580032157), SC_(0.3410474243311383959956637270830648167641642947404114286685244577963240267359788030092208093550646792), SC_(1.188496042814567504632964401383517861970338950661686819146826298252977881643974772995745303551186963), SC_(0.6589525756688616040043362729169351832358357052595885713314755422036759732640211969722945795273623916) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.4912221431732177734375), SC_(0.5696915887013141088174202631037187419431943497165285167734537828276643143969487860883316475196393758), SC_(0.3158611608185115269548389922894588565147765052878731444901294260986877976956018409426455682815368615), SC_(1.233922338459072813273153367613850057209825215455081052799598445195525479692249974296513219889550803), SC_(0.6841388391814884730451610077105411434852234947121268555098705739013122023043981590401076003404885869) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.54034435749053955078125), SC_(0.5285934290336277553075270335394255189292301783737569951938668837616709360843073189655358789025981993), SC_(0.2930745993217330165245425923025781279614684690077922116097918659269501459755406822478769969035730411), SC_(1.275020498126759166783046597178143280223789386797852574379185344261518858004891441419308988506591979), SC_(0.7069254006782669834754574076974218720385315309922077883902081340730498540244593177359960180244233096) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.982444286346435546875), SC_(0.2840949896471148762646748327771540499572296357001660825805477398020758104810139640515864061811464973), SC_(0.1575143024618325882485702491499773354535427586337804671901697458836454362130580896667998615293610026), SC_(1.519518937513272045825898797940414749195789929471443486992504488221113983608184796333258461228043681), SC_(0.8424856975381674117514297508500226645464572413662195328098302541163545637869419103237352685973826595) }}, 
      {{ SC_(0.4912221431732177734375), SC_(100), SC_(0.3554786780644470172552623900210476078762607526788722652651577627104786882801695535346500111600654028e-44), SC_(0.1970924446253934735193962102664889638137156599937937647683125163235828436518801020510525753999891377e-44), SC_(1.803613927160386922090573630717568799153019561616822788928582055470565893878722681713985119354332036), SC_(0.9999999999999999999999999999999999999999999980290755537460652648060378973351103618628434000620623523) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.00983847491443157196044921875), SC_(0.9988627703376965237021282483793283998958511662235079530457860091340880858661589398735141371653418962), SC_(0.9893791586391959313589247995867868787348704739765968058480672722518142355189894108676067042917022123), SC_(0.01072264655297708483400968644738690067844313845477925107578282358701250620425937737438075951870309101), SC_(0.01062084136080406864107520041321312126512952602340319415193272774818576448101058913239329570829778771) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.491923749446868896484375), SC_(0.6092841483114124309606554974477512970242795125141354196975395333574148201355701398796169799203828208), SC_(0.6034993553966824361696793594754562688154817234268946517170502520522596302645039728904190384003204218), SC_(0.4003012685792611775754824373789640035500147921641517844240292993636857719348481773682779167636621665), SC_(0.3965006446033175638303206405245437311845182765731053482829497479477403697354960271095809615996795782) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.88546276092529296875), SC_(0.4090488446933753077167583163878605357381346851487584297426423518534657760013638063743341546240144908), SC_(0.4051651676518526351128802614745574331465937506756696788008839074828702248424459073625363030514551146), SC_(0.6005365721972983008193796184388547648361596195295287743789264808676348160690545108735607420600304965), SC_(0.5948348323481473648871197385254425668534062493243303211991160925171297751575540926374636969485448854) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.98384749889373779296875), SC_(0.370352431136295781883241851603824005715411835471534212594866883768994404183305967159443941476563169), SC_(0.3668361536727710626418137759953048564646661886226762568753671876280942811281119959409899282486354536), SC_(0.6392329857543778266528960832228912948588824692067529915267019489521061878871123500884509552074818182), SC_(0.6331638463272289373581862240046951435353338113773237431246328123719057188718880040590100717513645464) }}, 
      {{ SC_(0.98384749889373779296875), SC_(1.0822322368621826171875), SC_(0.3353386097516048155638557121765199286100693157994542409937828613902311332455629133376101988149887739), SC_(0.3321547678297319321701307848633371126400118606682421587463162459345433014494656069902585162974731598), SC_(0.6742468071390687929722822226501953719642249888788329631277859713308694588248554039102846978690562133), SC_(0.6678452321702680678298692151366628873599881393317578412536837540654566985505343930097414837025268402) }}, 
      {{ SC_(0.98384749889373779296875), SC_(1.9676949977874755859375), SC_(0.1374456065246148925738161274489277202177338705969611840951631495244789172170178267868315457496175863), SC_(0.1361406417179841828721837185359700588250311762493488349478929164181504739415138270580364665878073599), SC_(0.8721398103660587159623218073777875803565604340813260200264056831966216748534004904610633509344274009), SC_(0.8638593582820158171278162814640299411749688237506511650521070835818495260584861729419635334121926401) }}, 
      {{ SC_(0.98384749889373779296875), SC_(100), SC_(0.3452847132913471123339782092778794628523602411114956589875948413226849655169889160387754015183450938e-43), SC_(0.3420064389942920918464788466469587061537101076570447060697029713782114356144525921674493801168521542e-43), SC_(1.009585416890673608536137934826715300574294270149815874986857599323279664282472032205022641488524436), SC_(0.999999999999999999999999999999999999999999965799356100570790815352115335304129384628989234295529393) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.011576130054891109466552734375), SC_(0.9256421169095858964029301012199937902219788931701720231034368949393485801630195398677134263886026542), SC_(0.994711272355762893770783882299118342770777920879617312700765732169002110231728502249141741960716454), SC_(0.004921497512314303093748497028932256375056038682779382028278912930555847281468235433106618722412350468), SC_(0.005288727644237106229216117700881657229222079120382687299234267830997889768271497750858258039283546044) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.57880651950836181640625), SC_(0.5898199377042372764725164622792169813101707344512639726836827769831046554014123519743007640856210835), SC_(0.6338308618166365458438457471248494940233093454055343682264493234958418241433155604354114804552093074), SC_(0.3407436767176629230241621359697090652868641974016874324480330308867997720430754233265192810253939211), SC_(0.3661691381833634541561542528751505059766906545944656317735506765041581758566844395645885195447906926) }}, 
      {{ SC_(1.1576130390167236328125), SC_(1.0418517589569091796875), SC_(0.3899068736873002418750206980191563744217320493025424515359275118372274765769144292842706093645450701), SC_(0.4190007729127949034485352250754240449758795081655081429524194713873364359023428994156614130045024835), SC_(0.5406567407345999576216579002297696721753028825504089535957882960326769508675733460165494357464699345), SC_(0.5809992270872050965514647749245759550241204918344918570475805286126635640976571005843385869954975165) }}, 
      {{ SC_(1.1576130390167236328125), SC_(1.1576130390167236328125), SC_(0.350767915499064649485116118680747323698244021478097988905881585794790293404432604891991000560468547), SC_(0.3769413611953594115041815918132996991722140466616286497556462452737080861937062742763079967763701127), SC_(0.5797956989228355500115624795681787228987909103748534162258342220751141340400551704088290445505464577), SC_(0.6230586388046405884958184081867003008277859533383713502443537547262919138062937257236920032236298873) }}, 
      {{ SC_(1.1576130390167236328125), SC_(1.2733743190765380859375), SC_(0.3153521200099001873943766180507653607009584099715487823224479529882689797923352470224098694307293263), SC_(0.3388829254900626423204433612535434055758034744381629523496573224770360495563296638079271945520351657), SC_(0.6152114944120000121023019801981606858960765218814026228092678548816354476521525282784101756802856783), SC_(0.6611170745099373576795566387464565944241965255618370476503426775229639504436703361920728054479648343) }}, 
      {{ SC_(1.1576130390167236328125), SC_(2.315226078033447265625), SC_(0.1186902112825402522994923149641941909087538887549201440624759116624595999596336065139636354107987151), SC_(0.1275465851480502036698050289887457969069182012601624005433841921900918431336574265313409489417907447), SC_(0.8118734031393599471971862832847318556882810430980312610692398962074448274848541687727822253074644156), SC_(0.8724534148519497963301949710112542030930817987398375994566158078099081568663425734686590510582092553) }}, 
      {{ SC_(1.1576130390167236328125), SC_(115.7613067626953125), SC_(0.1125471317451553626979291490952714679039247813920695733726819688247553286279469203175901885989118597e-49), SC_(0.1209451240096827928951168363517962662830507405737678256582015888878404748097196285315499859596572706e-49), SC_(0.9305636144219001994966785982489260465970349318529401504185412923336346345295782481540296526328757977), SC_(0.9999999999999999999999999999999999999999999999999879054875990317207104883163648203733716949259426232) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.0345167778432369232177734375), SC_(3.152051752007051901166677804203242451762158932058734082278419046998808021620902707379856486480431286), SC_(0.9999991955246725226796507081898210659844067334505908025827252502575654996195689165971232425140116816), SC_(0.2535749905369569950519775399176363360986595319689620087450384044106920459237659816391116922493578419e-5), SC_(0.8044753274773203492918101789340155932665494091974172747497424345003804310834028767574859883184061715e-6) }}, 
      {{ SC_(3.451677799224853515625), SC_(1.7258388996124267578125), SC_(2.625317365863687824812627271478283212231574859428744298986298851145912049982847565646684436084768396), SC_(0.8328909105597599735546579291952392864992718070378324576497708372302859905131261368260237112268348005), SC_(0.526736921893269445924001052500358415893945059225309472912207646236940078558514379392988441512585384), SC_(0.1671090894402400264453420708047607135007281929621675423502291627697140094868738631739762887731651995) }}, 
      {{ SC_(3.451677799224853515625), SC_(3.1065099239349365234375), SC_(1.589096467859943405010524166882944076166569421609944233676376552350973263160710964065506274491283582), SC_(0.5041462877185294515224518878604444421797451280508405361038884763922328387930556371432063861495038906), SC_(1.562957819897013865726104157095697551958950497044109538222129945031878865380650980974166603106070198), SC_(0.4958537122814705484775481121395555578202548719491594638961115236077671612069443628567936138504961094) }}, 
      {{ SC_(3.451677799224853515625), SC_(3.451677799224853515625), SC_(1.350290495171821953838340461553337413581637247730634253229478654476521826150332482913374175912005858), SC_(0.4283842763801844892410352502765636860105928311306069364749108915416602584803704173813954261741978146), SC_(1.801763792585135316898287862425304214543882670923419518669027842906330302391029462126298701685347922), SC_(0.5716157236198155107589647497234363139894071688693930635250891084583397415196295826186045738258021854) }}, 
      {{ SC_(3.451677799224853515625), SC_(3.7968456745147705078125), SC_(1.134077301013503806882153483536082811051446330041171509406405665769753434166535549993226681832102034), SC_(0.3597899012775341280702093141512305124768832773509499020760489759930518624437955917851941007256656217), SC_(2.017976986743453463854474840442558817074073588612882262492100831613098694374826395046446195765251746), SC_(0.6402100987224658719297906858487694875231167226490500979239510240069481375562044082148058992743343783) }}, 
      {{ SC_(3.451677799224853515625), SC_(6.90335559844970703125), SC_(0.1643170852637424266478964826850139891761923703977839179733380352749736866481876905951480241402650871), SC_(0.05213015711752623288278480275503274357544910148149545174167877455197749799469290173575128397737013009), SC_(2.987737202493214844088731841293627638949327548256269853925168462107878441893174234123961372842906391), SC_(0.9478698428824737671172151972449672564245508985185045482583212254480225020053070982642487160226298699) }}, 
      {{ SC_(3.451677799224853515625), SC_(345.16778564453125), SC_(0.2094375381886948717861051084009603807754176504974680675036172416728378934319220506494587623990168143e-143), SC_(0.664447750795984359222246924280149097055745898182376868957852076547683340115261880156857453610755197e-144), SC_(3.15205428775695727073662832397864162812551991865405377189850649738285212854136194503967287759735378), SC_(1) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.078823707997798919677734375), SC_(3979.809715367829047317888278217078172088596385172406763852068810521047011695645283607170253028037074), SC_(0.9999999999999402750339496456027526821626813759697286540308097229106466855237479103143755044174425076), SC_(0.2376940001372283829873284341281247837900028022641285834769024728477627559837726794234465024502746176e-9), SC_(0.5972496605035439724731783731862403027134596919027708935331447625208968562449558255749243794404123413e-13) }}, 
      {{ SC_(7.88237094879150390625), SC_(3.941185474395751953125), SC_(3770.434705915005921151777453704734300721493282509257897039293817864056202120074644227549385383332761), SC_(0.9473906984435568457877010097722005184357730540525580221847386845401637090240954581293899228317354176), SC_(209.3750094530608201662480528953311998012312274469388696150391212404677120484184021356046403241277591), SC_(0.0526093015564431542122989902277994815642269459474419778152613154598362909759045418706100771682645824) }}, 
      {{ SC_(7.88237094879150390625), SC_(7.094133853912353515625), SC_(2259.504281494144548802134149761741281397123723859500278361177114338408775457230422494994047506279229), SC_(0.5677417874450255416764749800116738757724089360970458845040997629985530966419312906823519377101045892), SC_(1720.305433873922192515891356838324219125600786096696488293155824766115138711262623868159978201181292), SC_(0.4322582125549744583235250199883261242275910639029541154959002370014469033580687093176480622898954108) }}, 
      {{ SC_(7.88237094879150390625), SC_(7.88237094879150390625), SC_(1801.305322480575109423269546102081216632945730622638691742482596740773256796125713409226748012793032), SC_(0.452610916427692594928188307753651727326624609223935469952605541382505774069746156183685426638227764), SC_(2178.504392887491631894755960497984283889778779333558074911850342363750657372367332953927277694667488), SC_(0.547389083572307405071811692246348272673375390776064530047394458617494225930253843816314573361772236) }}, 
      {{ SC_(7.88237094879150390625), SC_(8.6706085205078125), SC_(1385.998701155253760411361595025274476495767659154297495548279381040684682649756307239204160729721891), SC_(0.348257529952552454187438695468007855109544707669602258493521119260247991038217264638452234765248311), SC_(2593.81101421281298090666391157479102402695685080189927110605355806383923151873673912394986497773863), SC_(0.651742470047447545812561304531992144890455292330397741506478880739752008961782735361547765234751689) }}, 
      {{ SC_(7.88237094879150390625), SC_(15.7647418975830078125), SC_(41.47366868336445816334718833007928434146800188744317338153324233412729802926570404595789858361504874), SC_(0.01042101800073846697130314826362052370693681910868382585936936546279717697037315660477697660054912625), SC_(3938.336046684702283154678318269986216181256508068753593272799696770396616139227342317196127123845472), SC_(0.9895789819992615330286968517363794762930631808913161741406306345372028230296268433952230233994508738) }}, 
      {{ SC_(7.88237094879150390625), SC_(788.23712158203125), SC_(0.4098628875490468202415390423958744045264154776200644385505738092296587481868298104440405226599425315e-322), SC_(0.1029855487729370661385592190663704618584360482910039403681761198832811346210837452413806568209947594e-325), SC_(3979.80971536806674131802550660006550052272450995619676665433293910452391416849304636315402570746052), SC_(1) }}, 
      {{ SC_(15.848876953125), SC_(0.15848876535892486572265625), SC_(864813714589.5954516938617777150516539613650252952868802895634095543853641605725970667855636579584918), SC_(0.9999999999999999999999999868409403435640721040163737321066333492415539198641892936754764753099767295), SC_(0.1138013526198844052876462015238569718651803765821078088805884978586352966759084506756285667686605923e-13), SC_(0.1315905965643592789598362626789336665075844608013581070632452352469002327048208481608930454553515351e-25) }}, 
      {{ SC_(15.848876953125), SC_(7.9244384765625), SC_(857455078557.8186559439409480231461991712250523655325946499376377076378415854165763602745671614277657), SC_(0.9914910738490440132029194055624275232987632817376600027120470246177703761878889242162637658765959254), SC_(7358636031.77679574992084107204071677858050169437443802532295836478518078593690876536078236006039364), SC_(0.008508926150955986797080594437572476701236718262339997287952975382229623812111075783736234123404074593) }}, 
      {{ SC_(15.848876953125), SC_(14.26398944854736328125), SC_(543456207431.5277892524584568291692314107739221756802623465364491034830678876003149719981844930135557), SC_(0.6284084054904580890689857435492512109304772890456400367042151473962631724628797458182986586676872755), SC_(321357507158.0676624414033322660176845390316318842267703287241469689399544837531701536371650284746037), SC_(0.3715915945095419109310142564507487890695227109543599632957848526037368275371202541817013413323127245) }}, 
      {{ SC_(15.848876953125), SC_(15.848876953125), SC_(403510525688.6992732587835681641257109039155879627590731389572008878851682532404312142105015099805464), SC_(0.4665866404306371952836082750838488888638526270616845099302838069048718280475633148830753663725874852), SC_(461303188900.8961784350782209310612050458899660971479595363033951845378541181130539114248480115076129), SC_(0.5334133595693628047163917249161511111361473729383154900697161930951281719524366851169246336274125148) }}, 
      {{ SC_(15.848876953125), SC_(17.433765411376953125), SC_(276418089995.5182977583485870106970920893181614522453054100708596769898091436424991903972703788274048), SC_(0.3196273201179456360699084292479660831495832765300870907843636160354702907952999370398452431237945279), SC_(588395624594.0771539355132020844898238604873926076617272651897363954332132277109859352380791426607546), SC_(0.6803726798820543639300915707520339168504167234699129092156363839645297092047000629601547568762054721) }}, 
      {{ SC_(15.848876953125), SC_(31.69775390625), SC_(600115680.0552881611631351060216683189405541890544644705063642761972412838246249798196614828552764838), SC_(0.0006939247955151567565333562468275434183953541839757314991779604903811767298775213262009267488021013578), SC_(864213598909.5401635326986539891652476308649998708525682047542317962257810875288601458156880386328829), SC_(0.9993060752044848432434666437531724565816046458160242685008220395096188232701224786737990732511978986) }}, 
      {{ SC_(15.848876953125), SC_(1584.8876953125), SC_(0.163113107886086212173341867174873538338245524954349590570123573389562869154431409212893994879965561e-640), SC_(0.1886106859018683526851896176897136734503221273018007213192423142235257246798335688754957508764658987e-652), SC_(864813714589.5954516938617890951869159498055540599070326752605960724230223713534851256353495214881594), SC_(1) }}, 
      {{ SC_(31.314670562744140625), SC_(0.31314671039581298828125), SC_(778814717265774041244257106576403.8762726779997758454998199471243191703416382620718627158499147494477), SC_(0.9999999999999999999999999999999999999999999999999950959137153087603014420451969750429893744095041344), SC_(0.3819374573258768108704504016301750815256621981358015693603312864160916003899145582284112517497628668e-17), SC_(0.4904086284691239698557954803024957010625590495865573359650157227911125525690354777910557062747862277e-50) }}, 
      {{ SC_(31.314670562744140625), SC_(15.6573352813720703125), SC_(778566748518545485819764026092029.3967926151533938708061462099726511062555247902358317612307006611185), SC_(0.9996816075226478610969989773281892617240254186595266143385804198244875580182844440178678518270519304), SC_(247968747228555424493080484374.4794800628463819785130483104104361727906174881377817698758360696872852), SC_(0.0003183924773521389030010226718107382759745813404733856614195801755124419817155559821321481729480695913) }}, 
      {{ SC_(31.314670562744140625), SC_(29.314670562744140625), SC_(482833004676075172025820076340398.5825076976088758458228145385414356908480478542985227797515278585995), SC_(0.6199587578046579563535732598122442716901781651755658652796921025962309785151402994672345926666338678), SC_(295981712589698869218437030236005.2937649803909000034963799818416515881980944240750907513550088722062), SC_(0.3800412421953420436464267401877557283098218348244341347203078974037690214848597005327654073333661322) }}, 
      {{ SC_(31.314670562744140625), SC_(31.314670562744140625), SC_(370896755851488155472593493346712.4148522225290894677086951560628033554992036606815816518641978652044), SC_(0.4762323407980976323633991971154651466476069357868160897744155471908994651638810938674341752996143168), SC_(407917961414285885771663613229691.4614204554706863816104993643202839235469386176920318792423388656014), SC_(0.5237676592019023676366008028845348533523930642131839102255844528091005348361189061325658247003856832) }}, 
      {{ SC_(31.314670562744140625), SC_(33.314670562744140625), SC_(265681367758662399528500798549489.3873078049748167004775392929153103324001665415310450711121021919659), SC_(0.341135525393515942422391557029251027725203882426279944364470583016243351049186313788982692413516029), SC_(513133349507111641715756308026914.4889648730249591488416552274677769466459757368425684599944345388399), SC_(0.658864474606484057577608442970748972274796117573720055635529416983756648950813686211017307586483971) }}, 
      {{ SC_(31.314670562744140625), SC_(62.62934112548828125), SC_(3510010126637801956668819257.072053526730185083745305267217330129045954120627734398876930280129849447), SC_(0.4506861579299091675241191860802733381157752245815262181090987037577205034661630859784327486984048456e-5), SC_(778811207255647403442300437757146.8042191512695907655738892531657571500001881577458791322296064506759), SC_(0.999995493138420700908324758808139197266618842247754184737818909012962422794965338369140215672513016) }}, 
      {{ SC_(31.314670562744140625), SC_(3131.467041015625), SC_(0.9949734465011292884466475563156032901596853314020868171193367788975411454622042657355174384631237416e-1254), SC_(0.1277548336521214074803527819363002291258891900025277489565447091643729687904056223818620236180077516e-1286), SC_(778814717265774041244257106576403.8762726779997758493191945203830872790461422783736135311065367308058), SC_(1) }}, 
      {{ SC_(35.515575408935546875), SC_(0.355155766010284423828125), SC_(1839496023049279394690396563357488048160.926936902696873121474514229378668678846124147186118781332621), SC_(0.9999999999999999999999999999999999999999999999999999999988311705518566854522503357086930487486812418), SC_(0.2150057121482511052324363863657911472278809675549019401721908701625163879196312421165006871524811668e-17), SC_(0.1168829448143314547749664291306951251318758167273262927421466644472211354971342245927769000593543944e-56) }}, 
      {{ SC_(35.515575408935546875), SC_(17.7577877044677734375), SC_(1839250295623752849967374524755040772041.511965420859962594232308478793865855168465893679099785396169), SC_(0.9998664158973721457296652833638056718266664745466398849509354664513991159042158535832578423891303598), SC_(245727425526544723022038602447276119.4149714818369105293922628720673138760020221171649304682152617598), SC_(0.000133584102627854270334716636194328173333525453360115049064533548600884095784146416742157610869640248) }}, 
      {{ SC_(35.515575408935546875), SC_(33.515575408935546875), SC_(1126716761530690811983406818725232577296.140512385245346121416437687863367701603471251111605815700971), SC_(0.6125138339048784673611008444529708074044457722184180569761021928679936686124029766660288710214041085), SC_(712779261518588582706989744632255470864.7864245174515270022081336629978120295670167597324244379104599), SC_(0.3874861660951215326388991555470291925955542277815819430238978071320063313875970233339711289785958915) }}, 
      {{ SC_(35.515575408935546875), SC_(35.515575408935546875), SC_(878695297016098993751007321739301720829.4727268066609360575474550081846711938082514413961359329625398), SC_(0.4776826293755782058145073704574612504921398873157110358604907120033842521624253362408436148039094658), SC_(960800726033180400939389241618186327331.4542100960359370660771163426765085373622365694478943206488914), SC_(0.5223173706244217941854926295425387495078601126842889641395092879966157478375746637591563851960905342) }}, 
      {{ SC_(35.515575408935546875), SC_(37.515575408935546875), SC_(643897589426613602623485968571508913189.7152520524471566296144651913565045824300879927548999957274038), SC_(0.3500402182763315670128709273491916384350933712803249530899083839804758189215891746180200615671579888), SC_(1195598433622665792066910594785979134971.211684850249716494010106159504675148740400018089130257884027), SC_(0.6499597817236684329871290726508083615649066287196750469100916160195241810784108253819799384328420112) }}, 
      {{ SC_(35.515575408935546875), SC_(71.03115081787109375), SC_(2158910129007642031735750832929901.432294137427407475107438019527761330492604912014324864125358688972), SC_(0.1173642183487235327037390685996140001643280328037847481368390684502765726051207257699613803418768997e-5), SC_(1839493864139150387048364827606655118259.494642765269465648517133331333418400677883098829705389486072), SC_(0.9999988263578165127646729626093140038599983567196719621525186316093154972342739487927423003861965812) }}, 
      {{ SC_(35.515575408935546875), SC_(3551.5576171875), SC_(0.1340030996194779112296477120665147262826786996479245056900015054289664486503723649859792530476059284e-1419), SC_(0.7284772456172253407403713169396491570909000355628240421568270918043560629979548519498562921345492656e-1459), SC_(1839496023049279394690396563357488048160.926936902696873123624571350861179731170488010844030253611431), SC_(1) }}, 
      {{ SC_(95.0640411376953125), SC_(0.9506404399871826171875), SC_(0.145510476855517573901572383428911247103923229518208566615055995925169354783431079715899205682607104), SC_(1), SC_(0.3338748844030338166357658335733104939045075103209763229768920051823157362177984933932816984293886097e-4), SC_(0.2294507527004738159428298921938008182351350879950245832976058440950034518526560630407577127311992909e-150) }}, 
      {{ SC_(95.0640411376953125), SC_(47.53202056884765625), SC_(0.1455104767317315688714628619298764969395583677721590029196049408676387503309128823706686067571141588), SC_(0.9999999991492983343527836690569163403364335708467316108801184271247197504258774844023559647719048361), SC_(0.1237860050301095214990347501643648617460495636954510550575306044525181973452305989254929452136627688), SC_(0.8507016656472163309430836596635664291532683891198815728752802495741225155976440352280951639280628239e-9) }}, 
      {{ SC_(95.0640411376953125), SC_(93.0640411376953125), SC_(0.8270953894409340626253014797078388694548935740964212374525082405522401617834178085260777282042004003), SC_(0.5684095106513779855100143265286500637194863353225008935081840999467563524252772890135430364314749654), SC_(0.6280093791142416763904223545812736015843387210856644286980517186994533860508929886329143286218706396), SC_(0.4315904893486220144899856734713499362805136646774991064918159000532436475747227109864569635685250346) }}, 
      {{ SC_(95.0640411376953125), SC_(95.0640411376953125), SC_(0.7077051625452294911344927408220857430447700121426935420144897510955828892742667812806226323972360384), SC_(0.4863602799184931701789661009861255111997908526943918773797582829282683257000441156493062801250089046), SC_(0.7473996060099462478812310934670267279944622830393921241360702081561106585600440158783694244288350016), SC_(0.5136397200815068298210338990138744888002091473056081226202417170717316742999558843506937198749910954) }}, 
      {{ SC_(95.0640411376953125), SC_(97.0640411376953125), SC_(0.5907750060751459131633159171875333040151503013593145312641721231743104807411741543193437407980260481), SC_(0.406001697500962089288941792982261441414876691538444277046888243696282520680806473204672610497138837), SC_(0.8643297624800298258524079171015791670240819938227711348863878360773830670931366428396483160280449919), SC_(0.593998302499037910711058207017738558585123308461555722953111756303717479319193526795327389502861163) }}, 
      {{ SC_(95.0640411376953125), SC_(190.128082275390625), SC_(0.1250182074547620992214675725176948920111523542123681850515412344728775663708689887288190847857890665), SC_(0.8591698010782896169858772991337093789443227801953170296511699301738602943099686230052571279996311061e-14), SC_(0.1455104768555163237194978358079190324281980525692884550915138722433188393710863509402354969927198158), SC_(0.9999999999999914083019892171038301412270086629062105567721980468297034883006982613970569003137699474) }}, 
      {{ SC_(95.0640411376953125), SC_(9506.404296875), SC_(0.410843456339856518931606427624153949626406539905791201082368440245547080360115104031712516488780225e-3754), SC_(0.2823463060655057243296240358288810188079450590292603437426554366141893572584859875591659170203266194e-3900), SC_(0.145510476855517573901572383428911247103923229518208566615055995925169354783431079715899205682607104), SC_(1) }}, 
      {{ SC_(230.1575469970703125), SC_(1), SC_(0.7943512307351483242116753931994555755252863994748982526699162024988971699725221518219249134173513373), SC_(1), SC_(0.001605325555957824512231082175017738406782181505873305483713006465121498687391150947753752042955234629), SC_(0.2020926630241566676562263620495817485172495859575490783548984837449311511609113883628635101437863762e-445) }}, 
      {{ SC_(230.1575469970703125), SC_(115.07877349853515625), SC_(0.7943512307351483242096295671350543391046865291446812785362675126379944308580154078637829951922550169), SC_(0.999999999999999999997424532139884915216691694261381644774940945904564087155008373661686631758703312), SC_(0.2045826064401236420599870330216974133648689860902739114506743958141918225096320389822784602629423829), SC_(0.2575467860115084783308305738618355225059054095435912844991626338313368241296687959051921053402245151e-20) }}, 
      {{ SC_(230.1575469970703125), SC_(228.1575469970703125), SC_(0.4320352500050499378139047005826494686951628124789491900175458122808307767421127117826956600568476985), SC_(0.5438844094258080593135924988903306028970803734274413960639336508587960608083506963680177065156017707), SC_(0.3623159807300983863977706926168061068301235869959490626523703902180663932304094400392292533605036387), SC_(0.4561155905741919406864075011096693971029196265725586039360663491412039391916493036319822934843982293) }}, 
      {{ SC_(230.1575469970703125), SC_(230.1575469970703125), SC_(0.3902125711209141749169738822595467642465379627204853447527623692260839529414655887300731747165667578), SC_(0.4912343004237358607289747140325946370477956811693055364940306943959659677095875895076435061750962822), SC_(0.4041386596142341492947015109399088112787484367544129079171538332728132170310565630918517387007845794), SC_(0.5087656995762641392710252859674053629522043188306944635059693056040340322904124104923564938249037178) }}, 
      {{ SC_(230.1575469970703125), SC_(232.1575469970703125), SC_(0.3487501889396853257613873709625756982927978890960690452261371310879305408861795829594157702393902252), SC_(0.4390377649656656899508279604758759349074080513082357116118517884562056435445571208463156984095475396), SC_(0.4456010417954629984502880222368798772324885103788292074437790714109666290863425688625091431779611121), SC_(0.5609622350343343100491720395241240650925919486917642883881482115437943564554428791536843015904524604) }}, 
      {{ SC_(230.1575469970703125), SC_(460.315093994140625), SC_(0.4407730519635239782394783554127362184391684954328510668870843466275578363345143797655617743698392878), SC_(0.5548843319039131990882691513243314111283345266801758353532094934100654252020248166518909120713686568e-32), SC_(0.7943512307351483242116753931994511677947667642351158578863620751367127782875678233112560425738850617), SC_(0.9999999999999999999999999999999944511566809608680091173084867566858887166547331982416464679050658993) }}, 
      {{ SC_(230.1575469970703125), SC_(23015.75390625), SC_(BOOST_MATH_SMALL_CONSTANT(0.9559236409417348208950021152441346378729603969644625960148748982677900217226751345451199820074363395e-8996)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1203401724520595328794601630545412981309154417499555052010254193737832188451276268511110869475419232e-9438)), SC_(0.7943512307351483242116753931994555755252863994748982526699162024988971699725221518219249134173513373), SC_(1) }}, 
      {{ SC_(460.871795654296875), SC_(1), SC_(0.3035697913328577383103573207361433550048171545351043103427946337286406766335561424688872199902627644), SC_(1), SC_(0.0007999570943827548943010381276909696101503474270950161551998016380700161022055691674813276239985866686), SC_(0.263516699362756806302924272183408617249859311132449191463747391836511682589270348351185414999011926e-1029) }}, 
      {{ SC_(460.871795654296875), SC_(230.4358978271484375), SC_(0.3035697913328577383103573207361433550047925351370884076635599897138082095152794906157429847334951853), SC_(0.9999999999999999999999999999999999999999189003691447412844502774348028830000232618580279072994806341), SC_(0.2461939801590267923464401483246711827665185314423525676757909375351780224332385807676145414825568404), SC_(0.8109963085525871554972256519711699997673814197209270051936588154826179820725730567233569656951290491e-40) }}, 
      {{ SC_(460.871795654296875), SC_(458.871795654296875), SC_(0.1611931483241718379676730539883166095529909983108046890396800612185587953951876268408693414028956011), SC_(0.530992058255977856491744157658594549661381367389538808982523985300127763450276738767474706920587693), SC_(0.1423766430086859003426842667478267454518261562242996213031145725100818812383685156280178785873671632), SC_(0.469007941744022143508255842341405450338618632610461191017476014699872236549723261232525293079412307) }}, 
      {{ SC_(460.871795654296875), SC_(460.871795654296875), SC_(0.1499044425611669817452516634978304074804845409565096465620306533651905004146763285309824382109683004), SC_(0.4938055328331401358749551739774500026079273309328516400413537728779540654346471892486393687796370785), SC_(0.1536653487716907565651056572383129475243326135785946637807639803634501762188798139379047817792944639), SC_(0.5061944671668598641250448260225499973920726690671483599586462271220459345653528107513606312203629215) }}, 
      {{ SC_(460.871795654296875), SC_(462.871795654296875), SC_(0.1386645136476389702527676004487322668191450267077516764379529098330836887026073425447155428151335593), SC_(0.4567796849575072422528834382064975306821917056574500241896950256666133220324798484185934498637551554), SC_(0.164905277685218768057589720287411088185672127827352633904841723895556987930948799924171677175129205), SC_(0.5432203150424927577471165617935024693178082943425499758103049743333866779675201515814065501362448446) }}, 
      {{ SC_(460.871795654296875), SC_(921.74359130859375), SC_(0.214579568282097447843285341234033253132140021796896174619250110179219191931782655042052951085903063), SC_(0.7068541548220638744450497903888966495830510626579681233627159150684459468037055060183111727855356285e-63), SC_(0.3035697913328577383103573207361433550048171545351043103427946335140611083514586946256018787562295112), SC_(0.9999999999999999999999999999999999999999999999999999999999999992931458451779361255549502096111033504) }}, 
      {{ SC_(460.871795654296875), SC_(46087.1796875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1759948687946540932943422895133578780806254223549085877126768144753543541319766123991600654675160946e-17870)), SC_(BOOST_MATH_SMALL_CONSTANT(0.5797509298337248254275801202156047189153910514148794160732208629325216030358623936601957024666048442e-18897)), SC_(0.3035697913328577383103573207361433550048171545351043103427946337286406766335561424688872199902627644), SC_(1) }}, 
      {{ SC_(664.0791015625), SC_(1), SC_(0.5745703266423053012388846296755759814458236575017295797872518233032217040765801424270951932343892656), SC_(1), SC_(0.000554803499100533461700081675382127658415484012034431099012469964977561860611562701898919933771029858), SC_(0.9655972008556621156398909346034920368728235561361941209577148915248010183298024193896373627559762647e-1588) }}, 
      {{ SC_(664.0791015625), SC_(332.03955078125), SC_(0.5745703266423053012388846296755759814458236575017295797869018458769535952325154619307030524922146164), SC_(0.9999999999999999999999999999999999999999999999999999999993908884429982322791299632237165916284594418), SC_(0.3499774262681088440646804963921407421746491858377886363583697179665453608787350388997316735168900411), SC_(0.6091115570017677208700367762834083715405581683323513398498453028923230365514524283437552918367998412e-57) }}, 
      {{ SC_(664.0791015625), SC_(662.0791015625), SC_(0.3021167487573438738160129595305571832198618183437747086825419999530854511327755168926331826960039427), SC_(0.5258133508614421049922565116779507398294624638695327972751007507697623513933985163278375927725745103), SC_(0.2724535778849614274228716701450187982259618391579548711047098233501362529438046255344620105383853229), SC_(0.4741866491385578950077434883220492601705375361304672027248992492302376486066014836721624072274254897) }}, 
      {{ SC_(664.0791015625), SC_(664.0791015625), SC_(0.2843201563499913066053586445117464815121852615133384043443363638833281789611578313103564412744820411), SC_(0.494839609994326789934188822741956842775938040001912655673429653876761834997096017421334224252871364), SC_(0.2902501702923139946335259851638294999336383959883911754429154594198935251154223111167387519599072244), SC_(0.505160390005673210065811177258043157224061959998087344326570346123238165002903982578665775747128636) }}, 
      {{ SC_(664.0791015625), SC_(666.0791015625), SC_(0.2665770008350486832539682183986178091094039928067551889686056029306641365030303914782037547507298816), SC_(0.4639588723505457189002094923711730626394167476456643807276073537522553952201326725769733994829306401), SC_(0.3079933258072566179849164112769581723364196646949743908186462203725575675735497509488914384836593839), SC_(0.5360411276494542810997905076288269373605832523543356192723926462477446047798673274230266005170693599) }}, 
      {{ SC_(664.0791015625), SC_(1328.158203125), SC_(0.2815972350463307317319513325546921336811187310092965580873275148483880823923796516975854414779446515), SC_(0.490100553385585993788823794136328178072277263551970508868100075216984438630852032648844240985526793e-90), SC_(0.5745703266423053012388846296755759814458236575017295797872518233032217040765801424270951929527920305), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999995098994466) }}, 
      {{ SC_(664.0791015625), SC_(66407.90625), SC_(BOOST_MATH_SMALL_CONSTANT(0.8516936430425091984695352018926240039240039876743845066067885000233245389027299911547740471304411031e-25643)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1482314006745992402392065908335891607562619332695970947910626860700838612133574022151344757253035352e-27227)), SC_(0.5745703266423053012388846296755759814458236575017295797872518233032217040765801424270951932343892656), SC_(1) }}, 
      {{ SC_(1169.2916259765625), SC_(1), SC_(0.2211789888023831503246826752278734722240439253686325962175969884553455378953601789267541504616923277), SC_(1), SC_(0.0003148864236423753142799300005285283127912884357020962982280135041640804352403607375497608504709569992), SC_(0.1423672408249035673853164595912914309562984950734405225106779761662731230245426459145165372095669607e-3081) }}, 
      {{ SC_(1169.2916259765625), SC_(584.64581298828125), SC_(0.2211789888023831503246826752278734722240439253686325962175969884553455378953601789267541504616923277), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999998), SC_(0.4251581173713294990895228243877471105625206871093006314536841396842453368736997236563189985257137593), SC_(0.1922235559866835428767949912699689078565566007500741320105283086319101530842124947089114693215734909e-99) }}, 
      {{ SC_(1169.2916259765625), SC_(1167.2916259765625), SC_(0.1148913148430660007404559319786710085496945916646259215810780041406350545777929034671173346191878257), SC_(0.5194494986398458229099025998514760815236833039291615271666420090780290283552325279002354379324796388), SC_(0.106287673959317149584226743249202463674349333704006674636518984314710483317567275459636815842504502), SC_(0.4805505013601541770900974001485239184763166960708384728333579909219709716447674720997645620675203612) }}, 
      {{ SC_(1169.2916259765625), SC_(1169.2916259765625), SC_(0.1097293461334211936196186098765103513825912847901162614195092808968794457897461936852246112756938448), SC_(0.4961110760455691456152544829180582276831949404486516253736169842404434869834516021522451806309381424), SC_(0.1114496426689619567050640653513631208414526405785163347980877075584660921056139852415295391859984829), SC_(0.5038889239544308543847455170819417723168050595513483746263830157595565130165483978477548193690618576) }}, 
      {{ SC_(1169.2916259765625), SC_(1171.2916259765625), SC_(0.1045761915724994772699317733451515392457114868019129222313801712339302377148535579285521591865594366), SC_(0.4728125042019031691903140623366099509942791065498616795361308461781345126406997089894375857466236069), SC_(0.1166027972298836730547509018827219329783324385667196739862168172214153001805066209982019912751328912), SC_(0.5271874957980968308096859376633900490057208934501383204638691538218654873593002910105624142533763931) }}, 
      {{ SC_(1169.2916259765625), SC_(2338.583251953125), SC_(0.3853660517961866267548503750089203171857055088519007059620968150399652189311257677799267678599538164), SC_(0.1742326673445910972431954923648105731106713066341076374902708289141328648814063925289049214586889559e-157), SC_(0.2211789888023831503246826752278734722240439253686325962175969884553455378953601789267541504616923277), SC_(1) }}, 
      {{ SC_(1169.2916259765625), SC_(116929.1640625), SC_(BOOST_MATH_SMALL_CONSTANT(0.1334921973028690412368136130282362266211264532031309191211246173794760240250211434584800981343637091e-44860)), SC_(BOOST_MATH_SMALL_CONSTANT(0.6035482756553351914398657934266315863036146517683943373863531255923722374767324696235963112082335455e-47939)), SC_(0.2211789888023831503246826752278734722240439253686325962175969884553455378953601789267541504616923277), SC_(1) }}, 
      {{ SC_(2057.796630859375), SC_(1), SC_(0.2296607098745991351513439491999254015070811420500402999956642121725140715538280690982449249151182744), SC_(1), SC_(0.0001788603446415592472512376463686763352142734957575834349538723877570073123201456502328382989629296588), SC_(BOOST_MATH_SMALL_CONSTANT(0.7788025419725549031043567928048587098198224051085568478803331745902750314471563131849915968668166695e-5927)) }}, 
      {{ SC_(2057.796630859375), SC_(1028.8983154296875), SC_(0.2296607098745991351513439491999254015070811420500402999956642121725140715538280690982449249151182744), SC_(1), SC_(0.9822844006807419524699774209176095928147927787459050881127600530947159125340637625888955323105924994), SC_(0.4277111227327893392956905805573130925190053689139455240870060837560269563451544938490472860053531939e-174) }}, 
      {{ SC_(2057.796630859375), SC_(2055.796630859375), SC_(0.1181970778393469944551585447788996343247484863125676497955892509032681427741390030228718216377717021), SC_(0.5146595510563637431071584380665041151517840985243959943271211766126099181752511155269841800877407187), SC_(0.1114636320352521406961854044210257671823326557374726502000749612692459287796890660753731032773465723), SC_(0.4853404489436362568928415619334958848482159014756040056728788233873900818247488844730158199122592813) }}, 
      {{ SC_(2057.796630859375), SC_(2057.796630859375), SC_(0.1141571063368333335549056714887837836223093960256471510446261076349612596796785907592276653667764085), SC_(0.4970685077093341491049428149069921151108953421435248479241067800168777919786478963838719883781055889), SC_(0.1155036035377658015964382777111416178847717460243931489510381045375528118741494783390172595483418659), SC_(0.5029314922906658508950571850930078848891046578564751520758932199831222080213521036161280116218944111) }}, 
      {{ SC_(2057.796630859375), SC_(2059.796630859375), SC_(0.1101210575241523286005972733062095852404319473645093682804326140992694666629481735607350959283621991), SC_(0.4794945447320151505244609247943138810471077522080625919866429085483861553259121554634814161108765226), SC_(0.1195396523504468065507466758937158162666491946855309317152315980732446048908798955375098289867560753), SC_(0.5205054552679848494755390752056861189528922477919374080133570914516138446740878445365185838891234774) }}, 
      {{ SC_(2057.796630859375), SC_(4115.59326171875), SC_(0.1184802275824791022571834680209296613447564684666621309564053455602973525777492482319187677060560432), SC_(0.5158924556454278242195499999686615277394459408484310942606310759251402814732192780093913845058465035e-276), SC_(0.2296607098745991351513439491999254015070811420500402999956642121725140715538280690982449249151182744), SC_(1) }}, 
      {{ SC_(2057.796630859375), SC_(205779.65625), SC_(BOOST_MATH_SMALL_CONSTANT(0.4201428634932982855590128692571495505659212593160178569139973150589427696759188605068591915292645523e-78440)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1829406796324488764221415721149535896951274162966389404491557586743437861782808243268924184165028864e-84363)), SC_(0.2296607098745991351513439491999254015070811420500402999956642121725140715538280690982449249151182744), SC_(1) }}, 
      {{ SC_(5823.5341796875), SC_(1), SC_(0.1204395397514337475423786621774349420062760132029898805362923119619100468071321611679283901089428652), SC_(1), SC_(0.6318201301512319242829917005636884943368220526214159580849901321408186241292901627433210404056827978e-4), SC_(BOOST_MATH_SMALL_CONSTANT(0.5245952711669263519210693557964617436547132969346871040581963321734735795313612558534271821781318411e-19400)) }}, 
      {{ SC_(5823.5341796875), SC_(2911.76708984375), SC_(0.1204395397514337475423786621774349420062760132029898805362923119619100468071321611679283901089428652), SC_(1), SC_(0.4035259729288404343552749435692175466685338188811768319423095321055726721842742984032087143214236599), SC_(0.3350444328844562385775121047850168127494131430195647748520977802476677594087402915363606825742343083e-490) }}, 
      {{ SC_(5823.5341796875), SC_(5821.5341796875), SC_(0.6126920809889162048883575147692727204635949058113441363539761562854353553260508847605536631622514472), SC_(0.5087134028022741086387529518673768528172426138087777028759999654326711259860222847941770091355247484), SC_(0.5917033165254212705354291070050766995991652262185546690089469633336651127452707269187302379271772049), SC_(0.4912865971977258913612470481326231471827573861912222971240000345673288740139777152058229908644752516) }}, 
      {{ SC_(5823.5341796875), SC_(5823.5341796875), SC_(0.6000989280305561918308588121091415609770180970873138723602626680145344318925207189486424421186686595), SC_(0.4982574072178089990585121217647990047541960897876785713029080474657389735630621455528428027141859677), SC_(0.6042964694837812835929278096652078590857420349425849330026604516045660361788008927306414589707599927), SC_(0.5017425927821910009414878782352009952458039102123214286970919525342610264369378544471571972858140323) }}, 
      {{ SC_(5823.5341796875), SC_(5825.5341796875), SC_(0.5875100985050789481864072831420352596099318466445228673422078429397158588973815853817471380143431533), SC_(0.48780500134556936977004263447238945560454812532198011665953206594566719692149899347013902778973964), SC_(0.6168852990092585272373793386323141604528282853853759380207152766793846091739400262975367630750854988), SC_(0.51219499865443063022995736552761054439545187467801988334046793405433280307850100652986097221026036) }}, 
      {{ SC_(5823.5341796875), SC_(11647.068359375), SC_(0.5353527302842454914572421462782089453923068596623200437216734225930083166517293351090646020310494752), SC_(0.4444991498548735493821113261413094182993223786289714525114040696846695823566433886781875769143935322e-778), SC_(0.1204395397514337475423786621774349420062760132029898805362923119619100468071321611679283901089428652), SC_(1) }}, 
      {{ SC_(5823.5341796875), SC_(582353.4375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1306843628941291279596587214414256236728415340542843841458695749930348339470885205941165569646322079e-219344)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1085061958588009491652051793216903806290512061576938386117858324035783177763463890242081951747644651e-238740)), SC_(0.1204395397514337475423786621774349420062760132029898805362923119619100468071321611679283901089428652), SC_(1) }}, 
      {{ SC_(9113.3095703125), SC_(1), SC_(0.2058284735294648231534673957777340107191538633051240481422777650293706102527136539254313499140613425), SC_(1), SC_(0.4037170092859947171051886914823887325296146261863938904807985526887128393010583619637026093856940876e-4), SC_(BOOST_MATH_SMALL_CONSTANT(0.1961424492749792906069609223922162691035648940014810214081197868423196767074778143387553776773884785e-32130)) }}, 
      {{ SC_(9113.3095703125), SC_(4556.65478515625), SC_(0.2058284735294648231534673957777340107191538633051240481422777650293706102527136539254313499140613425), SC_(1), SC_(0.6109377214187031022316054159922887207113747225714451450654131455750653440696736591254903504865772707), SC_(0.2968188564694602134756320513815309578474741421887761461484741830281935296582920785928397009274511509e-766) }}, 
      {{ SC_(9113.3095703125), SC_(9111.3095703125), SC_(0.1043478778903032904507254378873664862163967379105136115494921359540150657805686187420775552682050699), SC_(0.5069652225515127761139756648006698185865481908723864989191437142873208577668041858919621519562798842), SC_(0.1014805956391615327027419578903675245027571253946104365927856290753555444721450351833537946458562726), SC_(0.4930347774484872238860243351993301814134518091276135010808562857126791422331958141080378480437201158) }}, 
      {{ SC_(9113.3095703125), SC_(9113.3095703125), SC_(0.1026275177685656364890949896204867326423388372804577577731301989347594536047854290961838095177720948), SC_(0.4986070003277475086621436243232816155603962044739470943558278267678784076324835549046763593951499622), SC_(0.1032009557608991866643724061572472780768150260246662903691475660946111566479282248292475403962892477), SC_(0.5013929996722524913378563756767183844396037955260529056441721732321215923675164450953236406048500378) }}, 
      {{ SC_(9113.3095703125), SC_(9115.3095703125), SC_(0.1009075351129165861035492191302916783244651730318660685395897540635511698554749260656934916726778491), SC_(0.4902506119906264500395580518169463900862860214613231920536378253585336247100111218942361723610119757), SC_(0.1049209384165482370499181766474423323946886902732579796026880109658194403972387278597378582413834934), SC_(0.5097493880093735499604419481830536099137139785386768079463621746414663752899888781057638276389880243) }}, 
      {{ SC_(9113.3095703125), SC_(18226.619140625), SC_(0.2844201695607462461046288417599451943410582108941500320299291215678803002029948089751534122462413978), SC_(0.1381831020186965723509796431234180433841791957413460611775479295093149059469403680680588975239641139e-1216), SC_(0.2058284735294648231534673957777340107191538633051240481422777650293706102527136539254313499140613425), SC_(1) }}, 
      {{ SC_(9113.3095703125), SC_(911330.9375), SC_(BOOST_MATH_SMALL_CONSTANT(0.2634558899021205314041532677186125127324533196940061567254967357798886751103797693911325418379331619e-341479)), SC_(BOOST_MATH_SMALL_CONSTANT(0.127997786401698310219717935271258163287422251796870023632726955567030034172504342639656107002595249e-373605)), SC_(0.2058284735294648231534673957777340107191538633051240481422777650293706102527136539254313499140613425), SC_(1) }}, 
      {{ SC_(31387.41015625), SC_(1), SC_(0.1907153914260137766081242520060232376058679739088173806739260816310109592191535200104259238502823114), SC_(1), SC_(0.1172097856896058268698780001377136569290991309340363479889876878658000708291760860866831167807270228e-4), SC_(BOOST_MATH_SMALL_CONSTANT(0.6145795827657478246713528055954877980223660793035074463222390108567932746239676554864860396068354328e-127513)) }}, 
      {{ SC_(31387.41015625), SC_(15693.705078125), SC_(0.1907153914260137766081242520060232376058679739088173806739260816310109592191535200104259238502823114), SC_(1), SC_(0.1178940944440575118484057547609480198287057753687344488602125702168138518988852818906560456377655828), SC_(0.6181676977539246234778546964931531171263852830030672634254567333844990255403536962432314618520183912e-2635) }}, 
      {{ SC_(31387.41015625), SC_(31385.41015625), SC_(0.9607346152919525199880979895188512454515764100687040469903581036630732159159887778018753399814702988), SC_(0.5037530574267574950285346598748481476034239981169588651898103217495670654430574683807499422545184211), SC_(0.9464192989681852460931445305413811306071033290194697597489027126470363762755464223023838985213528154), SC_(0.4962469425732425049714653401251518523965760018830411348101896782504329345569425316192500577454815789) }}, 
      {{ SC_(31387.41015625), SC_(31387.41015625), SC_(0.9521454388761436323609355018051756475974072518959609739004957130130269970551939745267389118331132782), SC_(0.4992493955295262078624630020406504359970108488437383103275210393051794296194033332729085717661902896), SC_(0.955008475383994133720307018255056728461272487192212832838765103297082595136341225577520326669709836), SC_(0.5007506044704737921375369979593495640029891511562616896724789606948205703805966667270914282338097104) }}, 
      {{ SC_(31387.41015625), SC_(31389.41015625), SC_(0.9435568097262039923404683068116690883643670926776098133654518635680589408058715489960845828809997579), SC_(0.4947460205865177317657787953702156470879097009546148598250336067254482340200731084198867465150117276), SC_(0.9635971045339337737407742132485632876943126464105639933738089527420506513856636511081746556218233563), SC_(0.5052539794134822682342212046297843529120902990453851401749663932745517659799268915801132534849882724) }}, 
      {{ SC_(31387.41015625), SC_(62774.8203125), SC_(0.639440870992195110243168891395043075970119175325222539369097746057899381944623539419388796691846333), SC_(0.3352854041883977247774206822492896029430517273753461135918538525190213990661515897439781385194335162e-4185), SC_(0.1907153914260137766081242520060232376058679739088173806739260816310109592191535200104259238502823114), SC_(1) }}, 
      {{ SC_(31387.41015625), SC_(3138741), SC_(BOOST_MATH_SMALL_CONSTANT(0.8712340128913840990158681888626366121803871270318591176775961058292458205022056834607179300912579579e-1159228)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4568241746914123883971626233329316053998069787008932952589706205337117010465312411468070532148356825e-1286736)), SC_(0.1907153914260137766081242520060232376058679739088173806739260816310109592191535200104259238502823114), SC_(1) }}, 
      {{ SC_(53731.765625), SC_(1), SC_(0.1968375061316474051696679914969989794166523446713072964017484226785290381190494752446686823589822611), SC_(1), SC_(0.6846718760933685833021646032164728730373454920630880010700244576412946459126644872424651974762617329e-5), SC_(BOOST_MATH_SMALL_CONSTANT(0.3478360854843646528005950030296176413493884510395694421618624709007598051252449019794914871773442384e-230831)) }}, 
      {{ SC_(53731.765625), SC_(26865.8828125), SC_(0.1968375061316474051696679914969989794166523446713072964017484226785290381190494752446686823589822611), SC_(1), SC_(0.4596204454239807853790732663423567816759432173785340424309074767567519221051637504214333998617934737), SC_(0.2335024734140762981026837224978008762575936206362713332576404458305954499600642343912165066945157393e-4509) }}, 
      {{ SC_(53731.765625), SC_(53729.765625), SC_(0.9898336951885252520260938613285785464035396900705476186477833018587239309299831484654462523016012066), SC_(0.5028684393748171144639183376370325602727658807295180617202372561848623433680228389050363745414042978), SC_(0.9785413661279487996705860536414112477629837566425253453697009249265664502605116039812405712882214042), SC_(0.4971315606251828855360816623629674397272341192704819382797627438151376566319771610949636254585957022) }}, 
      {{ SC_(53731.765625), SC_(53731.765625), SC_(0.9830583039168975325307605275070567301075887193360096847489237445380506065822885212933536241265585848), SC_(0.4994263152569184389892349690243164177907483429757537595214928334958766883412534478021012611761406009), SC_(0.985316757399576519165919387462933064058934727377063279268560482247239774608206231153333199463264026), SC_(0.5005736847430815610107650309756835822092516570242462404785071665041233116587465521978987388238593991) }}, 
      {{ SC_(53731.765625), SC_(53733.765625), SC_(0.97628316482902031647854485716302419515105170546283958951870828792200970695273562786028952581753817), SC_(0.4959843192567527400639733542343360232035266718796637178642939191793549740917081309022729249590482264), SC_(0.9920918964874537352181350578069655990154717412502333744987759388632806742377591245863972977722844408), SC_(0.5040156807432472599360266457656639767964733281203362821357060808206450259082918690977270750409517736) }}, 
      {{ SC_(53731.765625), SC_(107463.53125), SC_(0.9857000573732164937380523004169343050694041258310103979727730835148474946175436750885160009501077337), SC_(BOOST_MATH_SMALL_CONSTANT(0.5007684138783834575499330461565279986066528056814362965625964516201140516349885790241319685256190109e-7163)), SC_(0.1968375061316474051696679914969989794166523446713072964017484226785290381190494752446686823589822611), SC_(1) }}, 
      {{ SC_(53731.765625), SC_(5373176.5), SC_(BOOST_MATH_SMALL_CONSTANT(0.3718061873698555444448063789266736654059535208915550950860496543206793529115247245781925385442586833e-1971920)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1888899095892765882957244319190855136922162514010618617401162857457945289825998923759689962325214871e-2202746)), SC_(0.1968375061316474051696679914969989794166523446713072964017484226785290381190494752446686823589822611), SC_(1) }}, 
      {{ SC_(117454.09375), SC_(1), SC_(0.9318118105062591002929457015325712659659543801643169834185264964234249069692069364865148866469370692), SC_(1), SC_(0.313213921744632971050579853869676581728906891724484285710033076001673183535297248385604569944902853e-5), SC_(BOOST_MATH_SMALL_CONSTANT(0.3361343118998050869634246624964916040167904082273682960527262239208359804459089238240999775478833994e-544470)) }}, 
      {{ SC_(117454.09375), SC_(58727.046875), SC_(0.9318118105062591002929457015325712659659543801643169834185264964234249069692069364865148866469370692), SC_(1), SC_(0.9191586889607675560018325512164330792065221712018362595259346904441468428861721496925241967346843064), SC_(BOOST_MATH_SMALL_CONSTANT(0.9864209474457969948221715384559498587958215887291280078996110294207932757072463789506127465999022247e-9855)) }}, 
      {{ SC_(117454.09375), SC_(117452.09375), SC_(0.4677137205305140734081198423668819310551597308270642385460447347821821628461339537856199850875464552), SC_(0.5019401077095195070323848313576574442812198192986467929838617161888974569553340375704576649153144829), SC_(0.464098089975745026884825859165689334910794649337252744872481761641242744123072982700894901559390614), SC_(0.4980598922904804929676151686423425557187801807013532070161382838111025430446659624295423350846855171) }}, 
      {{ SC_(117454.09375), SC_(117454.09375), SC_(0.465544343100630356053620730347685891129180124181192306543195806422400059864981029492940362835899938), SC_(0.499611979427151974874897833905897697363907477678490396979994271179885705982324624234690235502943969), SC_(0.4662674674056287442393249711848853748367742559831246768753306900010248471042259069935745238110371312), SC_(0.500388020572848025125102166094102302636092522321509603020005728820114294017675375765309764497056031) }}, 
      {{ SC_(117454.09375), SC_(117456.09375), SC_(0.4633750026101230583781220405717433582374619595678524934079773142234579837891564729114009490865727437), SC_(0.4972838907873131198433312739984807998957012913706772498633297552685545410772772846679655645399634758), SC_(0.4684368078961360419148236609608279077284924205964644900105491821999669231800504635751139375603643255), SC_(0.5027161092126868801566687260015192001042987086293227501366702447314454589227227153320344354600365242) }}, 
      {{ SC_(117454.09375), SC_(234908.1875), SC_(0.3765617481860321182118792720765163211623400846148178858934295299139956899505817861365275762655792927), SC_(BOOST_MATH_SMALL_CONSTANT(0.404117809991530155979898593834626437803581387079414920652000290931175084399705146249771222798155904e-15655)), SC_(0.9318118105062591002929457015325712659659543801643169834185264964234249069692069364865148866469370692), SC_(1) }}, 
      {{ SC_(117454.09375), SC_(11745409), SC_(BOOST_MATH_SMALL_CONSTANT(0.3749176167726247694377808265587192673148265695757522828792546112184190157670775661741020190770516912e-4270588)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4023533642151731445326576999699563877739832531592590216076808854373945772374572855320821690142966099e-4815053)), SC_(0.9318118105062591002929457015325712659659543801643169834185264964234249069692069364865148866469370692), SC_(1) }}, 
      {{ SC_(246209.65625), SC_(1), SC_(0.3795461409907903896345422567793322831580321819313465092025723355362953841755017486543011371443499473), SC_(1), SC_(0.1494177527177717178022651459992286345909806690553400632385568861175245603174043469215394922999027597e-5), SC_(BOOST_MATH_SMALL_CONSTANT(0.3936748041429758848717153565348260765290237773916575292463198233814160246751477180472839298294153066e-1220467)) }}, 
      {{ SC_(246209.65625), SC_(123104.828125), SC_(0.3795461409907903896345422567793322831580321819313465092025723355362953841755017486543011371443499473), SC_(1), SC_(0.1099880225198186642903575602493957065333235204076062878495498226949140924550581413780754772537288714), SC_(BOOST_MATH_SMALL_CONSTANT(0.2897882777379825906774307898713470531328730940467466937976093354792190803827781885124627244219939374e-20655)) }}, 
      {{ SC_(246209.65625), SC_(246207.65625), SC_(0.1902816646704517630357467941804100090646746413808322194033944591897791683237366858242769223987429451), SC_(0.501340006181406305362208182086691817029256585472066242900372017261364294652322499081532560989068282), SC_(0.1892644763203386265987954625989222740933575405505142897991778763465162158517650628300242147456070023), SC_(0.498659993818593694637791817913308182970743414527933757099627982738635705347677500918467439010931718) }}, 
      {{ SC_(246209.65625), SC_(246209.65625), SC_(0.1896713517815713127245493484616099274345676239686359608007363708235397890202647710003825319379093487), SC_(0.4997319990830143882908170503627598371539437356320335970815080360238724867210261514858758596804507521), SC_(0.1898747892092190769099929083177223557234645579627105484018359647127555951552369776539186052064405986), SC_(0.5002680009169856117091829496372401628460562643679664029184919639761275132789738485141241403195492479) }}, 
      {{ SC_(246209.65625), SC_(246211.65625), SC_(0.1890610438503187682368919983483183956151051384043983286737369622166833408570431154485100095513248129), SC_(0.4981240050466124914099774918899995777543692453345887329244388038491507106647647777524494210424240252), SC_(0.1904850971404716213976502584310138875429270435269481805288353733196120433184586332057911275930251345), SC_(0.5018759949533875085900225081100004222456307546654112670755611961508492893352352222475505789575759748) }}, 
      {{ SC_(246209.65625), SC_(492419.3125), SC_(0.3028106368525605792533815094012307413502326516792414546986435189331818430898812546597463686315212235), SC_(BOOST_MATH_SMALL_CONSTANT(0.7978229894844543239003397587270469382229335073444162983048262954417740318171509197684583742725146624e-32814)), SC_(0.3795461409907903896345422567793322831580321819313465092025723355362953841755017486543011371443499473), SC_(1) }}, 
      {{ SC_(246209.65625), SC_(24620966), SC_(BOOST_MATH_SMALL_CONSTANT(0.4218795130057598537892994786340712622578174601909957638667112927337404423218835974564954011299333039e-8872946)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1111536826338056944878094416758566250614970740769053202708092623400624092701546619232542474200597198e-10093407)), SC_(0.3795461409907903896345422567793322831580321819313465092025723355362953841755017486543011371443499473), SC_(1) }}, 
      {{ SC_(513669.1875), SC_(1), SC_(0.1026762455478787231848021279669200901989201648818956533640028599511278074166334792418412467632444988), SC_(1), SC_(0.7161810875625776919149453032960193795284794690428570619324428055126959546925115687394362341113623494e-6), SC_(BOOST_MATH_SMALL_CONSTANT(0.6975139027932385209985700478995386866834770542910755702232497033765481032627476632277947185763659989e-2710322)) }}, 
      {{ SC_(513669.1875), SC_(256834.59375), SC_(0.1026762455478787231848021279669200901989201648818956533640028599511278074166334792418412467632444988), SC_(1), SC_(0.1179256191243649493831993743640418317298811821795430361888926604340800596592353697112775763521543988), SC_(BOOST_MATH_SMALL_CONSTANT(0.1148519002570807149221546626327644677390044371986909218318793705480156216422385159554639234488107623e-43090)) }}, 
      {{ SC_(513669.1875), SC_(513667.1875), SC_(0.5143337766625515754329179034524882655009493028013958771386522493338908966015454144364713090116144692), SC_(0.5009277208355985110675899414981370183301000099671155624683102665494895878885434589591042983062216035), SC_(0.5124286788162356564151033762167126364882523460175606565013763501773871775647893779819411586208305185), SC_(0.4990722791644014889324100585018629816698999900328844375316897334505104121114565410408957016937783965) }}, 
      {{ SC_(513669.1875), SC_(513669.1875), SC_(0.513190718063553564130040168577537778516363342785796579467535763268909112927188480469216134219027671), SC_(0.4998144559388361978364898291206210101144861575499062946445741052920369397398298507664833795665274182), SC_(0.5135717374152336677179811110916631234728383060331599541724928362423689612391463119491963334134173167), SC_(0.5001855440611638021635101708793789898855138424500937053554258947079630602601701492335166204334725818) }}, 
      {{ SC_(513669.1875), SC_(513671.1875), SC_(0.5120476639151014538416521123801457361015160733924052036088039434031905274122651457869413162280154569), SC_(0.4987011953766167745079679008028061016888578219761375469627524901736850480086714928528588625770267132), SC_(0.5147147915636857780063691672890551658876855754265513300312246561080875467540696466314711514044295309), SC_(0.5012988046233832254920320991971938983111421780238624530372475098263149519913285071471411374229732868) }}, 
      {{ SC_(513669.1875), SC_(1027338.375), SC_(0.7882562004488893531792380896763559346521793801402340843242125104839381998149118866123437196614608104), SC_(BOOST_MATH_SMALL_CONSTANT(0.7677103854380022328284291764195301824754129513473442461734939397474939700912174426752498922553981473e-68457)), SC_(0.1026762455478787231848021279669200901989201648818956533640028599511278074166334792418412467632444988), SC_(1) }}, 
      {{ SC_(513669.1875), SC_(51366920), SC_(BOOST_MATH_SMALL_CONSTANT(0.8455141442594780273582857781742586590386122698859368213816566938022783163150883258176324338235587287e-18347637)), SC_(BOOST_MATH_SMALL_CONSTANT(0.8234759069615652019245476397172569750885541471334500479714655987220876801411179354025002722103325368e-21057953)), SC_(0.1026762455478787231848021279669200901989201648818956533640028599511278074166334792418412467632444988), SC_(1) }}, 
      {{ SC_(788352.3125), SC_(1), SC_(0.3254350252275514924133907801285120979971963169854519087242435548802716922496825809327006216635954494), SC_(1), SC_(0.4666440397038730095030131088923330001395921365337505093937538015695853474965515882892883491065022498e-6), SC_(BOOST_MATH_SMALL_CONSTANT(0.1433908471829622508376220400714432285652733465995812102127318484064704211691023381454450301792300023e-4306319)) }}, 
      {{ SC_(788352.3125), SC_(394176.15625), SC_(0.3254350252275514924133907801285120979971963169854519087242435548802716922496825809327006216635954494), SC_(1), SC_(0.2006257520633973004844236201403980302780110902909388684784270381180202010418543872474966575049005566), SC_(BOOST_MATH_SMALL_CONSTANT(0.6164848172783960800240480360461358265727377175617248578986815365384881763390067655148178076072402911e-66132)) }}, 
      {{ SC_(788352.3125), SC_(788350.3125), SC_(0.162961216861866486196123635890099179907765436181771479621640418745608625572387287597608545912315394), SC_(0.5007488568506734531584407973208886646226494394047062415392632213315407911442369980288546641886893887), SC_(0.1624738083656850062172671442384129180894308808036804291026031361346630666772952933350920757512800554), SC_(0.4992511431493265468415592026791113353773505605952937584607367786684592088557630019711453358113106113) }}, 
      {{ SC_(788352.3125), SC_(788352.3125), SC_(0.1626687717822932899593035312904247710866671194963517534486901004447793852560311314241268483442598936), SC_(0.4998502286855928443434206403315169955579486533591805378314370596112904256380207126657714482687295139), SC_(0.1627662534452582024540872488380873269105291974891001552755534544354923069936514495085737733193355558), SC_(0.5001497713144071556565793596684830044420513466408194621685629403887095743619792873342285517312704861) }}, 
      {{ SC_(788352.3125), SC_(788354.3125), SC_(0.1623763274446328985015387393773169322760017933096679464665287143383813538555079409462603516012733209), SC_(0.4989516028002693214791004285569604766689865869988938477436476252444986636812350914588652370815612146), SC_(0.1630586977829185939118520407511951657211945236757839622577148405418903383941746399864402700623221286), SC_(0.5010483971997306785208995714430395233310134130011061522563523747555013363187649085411347629184387854) }}, 
      {{ SC_(788352.3125), SC_(1576704.625), SC_(0.62966881391456604663265189232296651965212021691993178179931323658375951801607008550560163062833006), SC_(BOOST_MATH_SMALL_CONSTANT(0.1934852628337369167484390536774609470572595166386051921886173923840391906771189648683653522231175771e-105062)), SC_(0.3254350252275514924133907801285120979971963169854519087242435548802716922496825809327006216635954494), SC_(1) }}, 
      {{ SC_(788352.3125), SC_(78835232), SC_(BOOST_MATH_SMALL_CONSTANT(0.4164740077948943840500786922849307561907212018086545639004814350805550398839532201156819761152062039e-28012316)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1279745496059271390694582975257723346837265207507390129414161314216004095755396957400977650588924393e-32318629)), SC_(0.3254350252275514924133907801285120979971963169854519087242435548802716922496825809327006216635954494), SC_(1) }}, 
      {{ SC_(1736170), SC_(1), SC_(0.1262281517971042004488252985099758947734405887636182671673445904506523435537050416445084616475212426), SC_(1), SC_(0.2118914928047443977144200433110895948573532788053230331876929560838004923241637943455403176192920957e-6), SC_(BOOST_MATH_SMALL_CONSTANT(0.1678638954845296242754981240024346426980228514280855063671268705695352948287648087179192945942541815e-10078987)) }}, 
      {{ SC_(1736170), SC_(868085), SC_(0.1262281517971042004488252985099758947734405887636182671673445904506523435537050416445084616475212426), SC_(1), SC_(0.1448940961583454163407547513975813077281954384418820421315934004081116003090269523192520567562712675), SC_(BOOST_MATH_SMALL_CONSTANT(0.1147874654706537747553860317681134464810452807999399860509102977323900833593912850990760752412482674e-145637)) }}, 
      {{ SC_(1736170), SC_(1736168), SC_(0.6317777290022475594523330311129906002358832226132013915031845078518775760353610272181933223363237277), SC_(0.500504618033028326360191641057343755999405997498206839871815176619438983969420893139030447209664989), SC_(0.6305037889687944450359199539867683474985226650229812801702613966546458595016893892268912941388886983), SC_(0.499495381966971673639808358942656244000594002501793160128184823380561016030579106860969552790335011) }}, 
      {{ SC_(1736170), SC_(1736170), SC_(0.6310133650036994505936467834743236622047002119530026486269595591827934240774463130132409395432514033), SC_(0.49989907641044580817879562048675209725080620507540160516376663057508236554638837205467803575236936), SC_(0.6312681529673425538946062016254352855297056756831800230464863453237300114596041034318436769319610226), SC_(0.50010092358955419182120437951324790274919379492459839483623336942491763445361162794532196424763064) }}, 
      {{ SC_(1736170), SC_(1736172), SC_(0.63024900188566778658967343804876836928228054774250423301619921925975649543556103050219224039778483), SC_(0.4992935354854227744062593568501916692180042004614849112072827608836331168589189268904245367712978671), SC_(0.632032516085374217898579547050990578452125339893678438657246685246766940101489385942892376077427596), SC_(0.5007064645145772255937406431498083307819957995385150887927172391163668831410810731095754632287021329) }}, 
      {{ SC_(1736170), SC_(3472340), SC_(0.6014445720839096678691921265326588051367345601002845203175453094832083718879547519600219908634900144), SC_(BOOST_MATH_SMALL_CONSTANT(0.4764741965410820548147263974496875110171884751124591798801059384427379413001614590138374358389181743e-231373)), SC_(0.1262281517971042004488252985099758947734405887636182671673445904506523435537050416445084616475212426), SC_(1) }}, 
      {{ SC_(1736170), SC_(173616992), SC_(BOOST_MATH_SMALL_CONSTANT(0.1028718049106474382663595835099645962497203244264180111334446299544683261400046764833876858973945412e-61095576)), SC_(BOOST_MATH_SMALL_CONSTANT(0.8149672117199407490039815813486797316083480325648451121983304934903758539219857770713382104685664004e-71174558)), SC_(0.1262281517971042004488252985099758947734405887636182671673445904506523435537050416445084616475212426), SC_(1) }}
   } };

