/* icon-button.c generated by valac 0.19.0, the Vala compiler
 * generated from icon-button.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define XNP_TYPE_ICON_BUTTON (xnp_icon_button_get_type ())
#define XNP_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButton))
#define XNP_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))
#define XNP_IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_ICON_BUTTON))
#define XNP_IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_ICON_BUTTON))
#define XNP_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))

typedef struct _XnpIconButton XnpIconButton;
typedef struct _XnpIconButtonClass XnpIconButtonClass;
typedef struct _XnpIconButtonPrivate XnpIconButtonPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define XNP_TYPE_TITLE_BAR_BUTTON_TYPE (xnp_title_bar_button_type_get_type ())

#define XNP_TYPE_TITLE_BAR_BUTTON (xnp_title_bar_button_get_type ())
#define XNP_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton))
#define XNP_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))
#define XNP_IS_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_IS_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_TITLE_BAR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))

typedef struct _XnpTitleBarButton XnpTitleBarButton;
typedef struct _XnpTitleBarButtonClass XnpTitleBarButtonClass;
typedef struct _XnpTitleBarButtonPrivate XnpTitleBarButtonPrivate;

struct _XnpIconButton {
	GtkEventBox parent_instance;
	XnpIconButtonPrivate * priv;
	gboolean active;
};

struct _XnpIconButtonClass {
	GtkEventBoxClass parent_class;
	void (*draw_icon) (XnpIconButton* self, cairo_t* cr, gint width, gint height);
};

typedef enum  {
	XNP_TITLE_BAR_BUTTON_TYPE_EMPTY,
	XNP_TITLE_BAR_BUTTON_TYPE_CLOSE,
	XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_REFRESH
} XnpTitleBarButtonType;

struct _XnpTitleBarButton {
	XnpIconButton parent_instance;
	XnpTitleBarButtonPrivate * priv;
};

struct _XnpTitleBarButtonClass {
	XnpIconButtonClass parent_class;
};

struct _XnpTitleBarButtonPrivate {
	XnpTitleBarButtonType _icon_type;
};


static gpointer xnp_icon_button_parent_class = NULL;
static gpointer xnp_title_bar_button_parent_class = NULL;

#define M_PI 3.14159265358979323846
GType xnp_icon_button_get_type (void) G_GNUC_CONST;
enum  {
	XNP_ICON_BUTTON_DUMMY_PROPERTY
};
void xnp_icon_button_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height);
static void xnp_icon_button_real_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height);
void xnp_icon_button_set_widget_source_color (XnpIconButton* self, cairo_t* cr);
static void xnp_icon_button_real_add (GtkContainer* base, GtkWidget* widget);
static gboolean xnp_icon_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static gboolean xnp_icon_button_on_enter_notify_event (XnpIconButton* self, GdkEventCrossing* event);
static gboolean xnp_icon_button_on_leave_notify_event (XnpIconButton* self, GdkEventCrossing* event);
static gboolean xnp_icon_button_on_button_release_event (XnpIconButton* self, GdkEventButton* event);
XnpIconButton* xnp_icon_button_construct (GType object_type);
static GObject * xnp_icon_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void xnp_icon_button_finalize (GObject* obj);
GType xnp_title_bar_button_type_get_type (void) G_GNUC_CONST;
GType xnp_title_bar_button_get_type (void) G_GNUC_CONST;
#define XNP_TITLE_BAR_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonPrivate))
enum  {
	XNP_TITLE_BAR_BUTTON_DUMMY_PROPERTY,
	XNP_TITLE_BAR_BUTTON_ICON_TYPE
};
XnpTitleBarButton* xnp_title_bar_button_new (XnpTitleBarButtonType icon_type);
XnpTitleBarButton* xnp_title_bar_button_construct (GType object_type, XnpTitleBarButtonType icon_type);
static void xnp_title_bar_button_real_draw_icon (XnpIconButton* base, cairo_t* cr, gint width, gint height);
XnpTitleBarButtonType xnp_title_bar_button_get_icon_type (XnpTitleBarButton* self);
static void xnp_title_bar_button_draw_close_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height);
static void xnp_title_bar_button_draw_left_arrow_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height);
static void xnp_title_bar_button_draw_right_arrow_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height);
static void xnp_title_bar_button_draw_refresh_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height);
void xnp_title_bar_button_set_icon_type (XnpTitleBarButton* self, XnpTitleBarButtonType value);
static void xnp_title_bar_button_finalize (GObject* obj);
static void _vala_xnp_title_bar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_xnp_title_bar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void xnp_icon_button_real_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height) {
	g_critical ("Type `%s' does not implement abstract method `xnp_icon_button_draw_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void xnp_icon_button_draw_icon (XnpIconButton* self, cairo_t* cr, gint width, gint height) {
	g_return_if_fail (self != NULL);
	XNP_ICON_BUTTON_GET_CLASS (self)->draw_icon (self, cr, width, height);
}


void xnp_icon_button_set_widget_source_color (XnpIconButton* self, cairo_t* cr) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->active;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		cairo_t* _tmp5_;
		GtkStyle* _tmp6_;
		GtkStyle* _tmp7_;
		GdkColor* _tmp8_;
		gint _tmp8__length1;
		GdkColor _tmp9_;
		_tmp5_ = cr;
		_tmp6_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->base;
		_tmp8__length1 = -1;
		_tmp9_ = _tmp8_[GTK_STATE_NORMAL];
		gdk_cairo_set_source_color (_tmp5_, &_tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp14_;
		_tmp11_ = gtk_widget_get_sensitive ((GtkWidget*) self);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			gboolean _tmp13_;
			_tmp13_ = self->active;
			_tmp10_ = !_tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp14_ = _tmp10_;
		if (_tmp14_) {
			cairo_t* _tmp15_;
			GtkStyle* _tmp16_;
			GtkStyle* _tmp17_;
			GdkColor* _tmp18_;
			gint _tmp18__length1;
			GdkColor _tmp19_;
			_tmp15_ = cr;
			_tmp16_ = gtk_widget_get_style ((GtkWidget*) self);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_->fg;
			_tmp18__length1 = -1;
			_tmp19_ = _tmp18_[GTK_STATE_INSENSITIVE];
			gdk_cairo_set_source_color (_tmp15_, &_tmp19_);
		} else {
			gboolean _tmp20_;
			gboolean _tmp21_;
			_tmp20_ = gtk_widget_get_sensitive ((GtkWidget*) self);
			_tmp21_ = _tmp20_;
			if (!_tmp21_) {
				cairo_t* _tmp22_;
				GtkStyle* _tmp23_;
				GtkStyle* _tmp24_;
				GdkColor* _tmp25_;
				gint _tmp25__length1;
				GdkColor _tmp26_;
				_tmp22_ = cr;
				_tmp23_ = gtk_widget_get_style ((GtkWidget*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_->text;
				_tmp25__length1 = -1;
				_tmp26_ = _tmp25_[GTK_STATE_INSENSITIVE];
				gdk_cairo_set_source_color (_tmp22_, &_tmp26_);
			}
		}
	}
}


static void xnp_icon_button_real_add (GtkContainer* base, GtkWidget* widget) {
	XnpIconButton * self;
	self = (XnpIconButton*) base;
	g_return_if_fail (widget != NULL);
	g_warning ("icon-button.vala:67: This object doesn't allow packing child widgets.");
}


static gboolean xnp_icon_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	XnpIconButton * self;
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	gint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gint width;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	gint height;
	GtkAllocation _tmp9_;
	gint _tmp10_;
	GtkAllocation _tmp11_;
	gint _tmp12_;
	gint x;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	GtkAllocation _tmp15_;
	gint _tmp16_;
	gint y;
	GdkWindow* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* cr;
	cairo_surface_t* _tmp19_;
	cairo_surface_t* surface;
	cairo_t* _tmp20_;
	cairo_t* cr_;
	self = (XnpIconButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = allocation;
	_tmp2_ = _tmp1_.width;
	_tmp3_ = gtk_container_get_border_width ((GtkContainer*) self);
	_tmp4_ = _tmp3_;
	width = _tmp2_ - (((gint) _tmp4_) * 2);
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.height;
	_tmp7_ = gtk_container_get_border_width ((GtkContainer*) self);
	_tmp8_ = _tmp7_;
	height = _tmp6_ - (((gint) _tmp8_) * 2);
	_tmp9_ = allocation;
	_tmp10_ = _tmp9_.width;
	_tmp11_ = allocation;
	_tmp12_ = _tmp11_.x;
	x = ((_tmp10_ / 2) - (width / 2)) + _tmp12_;
	_tmp13_ = allocation;
	_tmp14_ = _tmp13_.height;
	_tmp15_ = allocation;
	_tmp16_ = _tmp15_.y;
	y = ((_tmp14_ / 2) - (height / 2)) + _tmp16_;
	_tmp17_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp18_ = gdk_cairo_create ((GdkDrawable*) _tmp17_);
	cr = _tmp18_;
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) width, (gdouble) height);
	cairo_clip (cr);
	_tmp19_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	surface = _tmp19_;
	_tmp20_ = cairo_create (surface);
	cr_ = _tmp20_;
	xnp_icon_button_draw_icon (self, cr_, width, height);
	cairo_set_source_surface (cr, surface, (gdouble) x, (gdouble) y);
	cairo_paint (cr);
	result = FALSE;
	_cairo_destroy0 (cr_);
	_cairo_surface_destroy0 (surface);
	_cairo_destroy0 (cr);
	return result;
}


static gboolean xnp_icon_button_on_enter_notify_event (XnpIconButton* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkWindow* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->active = TRUE;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_invalidate_rect (_tmp0_, NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean xnp_icon_button_on_leave_notify_event (XnpIconButton* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	GdkWindow* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->active = FALSE;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_invalidate_rect (_tmp0_, NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean xnp_icon_button_on_button_release_event (XnpIconButton* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	guint _tmp1_;
	GdkEventButton _tmp2_;
	gdouble _tmp3_;
	gint cur_x;
	GdkEventButton _tmp4_;
	gdouble _tmp5_;
	gint cur_y;
	gint width = 0;
	gint height = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	gboolean _tmp14_;
	gboolean _tmp16_;
	gboolean _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.x;
	cur_x = (gint) _tmp3_;
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.y;
	cur_y = (gint) _tmp5_;
	gtk_widget_get_size_request ((GtkWidget*) self, &_tmp6_, &_tmp7_);
	width = _tmp6_;
	height = _tmp7_;
	_tmp11_ = cur_x;
	if (_tmp11_ >= 0) {
		gint _tmp12_;
		gint _tmp13_;
		_tmp12_ = cur_x;
		_tmp13_ = width;
		_tmp10_ = _tmp12_ < _tmp13_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp14_ = _tmp10_;
	if (_tmp14_) {
		gint _tmp15_;
		_tmp15_ = cur_y;
		_tmp9_ = _tmp15_ >= 0;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp16_ = _tmp9_;
	if (_tmp16_) {
		gint _tmp17_;
		gint _tmp18_;
		_tmp17_ = cur_y;
		_tmp18_ = height;
		_tmp8_ = _tmp17_ < _tmp18_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp19_ = _tmp8_;
	if (_tmp19_) {
		g_signal_emit_by_name (self, "clicked");
	}
	result = FALSE;
	return result;
}


XnpIconButton* xnp_icon_button_construct (GType object_type) {
	XnpIconButton * self = NULL;
	self = (XnpIconButton*) g_object_new (object_type, NULL);
	return self;
}


static gboolean _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = xnp_icon_button_on_enter_notify_event (self, event);
	return result;
}


static gboolean _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = xnp_icon_button_on_leave_notify_event (self, event);
	return result;
}


static gboolean _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xnp_icon_button_on_button_release_event (self, event);
	return result;
}


static GObject * xnp_icon_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XnpIconButton * self;
	parent_class = G_OBJECT_CLASS (xnp_icon_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_ICON_BUTTON, XnpIconButton);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_event_box_set_above_child ((GtkEventBox*) self, TRUE);
	gtk_widget_set_size_request ((GtkWidget*) self, 22, 22);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 2);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) _xnp_icon_button_on_enter_notify_event_gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_icon_button_on_leave_notify_event_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _xnp_icon_button_on_button_release_event_gtk_widget_button_release_event, self, 0);
	return obj;
}


static void xnp_icon_button_class_init (XnpIconButtonClass * klass) {
	xnp_icon_button_parent_class = g_type_class_peek_parent (klass);
	XNP_ICON_BUTTON_CLASS (klass)->draw_icon = xnp_icon_button_real_draw_icon;
	GTK_CONTAINER_CLASS (klass)->add = xnp_icon_button_real_add;
	GTK_WIDGET_CLASS (klass)->expose_event = xnp_icon_button_real_expose_event;
	G_OBJECT_CLASS (klass)->constructor = xnp_icon_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_icon_button_finalize;
	g_signal_new ("clicked", XNP_TYPE_ICON_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void xnp_icon_button_instance_init (XnpIconButton * self) {
	self->active = FALSE;
}


static void xnp_icon_button_finalize (GObject* obj) {
	XnpIconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_ICON_BUTTON, XnpIconButton);
	G_OBJECT_CLASS (xnp_icon_button_parent_class)->finalize (obj);
}


GType xnp_icon_button_get_type (void) {
	static volatile gsize xnp_icon_button_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_icon_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpIconButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_icon_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpIconButton), 0, (GInstanceInitFunc) xnp_icon_button_instance_init, NULL };
		GType xnp_icon_button_type_id;
		xnp_icon_button_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "XnpIconButton", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&xnp_icon_button_type_id__volatile, xnp_icon_button_type_id);
	}
	return xnp_icon_button_type_id__volatile;
}


GType xnp_title_bar_button_type_get_type (void) {
	static volatile gsize xnp_title_bar_button_type_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_title_bar_button_type_type_id__volatile)) {
		static const GEnumValue values[] = {{XNP_TITLE_BAR_BUTTON_TYPE_EMPTY, "XNP_TITLE_BAR_BUTTON_TYPE_EMPTY", "empty"}, {XNP_TITLE_BAR_BUTTON_TYPE_CLOSE, "XNP_TITLE_BAR_BUTTON_TYPE_CLOSE", "close"}, {XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW, "XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW", "left-arrow"}, {XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW, "XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW", "right-arrow"}, {XNP_TITLE_BAR_BUTTON_TYPE_REFRESH, "XNP_TITLE_BAR_BUTTON_TYPE_REFRESH", "refresh"}, {0, NULL, NULL}};
		GType xnp_title_bar_button_type_type_id;
		xnp_title_bar_button_type_type_id = g_enum_register_static ("XnpTitleBarButtonType", values);
		g_once_init_leave (&xnp_title_bar_button_type_type_id__volatile, xnp_title_bar_button_type_type_id);
	}
	return xnp_title_bar_button_type_type_id__volatile;
}


XnpTitleBarButton* xnp_title_bar_button_construct (GType object_type, XnpTitleBarButtonType icon_type) {
	XnpTitleBarButton * self = NULL;
	XnpTitleBarButtonType _tmp0_;
	_tmp0_ = icon_type;
	self = (XnpTitleBarButton*) g_object_new (object_type, "icon-type", _tmp0_, NULL);
	return self;
}


XnpTitleBarButton* xnp_title_bar_button_new (XnpTitleBarButtonType icon_type) {
	return xnp_title_bar_button_construct (XNP_TYPE_TITLE_BAR_BUTTON, icon_type);
}


static void xnp_title_bar_button_real_draw_icon (XnpIconButton* base, cairo_t* cr, gint width, gint height) {
	XnpTitleBarButton * self;
	XnpTitleBarButtonType _tmp0_;
	self = (XnpTitleBarButton*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_icon_type;
	switch (_tmp0_) {
		case XNP_TITLE_BAR_BUTTON_TYPE_CLOSE:
		{
			cairo_t* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			_tmp1_ = cr;
			_tmp2_ = width;
			_tmp3_ = height;
			xnp_title_bar_button_draw_close_button (self, _tmp1_, _tmp2_, _tmp3_);
			break;
		}
		case XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW:
		{
			cairo_t* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			_tmp4_ = cr;
			_tmp5_ = width;
			_tmp6_ = height;
			xnp_title_bar_button_draw_left_arrow_button (self, _tmp4_, _tmp5_, _tmp6_);
			break;
		}
		case XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW:
		{
			cairo_t* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp7_ = cr;
			_tmp8_ = width;
			_tmp9_ = height;
			xnp_title_bar_button_draw_right_arrow_button (self, _tmp7_, _tmp8_, _tmp9_);
			break;
		}
		case XNP_TITLE_BAR_BUTTON_TYPE_REFRESH:
		{
			cairo_t* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = cr;
			_tmp11_ = width;
			_tmp12_ = height;
			xnp_title_bar_button_draw_refresh_button (self, _tmp10_, _tmp11_, _tmp12_);
			break;
		}
		default:
		{
			break;
		}
	}
}


static void xnp_title_bar_button_draw_left_arrow_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height) {
	gint border;
	gint _tmp0_;
	gint x1;
	gint _tmp1_;
	gint _tmp2_;
	gint x2;
	gint _tmp3_;
	gint y1;
	gint _tmp4_;
	gint _tmp5_;
	gint y2;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp11_;
	cairo_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 4;
	_tmp0_ = border;
	x1 = _tmp0_;
	_tmp1_ = width;
	_tmp2_ = border;
	x2 = _tmp1_ - _tmp2_;
	_tmp3_ = border;
	y1 = _tmp3_;
	_tmp4_ = height;
	_tmp5_ = border;
	y2 = _tmp4_ - _tmp5_;
	_tmp7_ = x2;
	_tmp8_ = x1;
	if (_tmp7_ <= _tmp8_) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = y2;
		_tmp10_ = y1;
		_tmp6_ = _tmp9_ <= _tmp10_;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = cr;
	cairo_set_line_cap (_tmp12_, CAIRO_LINE_CAP_ROUND);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				gint _tmp17_;
				cairo_t* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				cairo_t* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				cairo_t* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				cairo_t* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				cairo_t* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				cairo_t* _tmp40_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < 2)) {
					break;
				}
				_tmp17_ = i;
				if (_tmp17_ == 0) {
					gdouble _tmp18_ = 0.0;
					gboolean _tmp19_;
					cairo_t* _tmp20_;
					gdouble _tmp21_;
					cairo_t* _tmp22_;
					_tmp19_ = ((XnpIconButton*) self)->active;
					if (_tmp19_) {
						_tmp18_ = 0.4;
					} else {
						_tmp18_ = 0.2;
					}
					_tmp20_ = cr;
					_tmp21_ = _tmp18_;
					cairo_set_source_rgba (_tmp20_, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp21_);
					_tmp22_ = cr;
					cairo_set_line_width (_tmp22_, (gdouble) 4);
				} else {
					cairo_t* _tmp23_;
					cairo_t* _tmp24_;
					_tmp23_ = cr;
					xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, _tmp23_);
					_tmp24_ = cr;
					cairo_set_line_width (_tmp24_, 2.66);
				}
				_tmp25_ = cr;
				_tmp26_ = x1;
				_tmp27_ = height;
				cairo_move_to (_tmp25_, (gdouble) _tmp26_, (gdouble) (_tmp27_ / 2));
				_tmp28_ = cr;
				_tmp29_ = x2;
				_tmp30_ = height;
				cairo_line_to (_tmp28_, (gdouble) _tmp29_, (gdouble) (_tmp30_ / 2));
				_tmp31_ = cr;
				_tmp32_ = width;
				_tmp33_ = y1;
				cairo_move_to (_tmp31_, (gdouble) (_tmp32_ / 2), (gdouble) _tmp33_);
				_tmp34_ = cr;
				_tmp35_ = x1;
				_tmp36_ = height;
				cairo_line_to (_tmp34_, (gdouble) _tmp35_, (gdouble) (_tmp36_ / 2));
				_tmp37_ = cr;
				_tmp38_ = width;
				_tmp39_ = y2;
				cairo_line_to (_tmp37_, (gdouble) (_tmp38_ / 2), (gdouble) _tmp39_);
				_tmp40_ = cr;
				cairo_stroke (_tmp40_);
			}
		}
	}
}


static void xnp_title_bar_button_draw_right_arrow_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height) {
	gint border;
	gint _tmp0_;
	gint x1;
	gint _tmp1_;
	gint _tmp2_;
	gint x2;
	gint _tmp3_;
	gint y1;
	gint _tmp4_;
	gint _tmp5_;
	gint y2;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp11_;
	cairo_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 4;
	_tmp0_ = border;
	x1 = _tmp0_;
	_tmp1_ = width;
	_tmp2_ = border;
	x2 = _tmp1_ - _tmp2_;
	_tmp3_ = border;
	y1 = _tmp3_;
	_tmp4_ = height;
	_tmp5_ = border;
	y2 = _tmp4_ - _tmp5_;
	_tmp7_ = x2;
	_tmp8_ = x1;
	if (_tmp7_ <= _tmp8_) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = y2;
		_tmp10_ = y1;
		_tmp6_ = _tmp9_ <= _tmp10_;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = cr;
	cairo_set_line_cap (_tmp12_, CAIRO_LINE_CAP_ROUND);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				gint _tmp17_;
				cairo_t* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				cairo_t* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				cairo_t* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				cairo_t* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				cairo_t* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				cairo_t* _tmp40_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < 2)) {
					break;
				}
				_tmp17_ = i;
				if (_tmp17_ == 0) {
					gdouble _tmp18_ = 0.0;
					gboolean _tmp19_;
					cairo_t* _tmp20_;
					gdouble _tmp21_;
					cairo_t* _tmp22_;
					_tmp19_ = ((XnpIconButton*) self)->active;
					if (_tmp19_) {
						_tmp18_ = 0.4;
					} else {
						_tmp18_ = 0.2;
					}
					_tmp20_ = cr;
					_tmp21_ = _tmp18_;
					cairo_set_source_rgba (_tmp20_, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp21_);
					_tmp22_ = cr;
					cairo_set_line_width (_tmp22_, (gdouble) 4);
				} else {
					cairo_t* _tmp23_;
					cairo_t* _tmp24_;
					_tmp23_ = cr;
					xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, _tmp23_);
					_tmp24_ = cr;
					cairo_set_line_width (_tmp24_, 2.66);
				}
				_tmp25_ = cr;
				_tmp26_ = x1;
				_tmp27_ = height;
				cairo_move_to (_tmp25_, (gdouble) _tmp26_, (gdouble) (_tmp27_ / 2));
				_tmp28_ = cr;
				_tmp29_ = x2;
				_tmp30_ = height;
				cairo_line_to (_tmp28_, (gdouble) _tmp29_, (gdouble) (_tmp30_ / 2));
				_tmp31_ = cr;
				_tmp32_ = width;
				_tmp33_ = y1;
				cairo_move_to (_tmp31_, (gdouble) (_tmp32_ / 2), (gdouble) _tmp33_);
				_tmp34_ = cr;
				_tmp35_ = x2;
				_tmp36_ = height;
				cairo_line_to (_tmp34_, (gdouble) _tmp35_, (gdouble) (_tmp36_ / 2));
				_tmp37_ = cr;
				_tmp38_ = width;
				_tmp39_ = y2;
				cairo_line_to (_tmp37_, (gdouble) (_tmp38_ / 2), (gdouble) _tmp39_);
				_tmp40_ = cr;
				cairo_stroke (_tmp40_);
			}
		}
	}
}


static void xnp_title_bar_button_draw_close_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height) {
	gint border;
	gint _tmp0_;
	gint x1;
	gint _tmp1_;
	gint _tmp2_;
	gint x2;
	gint _tmp3_;
	gint y1;
	gint _tmp4_;
	gint _tmp5_;
	gint y2;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp11_;
	cairo_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 4;
	_tmp0_ = border;
	x1 = _tmp0_;
	_tmp1_ = width;
	_tmp2_ = border;
	x2 = _tmp1_ - _tmp2_;
	_tmp3_ = border;
	y1 = _tmp3_;
	_tmp4_ = height;
	_tmp5_ = border;
	y2 = _tmp4_ - _tmp5_;
	_tmp7_ = x2;
	_tmp8_ = x1;
	if (_tmp7_ <= _tmp8_) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = y2;
		_tmp10_ = y1;
		_tmp6_ = _tmp9_ <= _tmp10_;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = cr;
	cairo_set_line_cap (_tmp12_, CAIRO_LINE_CAP_ROUND);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				gint _tmp17_;
				cairo_t* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				cairo_t* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				cairo_t* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				cairo_t* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				cairo_t* _tmp37_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < 2)) {
					break;
				}
				_tmp17_ = i;
				if (_tmp17_ == 0) {
					gdouble _tmp18_ = 0.0;
					gboolean _tmp19_;
					cairo_t* _tmp20_;
					gdouble _tmp21_;
					cairo_t* _tmp22_;
					_tmp19_ = ((XnpIconButton*) self)->active;
					if (_tmp19_) {
						_tmp18_ = 0.4;
					} else {
						_tmp18_ = 0.2;
					}
					_tmp20_ = cr;
					_tmp21_ = _tmp18_;
					cairo_set_source_rgba (_tmp20_, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp21_);
					_tmp22_ = cr;
					cairo_set_line_width (_tmp22_, (gdouble) 4);
				} else {
					cairo_t* _tmp23_;
					cairo_t* _tmp24_;
					_tmp23_ = cr;
					xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, _tmp23_);
					_tmp24_ = cr;
					cairo_set_line_width (_tmp24_, 2.66);
				}
				_tmp25_ = cr;
				_tmp26_ = x1;
				_tmp27_ = y1;
				cairo_move_to (_tmp25_, (gdouble) _tmp26_, (gdouble) _tmp27_);
				_tmp28_ = cr;
				_tmp29_ = x2;
				_tmp30_ = y2;
				cairo_line_to (_tmp28_, (gdouble) _tmp29_, (gdouble) _tmp30_);
				_tmp31_ = cr;
				_tmp32_ = x2;
				_tmp33_ = y1;
				cairo_move_to (_tmp31_, (gdouble) _tmp32_, (gdouble) _tmp33_);
				_tmp34_ = cr;
				_tmp35_ = x1;
				_tmp36_ = y2;
				cairo_line_to (_tmp34_, (gdouble) _tmp35_, (gdouble) _tmp36_);
				_tmp37_ = cr;
				cairo_stroke (_tmp37_);
			}
		}
	}
}


static void xnp_title_bar_button_draw_refresh_button (XnpTitleBarButton* self, cairo_t* cr, gint width, gint height) {
	gint border;
	gint _tmp0_;
	gint x1;
	gint _tmp1_;
	gint _tmp2_;
	gint x2;
	gint _tmp3_;
	gint y1;
	gint _tmp4_;
	gint _tmp5_;
	gint y2;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp11_;
	cairo_t* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	border = 6;
	_tmp0_ = border;
	x1 = _tmp0_;
	_tmp1_ = width;
	_tmp2_ = border;
	x2 = _tmp1_ - _tmp2_;
	_tmp3_ = border;
	y1 = _tmp3_;
	_tmp4_ = height;
	_tmp5_ = border;
	y2 = _tmp4_ - _tmp5_;
	_tmp7_ = x2;
	_tmp8_ = x1;
	if (_tmp7_ <= _tmp8_) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = y2;
		_tmp10_ = y1;
		_tmp6_ = _tmp9_ <= _tmp10_;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = cr;
	cairo_set_line_cap (_tmp12_, CAIRO_LINE_CAP_ROUND);
	{
		gint j;
		j = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = j;
					j = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = j;
				if (!(_tmp16_ < 2)) {
					break;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp17_;
						_tmp17_ = TRUE;
						while (TRUE) {
							gboolean _tmp18_;
							gint _tmp20_;
							gint _tmp21_;
							cairo_t* _tmp29_;
							cairo_t* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							cairo_t* _tmp40_;
							gint _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							gdouble r;
							cairo_t* _tmp45_;
							gdouble _tmp46_;
							gdouble _tmp47_;
							cairo_t* _tmp48_;
							gdouble _tmp49_;
							cairo_t* _tmp50_;
							gdouble _tmp51_;
							gdouble _tmp52_;
							cairo_t* _tmp53_;
							cairo_t* _tmp54_;
							_tmp18_ = _tmp17_;
							if (!_tmp18_) {
								gint _tmp19_;
								_tmp19_ = i;
								i = _tmp19_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp20_ = i;
							if (!(_tmp20_ < 2)) {
								break;
							}
							_tmp21_ = i;
							if (_tmp21_ == 0) {
								gdouble _tmp22_ = 0.0;
								gboolean _tmp23_;
								cairo_t* _tmp24_;
								gdouble _tmp25_;
								cairo_t* _tmp26_;
								_tmp23_ = ((XnpIconButton*) self)->active;
								if (_tmp23_) {
									_tmp22_ = 0.4;
								} else {
									_tmp22_ = 0.2;
								}
								_tmp24_ = cr;
								_tmp25_ = _tmp22_;
								cairo_set_source_rgba (_tmp24_, (gdouble) 1, (gdouble) 1, (gdouble) 1, _tmp25_);
								_tmp26_ = cr;
								cairo_set_line_width (_tmp26_, (gdouble) 4);
							} else {
								cairo_t* _tmp27_;
								cairo_t* _tmp28_;
								_tmp27_ = cr;
								xnp_icon_button_set_widget_source_color ((XnpIconButton*) self, _tmp27_);
								_tmp28_ = cr;
								cairo_set_line_width (_tmp28_, 2.44);
							}
							_tmp29_ = cr;
							cairo_save (_tmp29_);
							_tmp30_ = cr;
							_tmp31_ = x1;
							_tmp32_ = x2;
							_tmp33_ = x1;
							_tmp34_ = y1;
							_tmp35_ = y2;
							_tmp36_ = y1;
							cairo_translate (_tmp30_, (gdouble) (_tmp31_ + ((_tmp32_ - _tmp33_) / 2)), (gdouble) (_tmp34_ + ((_tmp35_ - _tmp36_) / 2)));
							_tmp37_ = j;
							if (_tmp37_ == 0) {
								cairo_t* _tmp38_;
								_tmp38_ = cr;
								cairo_rotate (_tmp38_, (-M_PI) / 16.0);
							} else {
								cairo_t* _tmp39_;
								_tmp39_ = cr;
								cairo_rotate (_tmp39_, (15.0 * M_PI) / 16.0);
							}
							_tmp40_ = cr;
							_tmp41_ = x2;
							_tmp42_ = x1;
							cairo_arc (_tmp40_, (gdouble) 0, (gdouble) 0, (gdouble) (_tmp41_ - _tmp42_), (5.0 * M_PI) / 16.0, M_PI);
							_tmp43_ = x2;
							_tmp44_ = x1;
							r = (_tmp43_ - _tmp44_) / 2.0;
							_tmp45_ = cr;
							_tmp46_ = r;
							_tmp47_ = r;
							cairo_line_to (_tmp45_, (-_tmp46_) * 2.0, (3.0 * _tmp47_) / 2.0);
							_tmp48_ = cr;
							_tmp49_ = r;
							cairo_move_to (_tmp48_, (-_tmp49_) * 2.0, 0.0);
							_tmp50_ = cr;
							_tmp51_ = r;
							_tmp52_ = r;
							cairo_line_to (_tmp50_, -_tmp51_, _tmp52_ / 2.0);
							_tmp53_ = cr;
							cairo_stroke (_tmp53_);
							_tmp54_ = cr;
							cairo_restore (_tmp54_);
						}
					}
				}
			}
		}
	}
}


XnpTitleBarButtonType xnp_title_bar_button_get_icon_type (XnpTitleBarButton* self) {
	XnpTitleBarButtonType result;
	XnpTitleBarButtonType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_icon_type;
	result = _tmp0_;
	return result;
}


void xnp_title_bar_button_set_icon_type (XnpTitleBarButton* self, XnpTitleBarButtonType value) {
	XnpTitleBarButtonType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_icon_type = _tmp0_;
	g_object_notify ((GObject *) self, "icon-type");
}


static void xnp_title_bar_button_class_init (XnpTitleBarButtonClass * klass) {
	xnp_title_bar_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XnpTitleBarButtonPrivate));
	XNP_ICON_BUTTON_CLASS (klass)->draw_icon = xnp_title_bar_button_real_draw_icon;
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_title_bar_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_title_bar_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = xnp_title_bar_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_TITLE_BAR_BUTTON_ICON_TYPE, g_param_spec_enum ("icon-type", "icon-type", "icon-type", XNP_TYPE_TITLE_BAR_BUTTON_TYPE, XNP_TITLE_BAR_BUTTON_TYPE_EMPTY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void xnp_title_bar_button_instance_init (XnpTitleBarButton * self) {
	self->priv = XNP_TITLE_BAR_BUTTON_GET_PRIVATE (self);
	self->priv->_icon_type = XNP_TITLE_BAR_BUTTON_TYPE_EMPTY;
}


static void xnp_title_bar_button_finalize (GObject* obj) {
	XnpTitleBarButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton);
	G_OBJECT_CLASS (xnp_title_bar_button_parent_class)->finalize (obj);
}


GType xnp_title_bar_button_get_type (void) {
	static volatile gsize xnp_title_bar_button_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_title_bar_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XnpTitleBarButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_title_bar_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpTitleBarButton), 0, (GInstanceInitFunc) xnp_title_bar_button_instance_init, NULL };
		GType xnp_title_bar_button_type_id;
		xnp_title_bar_button_type_id = g_type_register_static (XNP_TYPE_ICON_BUTTON, "XnpTitleBarButton", &g_define_type_info, 0);
		g_once_init_leave (&xnp_title_bar_button_type_id__volatile, xnp_title_bar_button_type_id);
	}
	return xnp_title_bar_button_type_id__volatile;
}


static void _vala_xnp_title_bar_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	XnpTitleBarButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton);
	switch (property_id) {
		case XNP_TITLE_BAR_BUTTON_ICON_TYPE:
		g_value_set_enum (value, xnp_title_bar_button_get_icon_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_xnp_title_bar_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	XnpTitleBarButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton);
	switch (property_id) {
		case XNP_TITLE_BAR_BUTTON_ICON_TYPE:
		xnp_title_bar_button_set_icon_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



