/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.treeview.views;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.model.TexOutlineInput;
import net.sourceforge.texlipse.outline.TexOutlinePage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ViewPart;

public class TexOutlineTreeView
extends ViewPart
implements ISelectionChangedListener,
IPartListener {
    private TexOutlinePage outline = new TexOutlinePage(null);

    public void createPartControl(Composite parent) {
        PageSite site = new PageSite(this.getViewSite());
        this.outline.init((IPageSite)site);
        this.outline.createControl(parent);
        ((SubActionBars)site.getActionBars()).activate(true);
        this.outline.switchTreeViewerSelectionChangeListener(this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        IEditorPart part = this.getSite().getPage().getActiveEditor();
        if (part != null && part instanceof TexEditor) {
            TexEditor e = (TexEditor)part;
            e.registerFullOutline(this);
        }
    }

    public void update(TexOutlineInput input) {
        this.outline.update(input);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.outline.getEditor().resetHighlightRange();
        } else {
            OutlineNode node = (OutlineNode)((IStructuredSelection)selection).getFirstElement();
            this.outline.getEditor().resetHighlightRange();
            if (node.getIFile() != null) {
                FileEditorInput input = new FileEditorInput(node.getIFile());
                try {
                    IWorkbenchPage cPage = TexlipsePlugin.getCurrentWorkbenchPage();
                    TexEditor e = (TexEditor)cPage.findEditor((IEditorInput)input);
                    if (e == null) {
                        e = (TexEditor)cPage.openEditor((IEditorInput)input, "net.sourceforge.texlipse.TexEditor");
                    }
                    if (cPage.getActiveEditor() != e) {
                        cPage.activate((IWorkbenchPart)e);
                    }
                    IDocument doc = e.getDocumentProvider().getDocument((Object)e.getEditorInput());
                    int beginOffset = doc.getLineOffset(node.getBeginLine() - 1);
                    int length = node.getEndLine() - 1 == doc.getNumberOfLines() ? doc.getLength() - beginOffset : doc.getLineOffset(node.getEndLine() - 1) - beginOffset;
                    e.setHighlightRange(beginOffset, length, true);
                }
                catch (PartInitException e) {
                    TexlipsePlugin.log("Can't open editor.", e);
                }
                catch (BadLocationException badLocationException) {
                    this.outline.getEditor().resetHighlightRange();
                }
            }
        }
    }

    public boolean isModelDirty() {
        return this.outline.isModelDirty();
    }

    public void projectChanged() {
        this.outline.reset();
    }

    public void modelGotDirty() {
        this.outline.modelGotDirty();
    }

    public TexEditor getEditor() {
        return this.outline.getEditor();
    }

    public void setEditor(TexEditor editor) {
        this.outline.setEditor(editor);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof TexEditor) {
            if (this.outline.getEditor() != null) {
                this.outline.getEditor().unregisterFullOutline(this);
            }
            TexEditor e = (TexEditor)part;
            e.registerFullOutline(this);
            this.setEditor(e);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.outline.getEditor().unregisterFullOutline(this);
    }

    public void setFocus() {
        this.outline.setFocus();
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

