/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class BibColorProvider {
    public static final String SINGLE_LINE_COMMENT = "slc.BibColor";
    public static final String KEYWORD = "key.BibColor";
    public static final String TYPE = "typ.BibColor";
    public static final String STRING = "str.BibColor";
    public static final String DEFAULT = "def.BibColor";
    private static final RGB SINGLE_LINE_COMMENT_DEFAULT_COLOR = new RGB(128, 128, 0);
    private static final RGB KEYWORD_DEFAULT_COLOR = new RGB(255, 127, 0);
    private static final RGB TYPE_DEFAULT_COLOR = new RGB(0, 0, 128);
    private static final RGB STRING_DEFAULT_COLOR = new RGB(0, 128, 0);
    private static final RGB DEFAULT_DEFAULT_COLOR = new RGB(0, 0, 0);
    protected Map fColorTable = new HashMap(6);

    public static void initializeDefaults(IPreferenceStore preferences) {
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)SINGLE_LINE_COMMENT, (RGB)SINGLE_LINE_COMMENT_DEFAULT_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)KEYWORD, (RGB)KEYWORD_DEFAULT_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)TYPE, (RGB)TYPE_DEFAULT_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)STRING, (RGB)STRING_DEFAULT_COLOR);
        PreferenceConverter.setDefault((IPreferenceStore)preferences, (String)DEFAULT, (RGB)DEFAULT_DEFAULT_COLOR);
    }

    public void dispose() {
        Iterator e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }

    public Color getColor(String rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)TexlipsePlugin.getDefault().getPreferenceStore(), (String)rgb));
            this.fColorTable.put(rgb, color);
        }
        return color;
    }
}

