program TexToET;
{  C  John Collins 1989-93
     Converts TeX file to ET format.

21 Jul 93 JCC  I think it is working now -- line breaks in constructs
               like fractions and sub/spuerscripts: they are forced
               onto a single line.
19 Jul 93 JCC  Aim to get newlines in middle of constructs correct
18 Jul 93 JCC  Treat space after CS like \frac correctly.
26 Jul 92 JCC  Remove space between arguments of fraction
 3 Jan 92 JCC  Beginnings of allowing use as filter
18 Aug 91 JCC  Allow long lines and UNIX files, by use of unixio.
27 Jan 91 JCC  Command line switches: copied code from ETTOTEX
               Switch translation of $ on and off.
13 Jan 90 JCC  Implement ET commands
11 Oct 90 JCC  \perp
 6 Sep 90 JCC  Great improvements on treating %ET- and comments,
               especially mixed with constructs
 5 Sep 90 JCC  Start working on arbitrarily long lines.  v 1.08.
 4 Sep 90 JCC  Support for fractions spanning lines.
 2 Aug 90 JCC  Fraction support.  Version 1.05.
          JCC  Don't write to later file.  Help on ? on cmdline.
 5 Oct 89 JCC

}

{$I etdirect.inc}            {Directives shared by all units}

Uses conv, utils, stderr, unixio, ETSyms, TeXETDef, TeXETSub;

const
   SignOn = 'TeX to ET converter 1.15.  JCC  21 Jul 93';

procedure help (level: integer);
  begin
    writeln ('Usage:');
    writeln ('      TEXTOET  switches NAME [NAME1 ..]');
    writeln ('   Makes TeX file NAME.ET from TeX file NAME.TEX, NAME1.TEX, ....');
    writeln ('      TEXTOET ? or TEXTOET /help');
    writeln ('   for detailed help.');
    if (level <= 0) then
       exit;
    writeln ('    ');
    writeln ('Switches are obeyed in order of occurence.  Upper and lower case');
    writeln ('are equivalent.  Legal switches:');
    writeln ('    /$tran       ');
    writeln ('    /$tran:yes   Translate $s and $$s');
    writeln ('    /no$tran');
    writeln ('    /$tran:no    Do not translate $s and $$s');
    writeln ('    /help             for this message.');
  end;

procedure ObeyCmdLine (var CmdLine: ParsedCmdLine;
                       var InitParams: Params; var Error: boolean);
    type YNB = (no, yes, bad);
    function nint (r: real): integer;
       begin nint := trunc(0.5+r); end;
    function yesno (s: string): YNB;
       begin
          UC(s);
          if (s = '') or GoodAbbrev(s, 'ON', 2) or GoodAbbrev(s, 'YES', 1) then
             yesno := yes
          else if GoodAbbrev(s, 'OFF', 2) or GoodAbbrev(s, 'NO', 1) then
             yesno := no
          else
             yesno := bad;
       end;
    var i, valcode: integer;
        value: real;
        valYNB: YNB;
  begin
    with CmdLine do begin
      for i := 1 to NumSw do begin
         Val (Tail[i], Value, valcode);
         ValYNB := yesno (Tail[i]);
         if GoodAbbrev (switch[i], '$TRAN', 2) then begin
            if (ValYNB = no) then
               InitParams.TranDollar := false
            else if (ValYNB = yes) then
               InitParams.TranDollar := true
            else begin
               write ('Bad value ''', Tail[i], ''' in ''');
               writeln (SwOrigin[i], '''.');
               Error := true;
            end;
         end else if GoodAbbrev (switch[i], 'No$TRAN', 4) then begin
            InitParams.TranDollar := false
         end else if GoodAbbrev (switch[i], 'HELP', 1) then begin
            help (1);
         end else begin
            writeln ('Bad switch name in ''', SwOrigin[i], '''.');
            Error := true;
         end;
      end {for};
    end {with};
  end;     {ObeyCmdLine}



var
   CmdLine : ParsedCmdLine;
   InitParams, MyParams : Params;
   sn, dn : FileName;
   i : integer;
   Error : boolean;

begin    { main program }
   Error := false;
   DefaultSettings (InitParams);
   writeln (SignOn);
   if ParamCount = 0 then begin
      help (0);
      halt (1);
   end;
   if (ParamCount = 1) and (ParamStr(1) = '?') then begin
      help (1);
      halt (1);
   end;

   ParseCmd (CmdLine);
   ObeyCmdLine (CmdLine, InitParams, Error);
   if Error then begin
      writeln ('Errors.  I will not continue.');
      halt(10);
   end;

   if CmdLine.NumFiles = 0 then
      writeln ('No files to process.');
   for i := 1 to CmdLine.NumFiles do begin
      MyParams := InitParams;
      sn := CmdLine.files[i];
      dn := sn;
      if sn <> '' then begin
         {Real files for i/o}
         sn := sn + '.TEX';
         dn := dn + '.ET';
      end;
      if sn = '' then begin
         {Run as filter}
         MyParams.SourceName := '';
         MyParams.DestName := '';
         ProcessTeXFile (MyParams);
      end else if not exist (sn) then begin
         writeln ('File ''', sn, ''' does not exist.');
      end else if exist (dn) and (FileTime(dn) > FileTime(sn)) then begin
         write ('The destination ET file ''', dn, ''' already exists, ');
         writeln ('and it is more recent than ');
         writeln ('the source TeX  file ''', sn, '''.  I will not convert it.  ');
      end else begin
         MyParams.SourceName := sn;
         MyParams.DestName := dn;
         ProcessTeXFile (MyParams);
      end;
    end; {for}
end.

