/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.gls2bib;

import com.dickimawbooks.bibgls.gls2bib.Gls2Bib;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GlsData {
    private static final Pattern SEE_PATTERN = Pattern.compile("\\{(?:\\[.*\\])?(.*)\\}");
    private String id;
    private String type;
    private String glosType;
    private String category;
    private HashMap<String, String> fields;

    public GlsData(String string) {
        this(string, "entry");
    }

    public GlsData(String string, String string2) {
        this.id = string;
        this.type = string2;
        this.fields = new HashMap();
    }

    public String getId() {
        return this.id;
    }

    public void setEntryType(String string) {
        this.type = string;
    }

    public void setGlossaryType(String string) {
        this.glosType = string;
    }

    public String getGlossaryType() {
        return this.glosType;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public String getCategory() {
        return this.category;
    }

    public void putField(String string, String string2) {
        this.fields.put(string, string2);
    }

    public String removeField(String string) {
        return this.fields.remove(string);
    }

    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("@%s{%s", this.type, this.id);
        Iterator<String> iterator = this.fields.keySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = iterator.next();
            printWriter.format(",%n  %s = %s", string, this.fields.get(string));
            bl = true;
        }
        if (bl) {
            printWriter.println();
        }
        printWriter.println("}");
        printWriter.println();
    }

    public void absorbSee(TeXParser teXParser, String string, String string2, String string3, String string4) {
        Gls2Bib gls2Bib = (Gls2Bib)teXParser.getListener().getTeXApp();
        String string5 = this.fields.get(string2);
        if (string5 == null) {
            if (string2.equals("see")) {
                this.fields.put(string2, String.format("{%s%s}", string4, string3));
            } else {
                this.fields.put(string2, String.format("{%s}", string3));
            }
            gls2Bib.message(gls2Bib.getMessage("gls2bib.absorbsee", string));
            return;
        }
        Matcher matcher = SEE_PATTERN.matcher(string5);
        if (matcher.matches()) {
            String string6 = matcher.group(1);
            Object[] objectArray = string6.split(" *, *");
            String[] stringArray = string3.split(",");
            String string7 = "";
            for (String string8 : stringArray) {
                if (Arrays.binarySearch(objectArray, string8) >= 0) continue;
                string7 = string7 + "," + string8;
            }
            this.fields.put(string2, string5.substring(0, string5.length() - 2) + string7 + "}");
            gls2Bib.message(gls2Bib.getMessage("gls2bib.absorbsee", string));
        } else {
            gls2Bib.warning(teXParser, gls2Bib.getMessage("gls2bib.absorbsee.failed", new Object[]{string, String.format("%s=%s", string2, string5)}));
        }
    }
}

