/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.stream;

import korlibs.io.stream.AsyncStreamBase;
import korlibs.memory.NumbersKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0011\u0010\u0018\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0011\u0010\u001b\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ1\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0016J1\u0010#\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lkorlibs/io/stream/SliceAsyncStreamBase;", "Lkorlibs/io/stream/AsyncStreamBase;", "base", "baseStart", "", "baseEnd", "closeParent", "", "(Lkorlibs/io/stream/AsyncStreamBase;JJZ)V", "getBase$korio", "()Lkorlibs/io/stream/AsyncStreamBase;", "getBaseEnd$korio", "()J", "baseLength", "getBaseLength$korio", "getBaseStart$korio", "getCloseParent$korio", "()Z", "clampPosition", "position", "clampPositionLen", "Lkotlin/Pair;", "", "len", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLength", "read", "buffer", "", "offset", "(J[BIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "", "write", "korio"})
public final class SliceAsyncStreamBase
extends AsyncStreamBase {
    @NotNull
    private final AsyncStreamBase base;
    private final long baseStart;
    private final long baseEnd;
    private final boolean closeParent;
    private final long baseLength;

    public SliceAsyncStreamBase(@NotNull AsyncStreamBase base, long baseStart, long baseEnd, boolean closeParent) {
        this.base = base;
        this.baseStart = baseStart;
        this.baseEnd = baseEnd;
        this.closeParent = closeParent;
        this.baseLength = this.baseEnd - this.baseStart;
    }

    @NotNull
    public final AsyncStreamBase getBase$korio() {
        return this.base;
    }

    public final long getBaseStart$korio() {
        return this.baseStart;
    }

    public final long getBaseEnd$korio() {
        return this.baseEnd;
    }

    public final boolean getCloseParent$korio() {
        return this.closeParent;
    }

    public final long getBaseLength$korio() {
        return this.baseLength;
    }

    private final long clampPosition(long position) {
        return NumbersKt.clamp(position, this.baseStart, this.baseEnd);
    }

    private final Pair<Long, Integer> clampPositionLen(long position, int len) {
        if (position < 0L) {
            throw new IllegalArgumentException("Invalid position");
        }
        long targetStartPosition = this.clampPosition(this.baseStart + position);
        long targetEndPosition = this.clampPosition(targetStartPosition + (long)len);
        int targetLen = (int)(targetEndPosition - targetStartPosition);
        return new Pair<Long, Integer>(targetStartPosition, targetLen);
    }

    @Override
    @Nullable
    public Object read(long position, @NotNull byte[] buffer, int offset, int len, @NotNull Continuation<? super Integer> $completion) {
        Pair<Long, Integer> pair = this.clampPositionLen(position, len);
        long targetStartPosition = ((Number)pair.component1()).longValue();
        int targetLen = ((Number)pair.component2()).intValue();
        return this.base.read(targetStartPosition, buffer, offset, targetLen, $completion);
    }

    @Override
    @Nullable
    public Object write(long position, @NotNull byte[] buffer, int offset, int len, @NotNull Continuation<? super Unit> $completion) {
        Pair<Long, Integer> pair = this.clampPositionLen(position, len);
        long targetStartPosition = ((Number)pair.component1()).longValue();
        int targetLen = ((Number)pair.component2()).intValue();
        Object object = this.base.write(targetStartPosition, buffer, offset, targetLen, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getLength(@NotNull Continuation<? super Long> $completion) {
        return Boxing.boxLong(this.baseLength);
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        if (this.closeParent) {
            Object object = this.base.close($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return "SliceAsyncStreamBase(" + this.base + ", " + this.baseStart + ", " + this.baseEnd + ')';
    }
}

