/**
 * Authors : quentin.vaney@gmail.com;xavier.frelechoz@gmail.com
 * Version : V1
 */

package LaTexScreenshooter;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;

    public class PathValidator {

        public static boolean isPathValid(String pathString) {
            try {
                Path path = Paths.get(pathString);
                if (Files.exists(path) && Files.isDirectory(path)) {
                    System.out.println("Success: Path is a valid directory.");
                    System.out.println(pathString);
                    return true;
                } else {
                    System.out.println("Fail: Path exists but is not a directory.");
                    System.out.println(pathString);
                    return false;
                }
            } catch (InvalidPathException | NullPointerException ex) {
                System.out.println("Fail: File path is incorrect.");
                System.out.println(pathString);
                return false;
            }
        }
}