/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.extractors;

import java.util.ArrayList;
import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SaVariable;
import jdplus.sa.base.core.SaBenchmarkingResults;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.x13.base.core.x11.X11Results;
import jdplus.x13.base.core.x13.X13Diagnostics;
import jdplus.x13.base.core.x13.X13Factory;
import jdplus.x13.base.core.x13.X13Results;

public class X13Extractor
extends InformationMapping<X13Results> {
    private String decompositionItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"decomposition", key});
    }

    private String preadjustItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"preadjustment", key});
    }

    private String finalItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"finals", key});
    }

    private String advancedItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"regression.details", key});
    }

    private String qualityItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"quality", key});
    }

    public X13Extractor() {
        this.set("mode", DecompositionMode.class, source -> source.getDecomposition() == null ? null : source.getDecomposition().getMode());
        this.set("seasonal", Integer.class, source -> {
            if (source.getDecomposition() == null) {
                return null;
            }
            TsData s = source.getDecomposition().getD10();
            if (s == null) {
                return 0;
            }
            double x0 = s.getValue(0);
            return s.getValues().allMatch(x -> x == x0) ? 0 : 1;
        });
        this.set(this.preadjustItem("a1"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA1());
        this.set(this.preadjustItem("a1a"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA1a());
        this.set(this.preadjustItem("a1b"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA1b());
        this.set(this.preadjustItem("a6"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA6());
        this.set(this.preadjustItem("a7"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA7());
        this.set(this.preadjustItem("a8"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA8());
        this.set(this.preadjustItem("a8i"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA8i());
        this.set(this.preadjustItem("a8s"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA8s());
        this.set(this.preadjustItem("a8t"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA8t());
        this.set(this.preadjustItem("a9"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA9());
        this.set(this.preadjustItem("a9sa"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA9sa());
        this.set(this.preadjustItem("a9u"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA9u());
        this.set(this.preadjustItem("a9ser"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA9ser());
        this.set(this.preadjustItem("a9cal"), TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA9cal());
        this.set("s", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD16());
        this.set("s_f", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD16a());
        this.set("s_b", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD16b());
        this.set("sa", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD11final());
        this.set("sa_f", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD11a());
        this.set("sa_b", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD11b());
        this.set("t", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD12final());
        this.set("t_f", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD12a());
        this.set("t_b", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD12b());
        this.set("i", TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD13final());
        this.set("i_f", TsData.class, source -> {
            if (source.getFinals() == null) {
                return null;
            }
            TsData d12a = source.getFinals().getD12a();
            if (d12a == null || d12a.size() == 0) {
                return null;
            }
            DecompositionMode mode = source.getDecomposition().getMode();
            double m = mode.isMultiplicative() ? 1.0 : 0.0;
            return TsData.of((TsPeriod)d12a.getStart(), (DoubleSeq)DoubleSeq.onMapping((int)d12a.size(), i -> m));
        });
        this.set("i_b", TsData.class, source -> {
            if (source.getFinals() == null) {
                return null;
            }
            TsData d12b = source.getFinals().getD12b();
            if (d12b == null || d12b.size() == 0) {
                return null;
            }
            DecompositionMode mode = source.getDecomposition().getMode();
            double m = mode.isMultiplicative() ? 1.0 : 0.0;
            return TsData.of((TsPeriod)d12b.getStart(), (DoubleSeq)DoubleSeq.onMapping((int)d12b.size(), i -> m));
        });
        this.set(this.decompositionItem("y_cmp"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getB1(), (TsDomain)source.getDecomposition().getActualDomain()));
        this.set(this.decompositionItem("y_cmp_f"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getB1(), (TsDomain)source.getDecomposition().getForecastDomain()));
        this.set(this.decompositionItem("y_cmp_b"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getB1(), (TsDomain)source.getDecomposition().getBackcastDomain()));
        this.set(this.decompositionItem("s_cmp"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD10(), (TsDomain)source.getDecomposition().getActualDomain()));
        this.set(this.decompositionItem("s_cmp_f"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD10(), (TsDomain)source.getDecomposition().getForecastDomain()));
        this.set(this.decompositionItem("s_cmp_b"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD10(), (TsDomain)source.getDecomposition().getBackcastDomain()));
        this.set(this.decompositionItem("sa_cmp"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD11(), (TsDomain)source.getDecomposition().getActualDomain()));
        this.set(this.decompositionItem("sa_cmp_f"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD11(), (TsDomain)source.getDecomposition().getForecastDomain()));
        this.set(this.decompositionItem("sa_cmp_b"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD11(), (TsDomain)source.getDecomposition().getBackcastDomain()));
        this.set(this.decompositionItem("t_cmp"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD12(), (TsDomain)source.getDecomposition().getActualDomain()));
        this.set(this.decompositionItem("t_cmp_f"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD12(), (TsDomain)source.getDecomposition().getForecastDomain()));
        this.set(this.decompositionItem("t_cmp_b"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD12(), (TsDomain)source.getDecomposition().getBackcastDomain()));
        this.set(this.decompositionItem("i_cmp"), TsData.class, source -> source.getDecomposition() == null ? null : source.getDecomposition().getD13());
        this.set(this.decompositionItem("si_cmp"), TsData.class, source -> source.getDecomposition() == null ? null : TsData.fitToDomain((TsData)source.getDecomposition().getD8(), (TsDomain)source.getDecomposition().getActualDomain()));
        this.set("y", TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA1());
        this.set("y_b", TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA1b());
        this.set("y_f", TsData.class, source -> source.getPreadjustment() == null ? null : source.getPreadjustment().getA1a());
        this.set(this.finalItem("d11"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD11final());
        this.set(this.finalItem("d12"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD12final());
        this.set(this.finalItem("d13"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD13final());
        this.set(this.finalItem("d16"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD16());
        this.set(this.finalItem("d18"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD18());
        this.set(this.finalItem("d11a"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD11a());
        this.set(this.finalItem("d12a"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD12a());
        this.set(this.finalItem("d16a"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD16a());
        this.set(this.finalItem("d18a"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD18a());
        this.set(this.finalItem("d11b"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD11b());
        this.set(this.finalItem("d12b"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD12b());
        this.set(this.finalItem("d16b"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD16b());
        this.set(this.finalItem("d18b"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getD18b());
        this.set(this.finalItem("e1"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getE1());
        this.set(this.finalItem("e2"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getE2());
        this.set(this.finalItem("e3"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getE3());
        this.set(this.finalItem("e11"), TsData.class, source -> source.getFinals() == null ? null : source.getFinals().getE11());
        this.set(this.advancedItem("type"), int[].class, source -> {
            if (source.getPreprocessing() == null) {
                return null;
            }
            GeneralLinearModel.Description desc = source.getPreprocessing().getDescription();
            Variable[] vars = desc.getVariables();
            IntList list = new IntList();
            for (int i = 0; i < vars.length; ++i) {
                int n = vars[i].freeCoefficientsCount();
                if (n <= 0) continue;
                ComponentType regressionEffect = SaVariable.regressionEffect((Variable)vars[i]);
                for (int j = 0; j < n; ++j) {
                    list.add(regressionEffect.toInt());
                }
            }
            return list.toArray();
        });
        this.delegate(null, RegSarimaModel.class, source -> source.getPreprocessing());
        this.delegate("decomposition", X11Results.class, source -> source.getDecomposition());
        this.delegate(null, X13Diagnostics.class, source -> source.getDiagnostics());
        this.set(this.qualityItem("summary"), String.class, source -> {
            ArrayList tests = new ArrayList();
            X13Factory.getInstance().fillDiagnostics(tests, null, (Explorable)source);
            ProcQuality quality = ProcDiagnostic.summary(tests);
            return quality.name();
        });
        this.delegate("benchmarking", SaBenchmarkingResults.class, source -> source.getBenchmarking());
    }

    public Class getSourceClass() {
        return X13Results.class;
    }
}

