/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.Generated;

public final class X11FilterFactory {
    public static SymmetricFilter makeMCDFilter(double[] data) {
        int idx = -1;
        for (int i = data.length - 1; i >= 0; --i) {
            if (!(data[i] >= 1.0)) continue;
            idx = i + 2;
            break;
        }
        if (idx == -1) {
            return X11FilterFactory.makeSymmetricFilter(0);
        }
        if (idx > 6) {
            return X11FilterFactory.makeSymmetricFilter(2, 6);
        }
        if (idx % 2 == 0) {
            return X11FilterFactory.makeSymmetricFilter(2, idx);
        }
        return X11FilterFactory.makeSymmetricFilter(idx / 2);
    }

    public static SymmetricFilter makeSymmetricFilter(int m, int n) {
        Polynomial M = X11FilterFactory.simpleFilter(m);
        Polynomial N = X11FilterFactory.simpleFilter(n);
        return SymmetricFilter.of((DoubleSeq)M.times(N).coefficients());
    }

    public static Polynomial simpleFilter(int len) {
        double[] c = new double[len];
        double w = 1.0 / (double)len;
        for (int i = 0; i < len; ++i) {
            c[i] = w;
        }
        return Polynomial.of((double[])c);
    }

    public static SymmetricFilter makeSymmetricFilter(int length) {
        double we;
        int len = length;
        double flen = len % 2 == 0 ? 1.0 : 0.0;
        int ilen = (len + 1) / 2;
        double[] c = new double[ilen + 1];
        double w = 1.0 / (double)len;
        for (int i = 0; i < c.length - 1; ++i) {
            c[i] = w;
        }
        c[ilen] = we = flen / 2.0 / (double)len;
        return SymmetricFilter.ofInternal((double[])c);
    }

    @Generated
    private X11FilterFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

