/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool.sum;

import choco.cp.solver.constraints.integer.bool.sum.AbstractBoolSum;
import choco.cp.solver.constraints.integer.bool.sum.LeqBoolSum;
import choco.kernel.common.util.tools.MathUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;

public final class GeqBoolSum
extends AbstractBoolSum {
    public GeqBoolSum(IEnvironment environment, IntDomainVar[] vars, int bValue) {
        super(environment, vars, bValue);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        super.awakeOnInst(idx);
        this.boolSumS.awakeOnGeq();
    }

    @Override
    public void awake() throws ContradictionException {
        int val;
        int max = this.boolSumS.computeUbFromScratch();
        if (max < (val = this.boolSumS.bValue)) {
            this.fail();
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.boolSumS.filterGeq()) {
            super.propagate();
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return MathUtils.sum(tuple) >= this.boolSumS.bValue;
    }

    @Override
    public Boolean isEntailed() {
        return this.boolSumS.isEntailedGeq();
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return new LeqBoolSum(solver.getEnvironment(), (IntDomainVar[])Arrays.copyOf(this.vars, ((IntDomainVar[])this.vars).length), this.boolSumS.bValue - 1);
    }

    @Override
    public String pretty() {
        return this.boolSumS.pretty(">=");
    }
}

