/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.deduction;

import choco.cp.solver.constraints.global.tree.deduction.AbstractDeduction;
import choco.kernel.memory.IStateBitSet;
import java.util.BitSet;
import java.util.logging.Level;

public class IncompGraphDeduction
extends AbstractDeduction {
    public IncompGraphDeduction(Object[] params) {
        super(params);
    }

    public void updateIncompGraphWithDeductions() {
        this.update = false;
        this.compatible = true;
        this.updateIncFromInst();
        this.updateIncFromPrecs();
    }

    private void updateIncFromInst() {
        IStateBitSet[] trueGraph = this.inputGraph.getSure().getGraph();
        for (int i = 0; i < this.nbVertices; ++i) {
            int j = trueGraph[i].nextSetBit(0);
            while (j >= 0) {
                IStateBitSet inc_i = this.incomp.getSuccessors(i);
                IStateBitSet A_j = this.inputGraph.getGlobal().getAncestors(j);
                if (i != j) {
                    IStateBitSet inc = this.substractBitSet(inc_i, A_j);
                    int k = inc.nextSetBit(0);
                    while (k >= 0) {
                        if (j < k && !this.incomp.getSuccessors(j).get(k)) {
                            if (this.affiche) {
                                LOGGER.log(Level.INFO, "11- updateIncFromInst(): on ajoute ({0}, {1})", new Object[]{j, k});
                            }
                            this.update = true;
                            this.incomp.addArc(j, k);
                        }
                        if (k < j && !this.incomp.getSuccessors(k).get(j)) {
                            if (this.affiche) {
                                LOGGER.log(Level.INFO, "12- updateIncFromInst(): on ajoute ({0}, {1})", new Object[]{k, j});
                            }
                            this.update = true;
                            this.incomp.addArc(k, j);
                        }
                        k = inc.nextSetBit(k + 1);
                    }
                }
                j = trueGraph[i].nextSetBit(j + 1);
            }
        }
    }

    private void updateIncFromPrecs() {
        for (int u = 0; u < this.nbVertices; ++u) {
            BitSet A_u = this.precs.getAncestors(u);
            A_u.set(u, true);
            IStateBitSet inc_u = this.incomp.getSuccessors(u);
            if (inc_u.cardinality() <= 0) continue;
            int u_a = A_u.nextSetBit(0);
            while (u_a >= 0) {
                int v = inc_u.nextSetBit(0);
                while (v >= 0) {
                    BitSet A_v = this.precs.getAncestors(v);
                    A_v.set(v, true);
                    int v_a = A_v.nextSetBit(0);
                    while (v_a >= 0) {
                        if (u_a < v_a && !this.incomp.getSuccessors(u_a).get(v_a)) {
                            if (this.affiche) {
                                LOGGER.log(Level.INFO, "1- updateIncFromRemoval(): on ajoute ({0}, {1})", new Object[]{u_a, v_a});
                            }
                            this.update = true;
                            this.incomp.addArc(u_a, v_a);
                        }
                        if (v_a < u_a && !this.incomp.getSuccessors(v_a).get(u_a)) {
                            if (this.affiche) {
                                LOGGER.log(Level.INFO, "2- updateIncFromRemoval(): on ajoute ({0}, {1})", new Object[]{v_a, u_a});
                            }
                            this.update = true;
                            this.incomp.addArc(v_a, u_a);
                        }
                        v_a = A_v.nextSetBit(v_a + 1);
                    }
                    BitSet D_v = this.precs.getDescendants(v);
                    D_v.set(v, false);
                    int v_d = D_v.nextSetBit(0);
                    while (v_d >= 0) {
                        if (u_a != u && this.incomp.getSuccessors(v_d).get(u_a)) {
                            if (u < v_d && !this.incomp.getSuccessors(u).get(v_d)) {
                                if (this.affiche) {
                                    LOGGER.log(Level.INFO, "3- updateIncFromRemoval(): on ajoute ({0}, {1})", new Object[]{u, v_d});
                                }
                                this.update = true;
                                this.incomp.addArc(u, v_d);
                            }
                            if (v_d < u && !this.incomp.getSuccessors(v_d).get(u)) {
                                if (this.affiche) {
                                    LOGGER.log(Level.INFO, "4- updateIncFromRemoval(): on ajoute ({0}, {1})", new Object[]{v_d, u});
                                }
                                this.update = true;
                                this.incomp.addArc(v_d, u);
                            }
                            if (v < u_a && !this.incomp.getSuccessors(v).get(u_a)) {
                                if (this.affiche) {
                                    LOGGER.log(Level.INFO, "5- updateIncFromRemoval(): on ajoute ({0}, {1})", new Object[]{v, u_a});
                                }
                                this.update = true;
                                this.incomp.addArc(v, u_a);
                            }
                            if (u_a < v && !this.incomp.getSuccessors(u_a).get(v)) {
                                if (this.affiche) {
                                    LOGGER.log(Level.INFO, "6- updateIncFromRemoval(): on ajoute ({0}, {1})", new Object[]{u_a, v});
                                }
                                this.update = true;
                                this.incomp.addArc(u_a, v);
                            }
                        }
                        v_d = D_v.nextSetBit(v_d + 1);
                    }
                    v = inc_u.nextSetBit(v + 1);
                }
                u_a = A_u.nextSetBit(u_a + 1);
            }
        }
    }

    private IStateBitSet substractBitSet(IStateBitSet a, IStateBitSet b) {
        IStateBitSet res = a.copy();
        res.and(b);
        res.xor(a);
        return res;
    }
}

