/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import java.util.function.DoubleUnaryOperator;

public enum WeightFunction {
    UNIFORM,
    TRIANGULAR,
    EPANECHNIKOV,
    TRICUBE,
    TRIWEIGHT,
    BIWEIGHT;


    public DoubleUnaryOperator asFunction() {
        return switch (this.ordinal()) {
            case 2 -> x -> 1.0 - x * x;
            case 1 -> x -> 1.0 - Math.abs(x);
            case 5 -> x -> {
                double z = 1.0 - x * x;
                return z * z;
            };
            case 4 -> x -> {
                double z = 1.0 - x * x;
                return z * z * z;
            };
            case 3 -> x -> {
                double v = Math.abs(x);
                double z = 1.0 - v * v * v;
                return z * z * z;
            };
            default -> x -> 1.0;
        };
    }
}

