/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.regarima.AutoModelSpec;
import jdplus.x13.base.api.regarima.BasicSpec;
import jdplus.x13.base.api.regarima.EasterSpec;
import jdplus.x13.base.api.regarima.EstimateSpec;
import jdplus.x13.base.api.regarima.OutlierSpec;
import jdplus.x13.base.api.regarima.RegArimaException;
import jdplus.x13.base.api.regarima.RegressionSpec;
import jdplus.x13.base.api.regarima.RegressionTestSpec;
import jdplus.x13.base.api.regarima.SingleOutlierSpec;
import jdplus.x13.base.api.regarima.TradingDaysSpec;
import jdplus.x13.base.api.regarima.TransformSpec;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegArimaSpec
implements Validatable<RegArimaSpec>,
ProcSpecification {
    public static final String METHOD = "regarima";
    public static final String FAMILY = "Modelling";
    public static final String VERSION_LEGACY = "0.1.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR_LEGACY = new AlgorithmDescriptor("Modelling", "regarima", "0.1.0.0");
    public static final String VERSION_V3 = "3.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR_V3 = new AlgorithmDescriptor("Modelling", "regarima", "3.0.0");
    public static final RegArimaSpec DEFAULT_ENABLED = (RegArimaSpec)RegArimaSpec.builder().build();
    public static final RegArimaSpec DEFAULT_DISABLED = (RegArimaSpec)RegArimaSpec.builder().basic(BasicSpec.DEFAULT_ENABLED).build();
    private final BasicSpec basic;
    private final TransformSpec transform;
    private final RegressionSpec regression;
    private final OutlierSpec outliers;
    private final AutoModelSpec autoModel;
    private final SarimaSpec arima;
    private final EstimateSpec estimate;
    public static final RegArimaSpec RGDISABLED = (RegArimaSpec)RegArimaSpec.builder().basic((BasicSpec)BasicSpec.builder().preprocessing(false).build()).build();
    public static final RegArimaSpec RG0;
    public static final RegArimaSpec RG1;
    public static final RegArimaSpec RG2;
    public static final RegArimaSpec RG3;
    public static final RegArimaSpec RG4;
    public static final RegArimaSpec RG5;
    private static final String SMETHOD = "RG";

    public AlgorithmDescriptor getAlgorithmDescriptor() {
        return DESCRIPTOR_V3;
    }

    public static Builder builder() {
        SarimaSpec arima = SarimaSpec.airline();
        return new Builder().basic((BasicSpec)BasicSpec.builder().build()).transform((TransformSpec)TransformSpec.builder().build()).estimate((EstimateSpec)EstimateSpec.builder().build()).autoModel((AutoModelSpec)AutoModelSpec.builder().build()).outliers((OutlierSpec)OutlierSpec.builder().build()).arima(arima).regression((RegressionSpec)RegressionSpec.builder().build());
    }

    public boolean isUsingAutoModel() {
        return this.autoModel.isEnabled();
    }

    public RegArimaSpec validate() throws IllegalArgumentException {
        this.basic.validate();
        this.transform.validate();
        this.regression.validate();
        this.outliers.validate();
        this.autoModel.validate();
        this.estimate.validate();
        return this;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_ENABLED);
    }

    public static final RegArimaSpec[] allSpecifications() {
        return new RegArimaSpec[]{RG0, RG1, RG2, RG3, RG4, RG5};
    }

    public static RegArimaSpec fromString(String name) {
        switch (name) {
            case "RG0": 
            case "rg0": {
                return RG0;
            }
            case "RG1": 
            case "rg1": {
                return RG1;
            }
            case "RG2c": 
            case "rg2c": 
            case "RG2": 
            case "rg2": {
                return RG2;
            }
            case "RG3": 
            case "rg3": {
                return RG3;
            }
            case "RG4c": 
            case "rg4c": 
            case "RG4": 
            case "rg4": {
                return RG4;
            }
            case "RG5c": 
            case "rg5c": 
            case "RG5": 
            case "rg5": {
                return RG5;
            }
        }
        throw new RegArimaException();
    }

    public String display() {
        if (this == RG0) {
            return "RG0";
        }
        if (this == RG1) {
            return "RG1";
        }
        if (this == RG2) {
            return "RG2";
        }
        if (this == RG3) {
            return "RG3";
        }
        if (this == RG4) {
            return "RG4";
        }
        if (this == RG5) {
            return "RG5";
        }
        if (this.equals(RG0)) {
            return "RG0";
        }
        if (this.equals(RG1)) {
            return "RG1";
        }
        if (this.equals(RG2)) {
            return "RG2";
        }
        if (this.equals(RG3)) {
            return "RG3";
        }
        if (this.equals(RG4)) {
            return "RG4";
        }
        if (this.equals(RG5)) {
            return "RG5";
        }
        return SMETHOD;
    }

    @Generated
    RegArimaSpec(BasicSpec basic, TransformSpec transform, RegressionSpec regression, OutlierSpec outliers, AutoModelSpec autoModel, SarimaSpec arima, EstimateSpec estimate) {
        this.basic = basic;
        this.transform = transform;
        this.regression = regression;
        this.outliers = outliers;
        this.autoModel = autoModel;
        this.arima = arima;
        this.estimate = estimate;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().basic(this.basic).transform(this.transform).regression(this.regression).outliers(this.outliers).autoModel(this.autoModel).arima(this.arima).estimate(this.estimate);
    }

    @Generated
    public BasicSpec getBasic() {
        return this.basic;
    }

    @Generated
    public TransformSpec getTransform() {
        return this.transform;
    }

    @Generated
    public RegressionSpec getRegression() {
        return this.regression;
    }

    @Generated
    public OutlierSpec getOutliers() {
        return this.outliers;
    }

    @Generated
    public AutoModelSpec getAutoModel() {
        return this.autoModel;
    }

    @Generated
    public SarimaSpec getArima() {
        return this.arima;
    }

    @Generated
    public EstimateSpec getEstimate() {
        return this.estimate;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegArimaSpec)) {
            return false;
        }
        RegArimaSpec other = (RegArimaSpec)o;
        BasicSpec this$basic = this.getBasic();
        BasicSpec other$basic = other.getBasic();
        if (this$basic == null ? other$basic != null : !((Object)this$basic).equals(other$basic)) {
            return false;
        }
        TransformSpec this$transform = this.getTransform();
        TransformSpec other$transform = other.getTransform();
        if (this$transform == null ? other$transform != null : !((Object)this$transform).equals(other$transform)) {
            return false;
        }
        RegressionSpec this$regression = this.getRegression();
        RegressionSpec other$regression = other.getRegression();
        if (this$regression == null ? other$regression != null : !((Object)this$regression).equals(other$regression)) {
            return false;
        }
        OutlierSpec this$outliers = this.getOutliers();
        OutlierSpec other$outliers = other.getOutliers();
        if (this$outliers == null ? other$outliers != null : !((Object)this$outliers).equals(other$outliers)) {
            return false;
        }
        AutoModelSpec this$autoModel = this.getAutoModel();
        AutoModelSpec other$autoModel = other.getAutoModel();
        if (this$autoModel == null ? other$autoModel != null : !((Object)this$autoModel).equals(other$autoModel)) {
            return false;
        }
        SarimaSpec this$arima = this.getArima();
        SarimaSpec other$arima = other.getArima();
        if (this$arima == null ? other$arima != null : !this$arima.equals(other$arima)) {
            return false;
        }
        EstimateSpec this$estimate = this.getEstimate();
        EstimateSpec other$estimate = other.getEstimate();
        return !(this$estimate == null ? other$estimate != null : !((Object)this$estimate).equals(other$estimate));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BasicSpec $basic = this.getBasic();
        result = result * 59 + ($basic == null ? 43 : ((Object)$basic).hashCode());
        TransformSpec $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : ((Object)$transform).hashCode());
        RegressionSpec $regression = this.getRegression();
        result = result * 59 + ($regression == null ? 43 : ((Object)$regression).hashCode());
        OutlierSpec $outliers = this.getOutliers();
        result = result * 59 + ($outliers == null ? 43 : ((Object)$outliers).hashCode());
        AutoModelSpec $autoModel = this.getAutoModel();
        result = result * 59 + ($autoModel == null ? 43 : ((Object)$autoModel).hashCode());
        SarimaSpec $arima = this.getArima();
        result = result * 59 + ($arima == null ? 43 : $arima.hashCode());
        EstimateSpec $estimate = this.getEstimate();
        result = result * 59 + ($estimate == null ? 43 : ((Object)$estimate).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "RegArimaSpec(basic=" + String.valueOf(this.getBasic()) + ", transform=" + String.valueOf(this.getTransform()) + ", regression=" + String.valueOf(this.getRegression()) + ", outliers=" + String.valueOf(this.getOutliers()) + ", autoModel=" + String.valueOf(this.getAutoModel()) + ", arima=" + String.valueOf(this.getArima()) + ", estimate=" + String.valueOf(this.getEstimate()) + ")";
    }

    static {
        TransformSpec tr = (TransformSpec)TransformSpec.builder().function(TransformationType.Auto).build();
        EasterSpec easter = (EasterSpec)EasterSpec.builder().easterSpec(true).build();
        TradingDaysSpec wd = TradingDaysSpec.td(TradingDaysType.TD2, LengthOfPeriodType.LeapYear, RegressionTestSpec.Remove, true);
        TradingDaysSpec td = TradingDaysSpec.td(TradingDaysType.TD7, LengthOfPeriodType.LeapYear, RegressionTestSpec.Remove, true);
        RegressionSpec rwd = (RegressionSpec)RegressionSpec.builder().easter(easter).tradingDays(wd).build();
        RegressionSpec rtd = (RegressionSpec)RegressionSpec.builder().easter(easter).tradingDays(td).build();
        OutlierSpec o = (OutlierSpec)OutlierSpec.builder().type(new SingleOutlierSpec("AO", 0.0)).type(new SingleOutlierSpec("LS", 0.0)).type(new SingleOutlierSpec("TC", 0.0)).build();
        RG0 = DEFAULT_ENABLED;
        RG1 = (RegArimaSpec)RegArimaSpec.builder().transform(tr).outliers(o).build();
        RG2 = (RegArimaSpec)RegArimaSpec.builder().transform(tr).outliers(o).regression(rwd).build();
        RG3 = (RegArimaSpec)RegArimaSpec.builder().transform(tr).outliers(o).usingAutoModel(true).build();
        RG4 = (RegArimaSpec)RegArimaSpec.builder().transform(tr).outliers(o).regression(rwd).usingAutoModel(true).build();
        RG5 = (RegArimaSpec)RegArimaSpec.builder().transform(tr).outliers(o).regression(rtd).usingAutoModel(true).build();
    }

    public static class Builder
    implements Validatable.Builder<RegArimaSpec> {
        @Generated
        private BasicSpec basic;
        @Generated
        private TransformSpec transform;
        @Generated
        private RegressionSpec regression;
        @Generated
        private OutlierSpec outliers;
        @Generated
        private AutoModelSpec autoModel;
        @Generated
        private SarimaSpec arima;
        @Generated
        private EstimateSpec estimate;

        public Builder usingAutoModel(boolean enableAutoModel) {
            this.autoModel = (AutoModelSpec)this.autoModel.toBuilder().enabled(enableAutoModel).build();
            return this;
        }

        public Builder arima(@lombok.NonNull SarimaSpec sarima) {
            if (sarima == null) {
                throw new NullPointerException("sarima is marked non-null but is null");
            }
            this.arima = sarima;
            if (this.autoModel == null) {
                this.autoModel = (AutoModelSpec)AutoModelSpec.builder().build();
            }
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder basic(BasicSpec basic) {
            this.basic = basic;
            return this;
        }

        @Generated
        public @NonNull Builder transform(TransformSpec transform) {
            this.transform = transform;
            return this;
        }

        @Generated
        public @NonNull Builder regression(RegressionSpec regression) {
            this.regression = regression;
            return this;
        }

        @Generated
        public @NonNull Builder outliers(OutlierSpec outliers) {
            this.outliers = outliers;
            return this;
        }

        @Generated
        public @NonNull Builder autoModel(AutoModelSpec autoModel) {
            this.autoModel = autoModel;
            return this;
        }

        @Generated
        public @NonNull Builder estimate(EstimateSpec estimate) {
            this.estimate = estimate;
            return this;
        }

        @Generated
        public @NonNull RegArimaSpec buildWithoutValidation() {
            return new RegArimaSpec(this.basic, this.transform, this.regression, this.outliers, this.autoModel, this.arima, this.estimate);
        }

        @Generated
        public @NonNull String toString() {
            return "RegArimaSpec.Builder(basic=" + String.valueOf(this.basic) + ", transform=" + String.valueOf(this.transform) + ", regression=" + String.valueOf(this.regression) + ", outliers=" + String.valueOf(this.outliers) + ", autoModel=" + String.valueOf(this.autoModel) + ", arima=" + String.valueOf(this.arima) + ", estimate=" + String.valueOf(this.estimate) + ")";
        }
    }
}

